#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/ProtocolInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "ProtocolInfo.h"
#include "FunctionTracer.h"

namespace bmcore
{
   ProtocolInfo::ProtocolInfo() :
         _name(""), _version(0), _isSupported(false), _favoriteIndex(0u)
   {
      ENTRY_INTERNAL
   }

   ProtocolInfo::ProtocolInfo(IN const ProtocolName& name, IN const ProtocolVersion version,
         IN const bool isSupported, IN const FavoriteIndex favoriteIndex) :
         _name(name), _version(version), _isSupported(isSupported), _favoriteIndex(favoriteIndex)
   {
      ENTRY_INTERNAL
   }

   ProtocolInfo::ProtocolInfo(const ProtocolInfo& other) :
         _name(other._name), _version(other._version), _isSupported(other._isSupported),
         _favoriteIndex(other._favoriteIndex)
   {
      ENTRY_INTERNAL
   }

   ProtocolInfo::~ProtocolInfo()
   {
      ENTRY_INTERNAL
   }

   void swap(ProtocolInfo& first, ProtocolInfo& second)
   {
      using std::swap;

      swap(first._name, second._name);
      swap(first._version, second._version);
      swap(first._isSupported, second._isSupported);
      swap(first._favoriteIndex, second._favoriteIndex);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   ProtocolInfo& ProtocolInfo::operator=(ProtocolInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool ProtocolInfo::operator==(const ProtocolInfo& rhs) const
   {
      return ((this->_name == rhs._name) && (this->_version == rhs._version)
            && (this->_isSupported == rhs._isSupported)
            && (this->_favoriteIndex == rhs._favoriteIndex));
   }
}
