
#ifndef _PROTOCOL_CONNECTION_INFO_H_
#define _PROTOCOL_CONNECTION_INFO_H_

#include "BmInterfaceTypesInternal.h"
#include <map>

namespace bmcore
{
   class ProtocolConnectionInfo
   {
   public:
      ProtocolConnectionInfo();

      ProtocolConnectionInfo(const ConnectionStatus& connectionStatus, const DisconnectedReason& disconnectedReason,
            const RfcommDevicePath& _rfcommDevicePath, const unsigned int primary);

      ProtocolConnectionInfo(const ProtocolConnectionInfo& other);

      virtual ~ProtocolConnectionInfo();

      friend void swap(ProtocolConnectionInfo& first, ProtocolConnectionInfo& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      ProtocolConnectionInfo& operator=(ProtocolConnectionInfo other);

      bool operator==(const ProtocolConnectionInfo& rhs) const;

      bool operator!=(const ProtocolConnectionInfo& rhs) const;

      ConnectionStatus   _connectionStatus;
      DisconnectedReason _disconnectedReason;
      RfcommDevicePath   _rfcommDevicePath;
      unsigned int _primary;
   };

   typedef std::map<ProtocolId, ProtocolConnectionInfo> ProtocolConnectionInfoMap;
   typedef std::map<Uuid, ProtocolConnectionInfo> SppConnectionInfoMap;
}


#endif /* _PROTOCOL_CONNECTION_INFO_H_ */
