
#ifndef _PROTOCOL_H_
#define _PROTOCOL_H_

#include "BmInterfaceTypesInternal.h"
#include <functional>

namespace bmcore
{
   class Protocol
   {
   public:
      Protocol();

      Protocol(const ProtocolId& protocolId, const Uuid& uuid);

      Protocol(const Protocol& other);

      virtual ~Protocol();

      friend void swap(Protocol& first, Protocol& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      Protocol& operator=(Protocol other);

      bool operator==(const Protocol& rhs) const;

      bool operator<(const Protocol& rhs) const;

      bool operator!=(const Protocol& rhs) const;

      ProtocolId _protocolId;
      Uuid       _uuid;
   };

   typedef std::map<Protocol, BlockState> ProtocolBlockStatusMap;
}

#endif // _PROTOCOL_H_
