#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/Protocol.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "Protocol.h"
#include "FunctionTracer.h"

namespace bmcore
{
   Protocol::Protocol() :
         _protocolId(BM_PROTOCOL_ID_UNKNOWN), _uuid("")
   {
      ENTRY_INTERNAL
   }

   Protocol::Protocol(const ProtocolId& protocolId, const Uuid& uuid) :
         _protocolId(protocolId), _uuid(uuid)
   {
      ENTRY_INTERNAL
   }

   Protocol::Protocol(const Protocol& other) :
      _protocolId(other._protocolId), _uuid(other._uuid)
   {
      ENTRY_INTERNAL
   }

   Protocol::~Protocol()
   {
      ENTRY_INTERNAL
   }

   void swap(Protocol& first, Protocol& second)
   {
      using std::swap;

      swap(first._protocolId, second._protocolId);
      swap(first._uuid, second._uuid);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   Protocol& Protocol::operator=(Protocol other)
   {
      swap(*this, other);

      return *this;
   }

   bool Protocol::operator==(const Protocol& rhs) const
   {
      return ((this->_protocolId == rhs._protocolId)
            && (this->_uuid == rhs._uuid));
   }

   bool Protocol::operator<(const Protocol& rhs) const
   {
      if (this->_protocolId < rhs._protocolId)
      {
         return true;
      }
      else if (this->_protocolId > rhs._protocolId)
      {
         return false;
      }
      else
      {
         return (this->_uuid < rhs._uuid);
      }
   }

   bool Protocol::operator!=(const Protocol& rhs) const
   {
      return (!((this->_protocolId == rhs._protocolId)
            && (this->_uuid == rhs._uuid)));
   }
}
