#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/ProfileUsageList.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "ProfileUsageList.h"
#include "FunctionTracer.h"

namespace bmcore
{
	ProfileUsageList::ProfileUsageList() : _btProfileUsageInfoList()
   {
      ENTRY_INTERNAL
   }

	ProfileUsageList::ProfileUsageList(const ProfileUsageInfoList& btProfileUsageInfoList) :
          _btProfileUsageInfoList(btProfileUsageInfoList)
   {
      ENTRY_INTERNAL
   }

	ProfileUsageList::ProfileUsageList(const ProfileUsageList& other) :
          _btProfileUsageInfoList(other._btProfileUsageInfoList)
   {
      ENTRY_INTERNAL
   }

	ProfileUsageList::~ProfileUsageList()
   {
      ENTRY_INTERNAL
   }

	void swap(ProfileUsageList& first, ProfileUsageList& second)
	{
		using std::swap;

		swap(first._btProfileUsageInfoList, second._btProfileUsageInfoList);
	}

	//lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
	ProfileUsageList& ProfileUsageList::operator=(ProfileUsageList other)
	{
		swap(*this, other);

		return *this;
	}

	bool ProfileUsageList::operator==(const ProfileUsageList& rhs) const
	{
		return ((this->_btProfileUsageInfoList == rhs._btProfileUsageInfoList));
	}

	bool ProfileUsageList::operator!=(const ProfileUsageList& rhs) const
	{
		return (!(this->_btProfileUsageInfoList == rhs._btProfileUsageInfoList));
	}
}
