#ifndef _PROFILEUSAGEINFO_H_
#define _PROFILEUSAGEINFO_H_

#include "Protocol.h"
#include "BmInterfaceTypesInternal.h"
#include <list>

namespace bmcore
{
   using namespace std;

   class ProfileUsageInfo
   {
   public:
      ProfileUsageInfo();

      ProfileUsageInfo(const DeviceId deviceHandle, const Protocol& protocol,
            const BTProfileUsageType ProfileUsageType, const bool InUseInfo);

      ProfileUsageInfo(const ProfileUsageInfo& ProfileInUse);

      virtual ~ProfileUsageInfo();

      friend void swap(ProfileUsageInfo& first, ProfileUsageInfo& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      ProfileUsageInfo& operator=(ProfileUsageInfo rhs);

      bool operator==(const ProfileUsageInfo& rhs) const;

      DeviceId _deviceHandle;
      Protocol  _protocol;
      BTProfileUsageType _ProfileUsageType;
      bool _InUse;
   };

   typedef list<ProfileUsageInfo> ProfileUsageInfoList;
   typedef ProfileUsageInfoList::iterator ProfileUsageInfoListItr;
   typedef ProfileUsageInfoList::const_iterator ProfileUsageInfoListConstItr;
} /* namespace bmcore */

#endif /* _PROFILEUSAGEINFO_H_ */
