/**
 * @headerfile PairedDeviceList.h
 * @brief This class implements paired device list property
 * @date  Jul 15, 2015
 * @author tnh5cob -Tharani
 */

#ifndef _PAIRED_DEVICE_LIST_H_
#define _PAIRED_DEVICE_LIST_H_

#include "DeviceBaseInfo.h"

namespace bmcore
{
   class PairedDeviceList
   {
   public:
      PairedDeviceList();

      PairedDeviceList(const DeviceBaseInfoList& deviceBaseInfoList);

      PairedDeviceList(const PairedDeviceList& other);

      ~PairedDeviceList();

      friend void swap(PairedDeviceList& first, PairedDeviceList& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      PairedDeviceList& operator=(PairedDeviceList other);

      bool operator==(const PairedDeviceList& rhs) const;

      bool operator!=(const PairedDeviceList& rhs) const;

      DeviceBaseInfoList _deviceBaseInfoList;

   private:

   };

} // namespace bmcore

#endif /* _PAIRED_DEVICE_LIST_H_ */
