#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/LocalInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "LocalInfo.h"
#include "FunctionTracer.h"

namespace bmcore
{
   LocalInfo::LocalInfo() : _moduleName(""), _bdAddress(""), _bdName(""), _protocolInfos(), _vehicleIdentification(), _stackInitialized(false)
   {
      ENTRY_INTERNAL
   }

   LocalInfo::LocalInfo(const BtModuleName& moduleName, const BdAddress& bdAddress,
         const LocalFriendlyNameType& friendlyName, const ProtocolInfoMap& protocolInfoMap,
         const DeviceIdentification& vehicleIdentification, const bool& stackInitialized) :
         _moduleName(moduleName), _bdAddress(bdAddress), _bdName(friendlyName), _protocolInfos(
               protocolInfoMap), _vehicleIdentification(vehicleIdentification), _stackInitialized(stackInitialized)
   {
      ENTRY_INTERNAL
   }

   LocalInfo::LocalInfo(const LocalInfo& other) : _moduleName(other._moduleName), _bdAddress(other._bdAddress), _bdName(
               other._bdName), _protocolInfos(other._protocolInfos), _vehicleIdentification(other._vehicleIdentification), 
               _stackInitialized(other._stackInitialized)
   {
      ENTRY_INTERNAL
   }

   LocalInfo::~LocalInfo()
   {
      ENTRY_INTERNAL
   }

   void swap(LocalInfo& first, LocalInfo& second)
   {
      using std::swap;

      swap(first._moduleName, second._moduleName);
      swap(first._bdAddress, second._bdAddress);
      swap(first._bdName, second._bdName);
      swap(first._protocolInfos, second._protocolInfos);
      swap(first._vehicleIdentification, second._vehicleIdentification);
      swap(first._stackInitialized, second._stackInitialized);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   LocalInfo& LocalInfo::operator=(LocalInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool LocalInfo::operator==(const LocalInfo& rhs) const
   {
      return ((this->_moduleName == rhs._moduleName)
              && (this->_bdAddress == rhs._bdAddress)
              && (this->_bdName == rhs._bdName)
              && (this->_protocolInfos == rhs._protocolInfos)
              && (this->_vehicleIdentification == rhs._vehicleIdentification)
              && (this->_stackInitialized == rhs._stackInitialized));
   }

   bool LocalInfo::operator!=(const LocalInfo& rhs) const
   {
      return (!((this->_moduleName == rhs._moduleName)
              && (this->_bdAddress == rhs._bdAddress)
              && (this->_bdName == rhs._bdName)
              && (this->_protocolInfos == rhs._protocolInfos)
              && (this->_vehicleIdentification == rhs._vehicleIdentification)
              && (this->_stackInitialized == rhs._stackInitialized)));
   }
}
