#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/LocalFriendlyName.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "LocalFriendlyName.h"
#include "FunctionTracer.h"

namespace bmcore
{
   LocalFriendlyName::LocalFriendlyName() :  _localFriendlyName("")
   {
      ENTRY_INTERNAL
   }

   LocalFriendlyName::LocalFriendlyName(const LocalFriendlyNameType& name) :  _localFriendlyName(name)
   {
      ENTRY_INTERNAL
   }

   LocalFriendlyName::LocalFriendlyName(const LocalFriendlyName& other) :  _localFriendlyName(other._localFriendlyName)
   {
      ENTRY_INTERNAL
   }

   LocalFriendlyName::~LocalFriendlyName()
   {
      ENTRY_INTERNAL
   }

   void swap(LocalFriendlyName& first, LocalFriendlyName& second)
   {
      using std::swap;

      swap(first._localFriendlyName, second._localFriendlyName);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   LocalFriendlyName& LocalFriendlyName::operator=(LocalFriendlyName other)
   {
      swap(*this, other);

      return *this;
   }

   bool LocalFriendlyName::operator==(const LocalFriendlyName& rhs) const
   {
      return ((this->_localFriendlyName == rhs._localFriendlyName));
   }

   bool LocalFriendlyName::operator!=(const LocalFriendlyName& rhs) const
   {
      return (!(this->_localFriendlyName == rhs._localFriendlyName));
   }
}
