#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/LinkQualityInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "LinkQualityInfo.h"
#include "FunctionTracer.h"

namespace bmcore
{
   LinkQualityInfo::LinkQualityInfo() :
         _rssi(-127), _linkQuality(0u)
   {
      ENTRY_INTERNAL
   }

   LinkQualityInfo::LinkQualityInfo(const Rssi& rssi, const LinkQualityType& linkQuality) :
         _rssi(rssi), _linkQuality(linkQuality)
   {
      ENTRY_INTERNAL
   }

   LinkQualityInfo::LinkQualityInfo(const LinkQualityInfo& other) :
         _rssi(other._rssi), _linkQuality(other._linkQuality)
   {
      ENTRY_INTERNAL
   }

   LinkQualityInfo::~LinkQualityInfo()
   {
      ENTRY_INTERNAL
   }

   void swap(LinkQualityInfo& first, LinkQualityInfo& second)
   {
      using std::swap;

      swap(first._rssi, second._rssi);
      swap(first._linkQuality, second._linkQuality);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   LinkQualityInfo& LinkQualityInfo::operator=(LinkQualityInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool LinkQualityInfo::operator==(const LinkQualityInfo& rhs) const
   {
      return ((this->_rssi == rhs._rssi)
            && (this->_linkQuality == rhs._linkQuality));
   }
}
