/****************************************************************************
*FILE:         LinkQuality.h 
*SW-COMPONENT: bmcore
*DESCRIPTION:  LinkQuality Property
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#ifndef _LINK_QUALITY_H_
#define _LINK_QUALITY_H_

#include "LinkQualityInfo.h"

namespace bmcore
{
   class LinkQuality 
   {
   public:

      LinkQuality();

      LinkQuality(IN const LinkQualityInfoList& linkQualityInfoList);

      LinkQuality(const LinkQuality& other);

      ~LinkQuality();

      friend void swap(LinkQuality& first, LinkQuality& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      LinkQuality& operator=(LinkQuality other);

      bool operator==(const LinkQuality& rhs) const;

      bool operator!=(const LinkQuality& rhs) const;

      LinkQualityInfoList _linkQualityInfoList;

   private:

   };

} // namespace bmcore

#endif // _LINK_QUALITY_H_
