
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/LimitationMode.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "FunctionTracer.h"
#include "LimitationMode.h"

namespace bmcore
{
   LimitationMode::LimitationMode() : _limitationFeature(BM_LIMITATION_FEATURE_LAST),
         _limitationCommunicationIf(BM_LIMITATION_COMMUNICATION_IF_LAST)
   {
      ENTRY_INTERNAL
   }

   LimitationMode::LimitationMode(const LimitationFeature limitationFeature, const LimitationCommunicationIf limitationCommunicationIf) :
         _limitationFeature(limitationFeature),
         _limitationCommunicationIf(limitationCommunicationIf)
   {
      ENTRY_INTERNAL
   }

   LimitationMode::LimitationMode(const LimitationMode& other) :
         _limitationFeature(other._limitationFeature),
         _limitationCommunicationIf(other._limitationCommunicationIf)
   {
      ENTRY_INTERNAL
   }

   LimitationMode::~LimitationMode()
   {
      ENTRY_INTERNAL
   }

   void swap(LimitationMode& first, LimitationMode& second)
   {
      using std::swap;

      swap(first._limitationFeature, second._limitationFeature);
      swap(first._limitationCommunicationIf, second._limitationCommunicationIf);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   LimitationMode& LimitationMode::operator=(LimitationMode other)
   {
      swap(*this, other);

      return *this;
   }

   bool LimitationMode::operator==(const LimitationMode& rhs) const
   {
      return ((this->_limitationFeature == rhs._limitationFeature)
            && (this->_limitationCommunicationIf == rhs._limitationCommunicationIf));
   }

   bool LimitationMode::operator!=(const LimitationMode& rhs) const
   {
      return (!((this->_limitationFeature == rhs._limitationFeature)
            && (this->_limitationCommunicationIf == rhs._limitationCommunicationIf)));
   }
}

