#ifndef _KDS_INFO_H_
#define _KDS_INFO_H_

#include "BmInterfaceTypesInternal.h"
#include "BaseTypes.h"
#include <list>

namespace bmcore
{
   class KdsInfo
   {
   public:
      KdsInfo();

      KdsInfo(const uint16_t& key, bool& read, const ServiceName& serviceName, const uint8_t& byte, const uint8_t& bit, const uint8_t& length);

      KdsInfo(const KdsInfo& other);

      virtual ~KdsInfo();

      friend void swap(KdsInfo& first, KdsInfo& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      KdsInfo& operator=(KdsInfo other);

      bool operator==(const KdsInfo& rhs) const;

      uint16_t _key;
      bool _read;
      ServiceName _serviceName;
      uint8_t _byte;
      uint8_t _bit;
      uint8_t _length;

   };

   typedef std::list<KdsInfo> KdsInformation;
}

#endif // _SPP_SERVICE_INFO_H_
