#ifndef _ISSUEINFOLIST_H_
#define _ISSUEINFOLIST_H_

#include "BmInterfaceTypesInternal.h"
#include "IssueInfo.h"

namespace bmcore
{
    class IssueInfoList 
    {
    public:

    	IssueInfoList();

    	IssueInfoList(const ConflictTrigger conflictTrigger, const ConflictInfoList& conflictInfoList);

    	IssueInfoList(const IssueInfoList& other);

        ~IssueInfoList();

        friend void swap(IssueInfoList& first, IssueInfoList& second);

        //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
        IssueInfoList& operator=(IssueInfoList other);

        bool operator==(const IssueInfoList& rhs) const;

        bool operator!=(const IssueInfoList& rhs) const;

        ConflictTrigger _conflictTrigger;
        ConflictInfoList _conflictInfoList;

    private:

    };

} // namespace bmcore

#endif // _ISSUEINFOLIST_H_
