
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/IssueInfoList.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "IssueInfoList.h"
#include "FunctionTracer.h"

namespace bmcore
{
   IssueInfoList::IssueInfoList() : _conflictTrigger(BM_CONFLICT_TRIGGER_NONE), _conflictInfoList()
   {
      ENTRY_INTERNAL
   }

   IssueInfoList::IssueInfoList(const ConflictTrigger conflictTrigger, const ConflictInfoList& conflictInfoList) :
        _conflictTrigger(conflictTrigger), _conflictInfoList(conflictInfoList)
   {
      ENTRY_INTERNAL
   }

   IssueInfoList::IssueInfoList(const IssueInfoList& other) :
         _conflictTrigger(other._conflictTrigger), _conflictInfoList(other._conflictInfoList)
   {
      ENTRY_INTERNAL
   }

   IssueInfoList::~IssueInfoList()
   {
      ENTRY_INTERNAL
   }

   void swap(IssueInfoList& first, IssueInfoList& second)
   {
      using std::swap;

      swap(first._conflictTrigger, second._conflictTrigger);
      swap(first._conflictInfoList, second._conflictInfoList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   IssueInfoList& IssueInfoList::operator=(IssueInfoList other)
   {
      swap(*this, other);

      return *this;
   }

   bool IssueInfoList::operator==(const IssueInfoList& rhs) const
   {
      return ((this->_conflictTrigger == rhs._conflictTrigger)
    		  && (this->_conflictInfoList == rhs._conflictInfoList));
   }

   bool IssueInfoList::operator!=(const IssueInfoList& rhs) const
   {
      return (!((this->_conflictTrigger == rhs._conflictTrigger)
    		  &&(this->_conflictInfoList == rhs._conflictInfoList)));
   }
}
