
#ifndef _ISSUE_INFO_H_
#define _ISSUE_INFO_H_

#include "Protocol.h"
#include "BmInterfaceTypesInternal.h"
#include <vector>

namespace bmcore
{
   using namespace std;
   class IssueInfo
   {
   public:

      IssueInfo();

      IssueInfo(const ConflictType conflictType, const DeviceId deviceID,
            const Protocol& protocol, const BTProfileUsageType btProfileUsageType, const ConflictState conflictState);

      IssueInfo(const IssueInfo& other);

      virtual ~IssueInfo();

	  friend void swap(IssueInfo& first, IssueInfo& second);

	  //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
	  IssueInfo& operator=(IssueInfo rhs);

	  bool operator==(const IssueInfo& rhs) const;

      ConflictType _conflictType;
      DeviceId  _deviceID;
      Protocol  _protocol;
      BTProfileUsageType _profileUsageType;
      ConflictState _conflictState;
   };

   typedef vector<IssueInfo> ConflictInfoList;
   typedef vector<IssueInfo>::iterator ConflictInfoListItr;
} // namespace bmcore

#endif // _ISSUE_INFO_H_
