#ifndef _DISCOVERED_DEVICE_LIST_H_
#define _DISCOVERED_DEVICE_LIST_H_

#include "DiscoveredDeviceInfo.h"

namespace bmcore
{
   class DiscoveredDeviceList
   {
   public:
      DiscoveredDeviceList();

      DiscoveredDeviceList(const DiscoveredDeviceInfoList& discoveredDeviceInfoList);

      DiscoveredDeviceList(const DiscoveredDeviceList& other);

      ~DiscoveredDeviceList();

      friend void swap(DiscoveredDeviceList& first, DiscoveredDeviceList& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      DiscoveredDeviceList& operator=(DiscoveredDeviceList other);

      bool operator==(const DiscoveredDeviceList& rhs) const;

      bool operator!=(const DiscoveredDeviceList& rhs) const;

      DiscoveredDeviceInfoList _discoveredDeviceInfoList;

   private:

   };

} // namespace bmcore

#endif // _DISCOVERED_DEVICE_LIST_H_
