
#ifndef _DISCOVERED_DEVICE_INFO_H_
#define _DISCOVERED_DEVICE_INFO_H_

#include "BmInterfaceTypesInternal.h"
#include "BtStackIfTypes.h"
#include "DeviceIdentification.h"
#include "ConnectionOrderInfo.h"
#include "ProtocolInfo.h"
#include "time.h"
#include "stdint.h"
#include <list>

using namespace ::btstackif;

namespace bmcore
{
   class DiscoveredDeviceInfo
   {
   public:
      DiscoveredDeviceInfo();

      DiscoveredDeviceInfo(const DeviceId deviceHandle, const BdAddress& bdAddress,
            const BdName& bdName, const BTSMajorDeviceClass majorDeviceClass,
            const BTSMinorDeviceClass minorDeviceClass, const ProtocolInfoMap& protocolInfo,
            const ConnectionStatus connectionStatus, const LastDiscoveredTimestamp lastDiscoveredTimestamp);

      DiscoveredDeviceInfo(const DiscoveredDeviceInfo& other);

      virtual ~DiscoveredDeviceInfo();

      friend void swap(DiscoveredDeviceInfo& first, DiscoveredDeviceInfo& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      DiscoveredDeviceInfo& operator=(DiscoveredDeviceInfo other);

      bool operator==(const DiscoveredDeviceInfo& rhs) const;

      DeviceId                _deviceHandle;
      BdAddress               _bdAddress;
      BdName                  _bdName;
      BTSMajorDeviceClass     _majorDeviceClass;
      BTSMinorDeviceClass     _minorDeviceClass;
      ProtocolInfoMap         _protocolInfo;
      ConnectionStatus        _connectionStatus;
      LastDiscoveredTimestamp _lastDiscoveredTimestamp;
   };

   typedef std::list<DiscoveredDeviceInfo> DiscoveredDeviceInfoList;
} // namespace bmcore

#endif // _DISCOVERED_DEVICE_INFO_H_
