
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/DeviceConnectionInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "FunctionTracer.h"
#include "DeviceConnectionInfo.h"

namespace bmcore
{
   DeviceConnectionInfo::DeviceConnectionInfo() : _deviceHandle(0u), _connectionStatus(BM_CONNECTION_STATUS_DISCONNECTED),
         _disconnectedReason(BM_DISCONNECTED_REASON_TEMPORARILY), _connectionOrderInfo(), _protocolConnectionInfo(), _sppConnectionInfo()
   {
      ENTRY_INTERNAL
   }

   DeviceConnectionInfo::DeviceConnectionInfo(const DeviceId& deviceHandle, const ConnectionStatus& connectionStatus,
         const DisconnectedReason& disconnectedReason, const ConnectionOrderInfo& connectionOrderInfo,
         const ProtocolConnectionInfoMap& protocolConnectionInfo, const SppConnectionInfoMap& sppConnectionInfo) :
         _deviceHandle(deviceHandle),
         _connectionStatus(connectionStatus),
         _disconnectedReason(disconnectedReason),
         _connectionOrderInfo(connectionOrderInfo),
         _protocolConnectionInfo(protocolConnectionInfo),
         _sppConnectionInfo(sppConnectionInfo)
   {
      ENTRY_INTERNAL
   }

   DeviceConnectionInfo::DeviceConnectionInfo(const DeviceConnectionInfo& other) :
         _deviceHandle(other._deviceHandle),
         _connectionStatus(other._connectionStatus),
         _disconnectedReason(other._disconnectedReason),
         _connectionOrderInfo(other._connectionOrderInfo),
         _protocolConnectionInfo(other._protocolConnectionInfo),
         _sppConnectionInfo(other._sppConnectionInfo)
   {
      ENTRY_INTERNAL
   }

   DeviceConnectionInfo::~DeviceConnectionInfo()
   {
      ENTRY_INTERNAL
   }

   void swap(DeviceConnectionInfo& first, DeviceConnectionInfo& second)
   {
      using std::swap;

      swap(first._deviceHandle, second._deviceHandle);
      swap(first._connectionStatus, second._connectionStatus);
      swap(first._disconnectedReason, second._disconnectedReason);
      swap(first._connectionOrderInfo, second._connectionOrderInfo);
      swap(first._protocolConnectionInfo, second._protocolConnectionInfo);
      swap(first._sppConnectionInfo, second._sppConnectionInfo);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   DeviceConnectionInfo& DeviceConnectionInfo::operator=(DeviceConnectionInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool DeviceConnectionInfo::operator==(const DeviceConnectionInfo& rhs) const
   {
      return ((this->_deviceHandle == rhs._deviceHandle)
            && (this->_connectionStatus == rhs._connectionStatus)
            && (this->_disconnectedReason == rhs._disconnectedReason)
            && (this->_connectionOrderInfo == rhs._connectionOrderInfo)
            && (this->_protocolConnectionInfo == rhs._protocolConnectionInfo)
            && (this->_sppConnectionInfo == rhs._sppConnectionInfo));
   }

   bool DeviceConnectionInfo::operator!=(const DeviceConnectionInfo& rhs) const
   {
      return (!((this->_deviceHandle == rhs._deviceHandle)
            && (this->_connectionStatus == rhs._connectionStatus)
            && (this->_disconnectedReason == rhs._disconnectedReason)
            && (this->_connectionOrderInfo == rhs._connectionOrderInfo)
            && (this->_protocolConnectionInfo == rhs._protocolConnectionInfo)
            && (this->_sppConnectionInfo == rhs._sppConnectionInfo)));
   }

   bool DeviceConnectionInfo::compConnectionIndex(const DeviceConnectionInfo& a, const DeviceConnectionInfo& b)
   {
      ENTRY

      //used to sort Devices based on ConnectionOrderInfo Index as following:
      //1.sort connected Devices in ascending order
      //2.sort other devices in descending order
      //3.connected devices come before other connection statuses

      bool ret = false;

      if(BM_CONNECTION_STATUS_CONNECTED == a._connectionStatus && BM_CONNECTION_STATUS_CONNECTED == b._connectionStatus)
      {
         ret = a._connectionOrderInfo._index < b._connectionOrderInfo._index;
      }
      else if(BM_CONNECTION_STATUS_CONNECTED != a._connectionStatus && BM_CONNECTION_STATUS_CONNECTED != b._connectionStatus)
      {
         ret = a._connectionOrderInfo._index > b._connectionOrderInfo._index;
      }
      else if(BM_CONNECTION_STATUS_CONNECTED == a._connectionStatus && BM_CONNECTION_STATUS_CONNECTED != b._connectionStatus)
      {
         ret = true;
      }
      else
      {
         //BM_CONNECTION_STATUS_CONNECTED != a._connectionStatus && BM_CONNECTION_STATUS_CONNECTED == b._connectionStatus
         ret = false;
      }

      return ret;
   }
}

