
#ifndef _DEVICE_BLOCK_STATUS_H_
#define _DEVICE_BLOCK_STATUS_H_

#include "BmInterfaceTypesInternal.h"
#include "Protocol.h"

namespace bmcore
{
   class DeviceBlockStatus
   {
   public:
      DeviceBlockStatus();

      DeviceBlockStatus(const DeviceId deviceHandle, const BlockState blockState, const ProtocolBlockStatusMap& protocolBlockStatusMap);

      DeviceBlockStatus(const DeviceBlockStatus& other);

      virtual ~DeviceBlockStatus();

      friend void swap(DeviceBlockStatus& first, DeviceBlockStatus& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      DeviceBlockStatus& operator=(DeviceBlockStatus other);

      bool operator==(const DeviceBlockStatus& rhs) const;

      bool operator!=(const DeviceBlockStatus& rhs) const;

      inline DeviceId getDeviceHandle() const
      {
         return _deviceHandle;
      }

      DeviceId               _deviceHandle;
      BlockState             _blockState;
      ProtocolBlockStatusMap _protocolBlockStatusMap;
   };

   typedef std::vector<DeviceBlockStatus> DeviceBlockStatusList;
}

#endif /* _DEVICE_BLOCK_STATUS_H_ */
