
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/DeviceBlockStatus.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "FunctionTracer.h"
#include "DeviceBlockStatus.h"

namespace bmcore
{
   DeviceBlockStatus::DeviceBlockStatus() : _deviceHandle(0u), _blockState(BM_BLOCK_STATE_UNBLOCKED), _protocolBlockStatusMap()
   {
      ENTRY_INTERNAL
   }

   DeviceBlockStatus::DeviceBlockStatus(const DeviceId deviceHandle, const BlockState blockState,
         const ProtocolBlockStatusMap& protocolBlockStatusMap) :
         _deviceHandle(deviceHandle),
         _blockState(blockState),
         _protocolBlockStatusMap(protocolBlockStatusMap)
   {
      ENTRY_INTERNAL
   }

   DeviceBlockStatus::DeviceBlockStatus(const DeviceBlockStatus& other) :
         _deviceHandle(other._deviceHandle),
         _blockState(other._blockState),
         _protocolBlockStatusMap(other._protocolBlockStatusMap)
   {
      ENTRY_INTERNAL
   }

   DeviceBlockStatus::~DeviceBlockStatus()
   {
      ENTRY_INTERNAL
   }

   void swap(DeviceBlockStatus& first, DeviceBlockStatus& second)
   {
      using std::swap;

      swap(first._deviceHandle, second._deviceHandle);
      swap(first._blockState, second._blockState);
      swap(first._protocolBlockStatusMap, second._protocolBlockStatusMap);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   DeviceBlockStatus& DeviceBlockStatus::operator=(DeviceBlockStatus other)
   {
      swap(*this, other);

      return *this;
   }

   bool DeviceBlockStatus::operator==(const DeviceBlockStatus& rhs) const
   {
      return ((this->_deviceHandle == rhs._deviceHandle)
            && (this->_blockState == rhs._blockState)
            && (this->_protocolBlockStatusMap == rhs._protocolBlockStatusMap));
   }

   bool DeviceBlockStatus::operator!=(const DeviceBlockStatus& rhs) const
   {
      return (!((this->_deviceHandle == rhs._deviceHandle)
            && (this->_blockState == rhs._blockState)
            && (this->_protocolBlockStatusMap == rhs._protocolBlockStatusMap)));
   }
}

