
#ifndef _CONNECTION_ORDERINFO_H_
#define _CONNECTION_ORDERINFO_H_

#include "BmInterfaceTypesInternal.h"

namespace bmcore
{
   class ConnectionOrderInfo
   {
   public:
      ConnectionOrderInfo();

      ConnectionOrderInfo(const unsigned int& index, const time_t& seconds, const long& nanoseconds);

      ConnectionOrderInfo(const ConnectionOrderInfo& other);

      virtual ~ConnectionOrderInfo();

      friend void swap(ConnectionOrderInfo& first, ConnectionOrderInfo& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      ConnectionOrderInfo& operator=(ConnectionOrderInfo other);

      bool operator==(const ConnectionOrderInfo& rhs) const;

      bool operator!=(const ConnectionOrderInfo& rhs) const;

      unsigned int                 _index;
      unsigned long long int       _seconds;     //to be filled using clock_gettime(CLOCK_REALTIME, &spec)
      long                         _nanoseconds; //to be filled using clock_gettime(CLOCK_REALTIME, &spec)
   };
}

#endif /* _CONNECTION_ORDERINFO_H_ */
