
#ifndef _BT_SYSTEM_STATE_H_
#define _BT_SYSTEM_STATE_H_
#include "BmInterfaceTypesInternal.h"

namespace bmcore
{
   class BtSystemState 
   {
   public:

      BtSystemState();

      BtSystemState(const BluetoothSystemState btSystemState);

      BtSystemState(const BtSystemState& other);

      ~BtSystemState();

      friend void swap(BtSystemState& first, BtSystemState& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      BtSystemState& operator=(BtSystemState other);

      bool operator==(const BtSystemState& rhs) const;

      bool operator!=(const BtSystemState& rhs) const;

      BluetoothSystemState _bluetoothSystemState;

   private:
   };

} // namespace bmcore

#endif /* _BT_SYSTEM_STATE_H_ */
