#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BtLimitationModeInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "BtLimitationModeInfo.h"
#include "FunctionTracer.h"

namespace bmcore
{
   BtLimitationModeInfo::BtLimitationModeInfo() :
         _bdAddress(""), _bdName(""), _limitationMode(), _limitationState(BM_LIMITATION_STATE_IDLE)
   {
      ENTRY_INTERNAL
   }

   BtLimitationModeInfo::BtLimitationModeInfo(const BdAddress& bdAddress, const BdName& bdName,
         const LimitationMode& limitationMode, const LimitationState limitationState) :
         _bdAddress(bdAddress), _bdName(bdName), _limitationMode(limitationMode), _limitationState(limitationState)
   {
      ENTRY_INTERNAL
   }

   BtLimitationModeInfo::BtLimitationModeInfo(const BtLimitationModeInfo& other) :
         _bdAddress(other._bdAddress), _bdName(other._bdName), _limitationMode(other._limitationMode), _limitationState(other._limitationState)
   {
      ENTRY_INTERNAL
   }

   BtLimitationModeInfo::~BtLimitationModeInfo()
   {
      ENTRY_INTERNAL
   }

   void swap(BtLimitationModeInfo& first, BtLimitationModeInfo& second)
   {
      using std::swap;

      swap(first._bdAddress, second._bdAddress);
      swap(first._bdName, second._bdName);
      swap(first._limitationMode, second._limitationMode);
      swap(first._limitationState, second._limitationState);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BtLimitationModeInfo& BtLimitationModeInfo::operator=(BtLimitationModeInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool BtLimitationModeInfo::operator==(const BtLimitationModeInfo& rhs) const
   {
      return ((this->_bdAddress == rhs._bdAddress)
            && (this->_bdName == rhs._bdName)
            && (this->_limitationMode == rhs._limitationMode)
            && (this->_limitationState == rhs._limitationState));
   }

   bool BtLimitationModeInfo::operator!=(const BtLimitationModeInfo& rhs) const
   {
      return (!((this->_bdAddress == rhs._bdAddress)
            && (this->_bdName == rhs._bdName)
            && (this->_limitationMode == rhs._limitationMode)
            && (this->_limitationState == rhs._limitationState)));
   }
}
