#ifndef _BM_INTERFACE_TYPES_INTERNAL_H_
#define _BM_INTERFACE_TYPES_INTERNAL_H_

#include <string>
#include <vector>
#include <map>

namespace bmcore
{
class Protocol;
/**
 * macros to mark parameters data flow direction
 */
#ifndef IN
#define IN /**< direction marker for input parameter */
#endif
#ifndef OUT
#define OUT /**< direction marker for output parameter */
#endif
#ifndef INOUT
#define INOUT /**< direction marker for input/output parameter */
#endif

typedef enum
{
   BM_RESULT_OK = 0,
   BM_RESULT_ERR_GENERAL,
   BM_RESULT_ERR_NOT_IMPLEMENTED,
   BM_RESULT_ERR_INVALID_PARAMETER,
   BM_RESULT_ERR_NOT_ALLOWED,
   BM_RESULT_ERR_NOT_PAIRABLE,
   BM_RESULT_ERR_MAXIMUM_NUMBER_PAIRED_DEVICES_REACHED,
   BM_RESULT_ERR_PAIRING_IN_PROGRESS,
   BM_RESULT_ERR_NO_PAIRING_IN_PROGRESS,
   BM_RESULT_ERR_DEVICE_BLOCKED,
   BM_RESULT_ERR_DEVICE_DISCONNECTING,
   BM_RESULT_ERR_ALL_DEVICE_RESOURCES_IN_USE,
   BM_RESULT_ERR_DEVICE_RESSOURCES_NOT_ASSIGNED,
   BM_RESULT_ERR_ALL_PROTOCOL_RESOURCES_IN_USE,
   BM_RESULT_ERR_PROTOCOL_RESSOURCES_NOT_ASSIGNED,
   BM_RESULT_ERR_MASTER_PROTOCOL_NOT_CONNECTED,
   BM_RESULT_ERR_BUSY,
   BM_RESULT_ERR_NOT_IN_TEST_MODE,
   BM_RESULT_ERR_BT_LIMITATION_ACTION_NOT_ALLOWED,
   BM_RESULT_ERR_BT_LIMITATION_ACTION_BUSY,
   BM_RESULT_ERR_ANOTHER_BT_LIMITATION_STILL_IN_USE
} BmResult;

/*
 * error code enumeration
 */
 typedef enum
 {
   /* common error codes */
    CC_ERR_INT_NO_ERROR = 0,
    CC_ERR_INT_GENERAL_ERROR,
    CC_ERR_INT_BTS_ERROR,
    CC_ERR_INT_NULL_POINTER,
    CC_ERR_INT_MEMORY_ALLOCATION_ERROR,
    CC_ERR_INT_INVALID_PARAMETER,
    CC_ERR_INT_BUSY,
    CC_ERR_INT_MAXIMUM_NUMBER_PAIRED_DEVICES_ALREADY_REACHED,
    CC_ERR_INT_PAIRING_IN_PROGRESS,
    CC_ERR_INT_NOT_ALLOWED,
    CC_ERR_INT_DEVICE_NOT_FOUND,
    CC_ERR_INT_DEVICE_BLOCKED,
    CC_ERR_INT_DCC_NONE_RESERVED,
    CC_ERR_INT_DCC_ALL_IN_USE,
    CC_ERR_INT_DCC_NONE_IN_LOST,
    CC_ERR_INT_DCC_ASSIGNING_FAILED,
    CC_ERR_INT_DCC_NOT_ASSIGNED,
    CC_ERR_INT_DCC_ALREADY_ASSIGNED,
    CC_ERR_INT_DCC_ONLY_PARTIALLY_HANDLED,
    CC_ERR_INT_DCC_IN_DISCONNECTING,
    CC_ERR_INT_PROTOCOL_NOT_SUPPORTED,
    CC_ERR_INT_PROTOCOL_BLOCKED,
    CC_ERR_INT_MASTER_PROTOCOL_NOT_CONNECTED,
    CC_ERR_INT_UUID_NOT_SUPPORTED,
    CC_ERR_INT_PCC_NO_RESOURCES,
    CC_ERR_INT_PCC_HANDLE_INVALID,
    CC_ERR_INT_PCC_NOT_ASSIGNED,
    CC_ERR_INT_PCC_ALREADY_ASSIGNED,
    CC_ERR_INT_PCC_NONE_ASSIGNED,
    CC_ERR_INT_AUTO_CONNECTION_IN_PROGRESS,
    CC_ERR_INT_DP_ERROR,
    CC_ERR_INT_ITEM_NOT_FOUND,

    /* CustomControl error codes */
    CC_ERR_INT_CC_FIRST_ERROR = 2000, // not used

    /* DB Manager error codes */
    CC_ERR_INT_DB_UNEXPECTED = 5000,
    CC_ERR_INT_DB_ALREADY_INITIALIZED,
    CC_ERR_INT_DB_INITIALIZATION_FAILURE,
    CC_ERR_INT_DB_DATABASE_RECREATION_FAILURE, // not used
    CC_ERR_INT_DB_ALREADY_CONNECTED, // not used
    CC_ERR_INT_DB_DATABASE_FILE_FAILURE,
    CC_ERR_INT_DB_DATABASE_CONNECTION_FAILURE,
    CC_ERR_INT_DB_DATABASE_SCHEMA_FAILURE,
    CC_ERR_INT_DB_NOT_CONNECTED,
    CC_ERR_INT_DB_UNFINALIZED_STATEMENTS,
    CC_ERR_INT_DB_DATABASE_CLOSE_FAILURE,
    CC_ERR_INT_DB_PREPARE_FAILURE,
    CC_ERR_INT_DB_STEP_FAILURE,
    CC_ERR_INT_DB_INTEGRITY_FAILURE,
    CC_ERR_INT_DB_INVALID_SCHEMA_VERSION,
    CC_ERR_INT_DB_FINALIZE_FAILURE,
    CC_ERR_INT_DB_LIST_NOT_FOUND,
    CC_ERR_INT_DB_CREATE_LIST_CONTEXT,
    CC_ERR_INT_DB_QUERY_FAILED,
    CC_ERR_INT_DB_UNSUPPORTED_LIST_TYPE,
    CC_ERR_INT_DB_UNSUPPORTED_CAT_TYPE,
    CC_ERR_INT_DB_SELECT_FAILED,
    CC_ERR_INT_DB_END_OF_LIST,
    CC_ERR_INT_DB_INSERT_FAILED,
    CC_ERR_INT_DB_DELETE_FAILED,
    CC_ERR_INT_DB_UPDATE_FAILED,
    CC_ERR_INT_DB_EXECUTE_FAILED,
    CC_ERR_INT_DB_OPEN_FAILED,
    CC_ERR_INT_DB_NOT_OPEN,
    CC_ERR_INT_DB_ACCESS_NOT_ALLOWED,
    CC_ERR_INT_DB_LIST_IS_NO_PLAYLIST,
    CC_ERR_INT_DB_RESET_IN_SUPSEND,
    CC_ERR_INT_DB_BEGIN_TRANSACTION_FAILED,
    CC_ERR_INT_DB_END_TRANSACTION_FAILED,
    CC_ERR_INT_DB_REGISTER_FAILED,
    CC_ERR_INT_DB_UNREGISTER_FAILED,
    CC_ERR_INT_DB_SEARCHKEYS_NOT_SUPPORTED,
    CC_ERR_INT_DB_FILE_TYPE_NOT_FOUND,
    CC_ERR_INT_DB_DEVICE_NOT_ADDED,
    CC_ERR_INT_DB_DCC_HANDLE_NOT_FOUND,
    CC_ERR_INT_DB_DEVICE_NOT_FOUND,
    CC_ERR_INT_DB_CASTING_ERROR,

    /* utf8 */
    CC_ERR_INT_UTF8_UNKNOWN_CHARACTER_FORMAT = 6000,

    /* data provider */
    CC_ERR_INT_DP_FIRST_ERROR = 7000,

    CC_ERR_INT_LAST_ERROR_CODE
 } CcErrorInternal;

 typedef std::string BdAddress;

 typedef std::string LocalFriendlyNameType;

 typedef std::string BtModuleName;

 typedef std::string BdName;

 typedef std::string PairingPinType;

 typedef std::string LinkKey;

 typedef std::string Uuid;

 typedef unsigned int DeviceId;

 typedef signed int RingtoneId;

 typedef signed char Rssi;

 typedef unsigned char LinkQualityType;

 typedef unsigned int LinkQualityRequestRepititionTime;

 typedef std::string ServiceName;

 /**
  * Local SPM component init reason definitions
  */
 typedef enum
 {
    IR_BOOT,
    IR_UNDERVOLTAGE
 } InitReason;

 /**
  * Local SPM component state definitions
  */
 typedef enum
 {
    COMPONENT_STATE_CREATE = 0UL,
    COMPONENT_STATE_INIT = 1UL,
    COMPONENT_STATE_RUNNING = 2UL,
    COMPONENT_STATE_STOP = 3UL,
    COMPONENT_STATE_DONE = 4UL,
    COMPONENT_STATE_UNKNOWN
 } ComponentState;

 typedef enum
 {
    COMPONENT_GROUP_ALL = 1,
    COMPONENT_GROUP_SM,
    COMPONENT_GROUP_NON_SM
 } ComponentGroup;

 /**
  * Local SPM state definitions
  */
 typedef enum
 {
    SPM_STATE_OFF = 0UL,
    SPM_STATE_NORMAL = 1UL,
    SPM_STATE_UNDERVOLTAGE = 2UL
 } SpmState;

 /* statistics string for all components */
 typedef char Statistics[4096];

 /**
  * Type declaration for a flag if system is in undervoltage situation
  */
 typedef bool Undervoltage;

 typedef enum
 {
    BM_PAIRING_STATE_UNKNOWN = 0,
    BM_PAIRING_STATE_IDLE,
    BM_PAIRING_STATE_PAIRING_PREPARED,
    BM_PAIRING_STATE_PAIRING_IN_PROGRESS
 } PairingState;

 typedef enum
 {
    BM_USER_CONFIRMATION_UNKNOWN = 0,
    BM_USER_CONFIRMATION_REQUIRED,
    BM_USER_CONFIRMATION_NOT_REQUIRED
 } UserConfirmationRequired;

 typedef enum
 {
    BM_PAIRING_REQUEST_ORIGIN_UNKNOWN = 0,
    BM_PAIRING_REQUEST_ORIGIN_LOCAL,
    BM_PAIRING_REQUEST_ORIGIN_REMOTE
 } PairingRequestOrigin;

 typedef enum
 {
    BM_PAIRING_TYPE_UNKNOWN = 0,
    BM_PAIRING_TYPE_LEGACY,
    BM_PAIRING_TYPE_SSP_NUMERIC_COMPARISON,
    BM_PAIRING_TYPE_SSP_JUST_WORK,
    BM_PAIRING_TYPE_SSP_PASSKEY_ENTRY_MODE_INPUT_BY_REMOTE_DEVICE,
    BM_PAIRING_TYPE_SSP_PASSKEY_ENTRY_MODE_INPUT_BY_LOCAL_DEVICE
 } PairingType;
#define PAIRINGTYPE_FORMAT "i"
#define PAIRINGTYPE_INIT BM_PAIRING_TYPE_UNKNOWN

 typedef enum {
    BM_PAIRING_RESULT_UNKNOWN = 0,
    BM_PAIRING_RESULT_OK,
    BM_PAIRING_RESULT_ERR_GENERAL,
    BM_PAIRING_RESULT_ERR_NO_RESSOURCE_AVAILABLE,
    BM_PAIRING_RESULT_ERR_START_PAIRING_FAILED,
    BM_PAIRING_RESULT_ERR_PAIRING_CANCELED,
    BM_PAIRING_RESULT_ERR_PAIRING_REJECTED,
    BM_PAIRING_RESULT_ERR_NOT_PAIRABLE,
    BM_PAIRING_RESULT_ERR_NOT_PAIRABLE_AFTER_TIMEOUT,
    BM_PAIRING_RESULT_ERR_PAIRING_AUTHENTICATION_FAILED,
    BM_PAIRING_RESULT_ERR_MISSING_PIN,
    BM_PAIRING_RESULT_ERR_CONNECTION_LOST,
    BM_PAIRING_RESULT_ERR_PAIRING_FAILED_RETRY_KEEP_SESSION,
    BM_PAIRING_RESULT_ERR_PAIRING_FAILED_RETRY_NEW_SESSION
 } PairingResult;
#define PAIRINGRESULT_FORMAT "i"
#define PAIRINGRESULT_INIT BM_PAIRING_RESULT_UNKNOWN

 typedef unsigned long long int LastDiscoveredTimestamp;

 typedef enum
 {
    BM_PROTOCOL_ID_UNKNOWN = 0,
    BM_PROTOCOL_ID_HFP,
    BM_PROTOCOL_ID_AVP,
    BM_PROTOCOL_ID_PBDL,
    BM_PROTOCOL_ID_MSG,
    BM_PROTOCOL_ID_PAN,
    BM_PROTOCOL_ID_SPP
 } ProtocolId;
#define PROTOCOLID_FORMAT "i"
#define PROTOCOLID_INIT (BM_PROTOCOL_ID_UNKNOWN)

 typedef std::string ProtocolName;

 typedef unsigned short ProtocolVersion;

 typedef enum
 {
    BM_PROTOCOL_DEPENDENCY_LEVEL_MASTER = 0,
    BM_PROTOCOL_DEPENDENCY_LEVEL_SLAVE,
    BM_PROTOCOL_DEPENDENCY_LEVEL_STAND_ALONE
 } ProtocolDependencyLevel;

 typedef enum
 {
    BM_MASTER_PROTOCOLS_SELECTOR_NONE = 0,
    BM_MASTER_PROTOCOLS_SELECTOR_HFP,
    BM_MASTER_PROTOCOLS_SELECTOR_ALL_OTHERS
 } MasterProtocolsSelector;

 /**
  * Type declaration for a vector of protocol ID's
  */
 typedef std::vector<ProtocolId> ProtocolIdList;
 typedef std::vector<std::pair<ProtocolId, ProtocolVersion> > ProtocolIdVersionList;

 typedef std::vector<Uuid> UuidList;

 typedef std::vector<bmcore::Protocol> ProtocolList;
 typedef std::map<DeviceId, ProtocolList> DeviceProtocolListMap;

 typedef enum
 {
    BM_AUTO_CONNECTION_STATE_IDLE = 0,
    BM_AUTO_CONNECTION_STATE_PREPARING,
    BM_AUTO_CONNECTION_STATE_IN_PROGRESS
 } AutoConnectionState;

 typedef enum
 {
    BM_CONNECTION_STATUS_UNKNOWN = 0,
    BM_CONNECTION_STATUS_DISCONNECTED,
    BM_CONNECTION_STATUS_CONNECTING,
    BM_CONNECTION_STATUS_CONNECTED,
    BM_CONNECTION_STATUS_DISCONNECTING
 } ConnectionStatus;

 typedef enum
 {
    BM_DISCONNECTED_REASON_UNKNOWN = 0,
    BM_DISCONNECTED_REASON_NOT_APPLICABLE, /**< (= 1) set if connection status is not DISCONNECTED */
    BM_DISCONNECTED_REASON_CONNECTION_FAILED, /**< (= 2) set if connection attempt failed */
    BM_DISCONNECTED_REASON_CONNECTION_FAILED_UUID_NOT_SUPPORTED, /**< (= 3) set only for SPP protocol if connection attempt failed since the SPP UUID is not found in the remote device's SPP capabilities */
    BM_DISCONNECTED_REASON_CONNECTION_FAILED_LIMIT_REACHED, /**< (= 4) */
    BM_DISCONNECTED_REASON_CONNECTION_FAILED_TIMEOUT, /**< (= 5) */
    BM_DISCONNECTED_REASON_CONNECTION_FAILED_REJECTED, /**< (= 6) */
    BM_DISCONNECTED_REASON_CONNECTION_FAILED_NOT_SUPPORTED, /**< (= 7) */
    BM_DISCONNECTED_REASON_TEMPORARILY, /**< (= 8) */
    BM_DISCONNECTED_REASON_AUTOMATIC, /**< (= 9) */
    BM_DISCONNECTED_REASON_NORMAL_LOSS, /**< (= 10) */
    BM_DISCONNECTED_REASON_NORMAL_LOSS_LOCAL, /**< (= 11) */
    BM_DISCONNECTED_REASON_NORMAL_LOSS_REMOTE, /**< (= 12) */
    BM_DISCONNECTED_REASON_ABNORMAL_LOSS, /**< (= 13) */
    BM_DISCONNECTED_REASON_MISSING_LINK_KEY, /**< (= 14) */
    BM_DISCONNECTED_REASON_OUT_OF_RANGE, /**< (= 15) */
    BM_DISCONNECTED_REASON_NONE /**< (= 16) */
 } DisconnectedReason;

 typedef std::string RfcommDevicePath;

 typedef enum
 {
    BM_DEVICE_HANDLE_TYPE_SINGLE = 0,
    BM_DEVICE_HANDLE_TYPE_ALL,
    BM_DEVICE_HANDLE_TYPE_ALL_EXCEPT
 } DeviceHandleType;

 typedef enum
 {
    BM_FAVORITE_TYPE_DEVICE = 0,
    BM_FAVORITE_TYPE_PROTOCOL_HFP,
    BM_FAVORITE_TYPE_PROTOCOL_AVP
 } FavoriteType;

 typedef unsigned int FavoriteIndex;

 typedef bool RemoteConnectable;

 typedef enum
 {
    BM_FAVORITE_SUPPORT_TYPE_NO_FAVORITES = 0,
    BM_FAVORITE_SUPPORT_TYPE_DEVICE_FAVORITES,
    BM_FAVORITE_SUPPORT_TYPE_PROTOCOL_FAVORITES
 } FavoriteSupportType;

 typedef enum
 {
    BM_STANDARD_AUTO_CONNECTION_UNKNOWN = 0,
    BM_STANDARD_AUTO_CONNECTION_OFF,
    BM_STANDARD_AUTO_CONNECTION_LAST_CONNECTED_DEVICES
    //BM_STANDARD_AUTO_CONNECTION_LAST_CONNECTED_PROFILES
    //BM_STANDARD_AUTO_CONNECTION_DEFAULT_DEVICE
 } StandardAutoConnectionType;

 typedef enum
 {
    BM_TEMPORARY_AUTO_CONNECTION_DEFAULT = 0,
    BM_TEMPORARY_AUTO_CONNECTION_LAST_CONNECTED_DEVICES
    //BM_TEMPORAL_AUTO_CONNECTION_LAST_CONNECTED_PROFILES
    //BM_TEMPORAL_AUTO_CONNECTION_DEFAULT_DEVICE
 } TemporaryAutoConnectionType;

 typedef enum
 {
    BM_RESET_STATE_IDLE = 0,
    BM_RESET_STATE_IN_PROGRESS
 } ResetToDefaultState;

 typedef enum
 {
    BM_RESET_RESULT_NOT_APPLICABLE = 0,
    BM_RESET_RESULT_OK,
    BM_RESET_RESULT_ERROR
 } ResetToDefaultResult;

 typedef enum
 {
    BM_BT_SYSTEM_STATE_OFF = 0,
    BM_BT_SYSTEM_STATE_BLOCK,
    BM_BT_SYSTEM_STATE_DISCONNECT,
    BM_BT_SYSTEM_STATE_NORMAL_SWITCH_OFF_BT,
    BM_BT_SYSTEM_STATE_NO_ACTION,
    BM_BT_SYSTEM_STATE_NORMAL
 } BluetoothSystemState;

 typedef enum
 {
    BM_INBAND_RINGTONE_SUPPORT_UNKNOWN = 0,
    BM_INBAND_RINGTONE_SUPPORT_AVAILABLE,
    BM_INBAND_RINGTONE_SUPPORT_NOT_AVAILABLE
 } InbandRingtoneSupport;

 typedef enum
 {
    BM_ABSOLUTE_VOLUME_SUPPORT_UNKNOWN = 0,
    BM_ABSOLUTE_VOLUME_SUPPORT_AVAILABLE,
    BM_ABSOLUTE_VOLUME_SUPPORT_NOT_AVAILABLE
 } AbsoluteVolumeSupport;

 typedef enum
 {
    BM_BLOCK_STATE_UNBLOCKED = 0,
    BM_BLOCK_STATE_BLOCKED
 } BlockState;

 typedef enum
 {
    BM_OVERALL_BLOCK_STATE_UNBLOCKED = 0,
    BM_OVERALL_BLOCK_STATE_BLOCKED,
    BM_OVERALL_BLOCK_STATE_BLOCKED_EXCEPT
 } OverallBlockState;

 typedef enum
 {
    BM_LIMITATION_FEATURE_UNKNOWN = 0,
    BM_LIMITATION_FEATURE_IAP,
    BM_LIMITATION_FEATURE_CAR_PLAY,
    BM_LIMITATION_FEATURE_ANDROID_AUTO,
    BM_LIMITATION_FEATURE_MY_SPIN,
    BM_LIMITATION_FEATURE_MY_SPIN_IOS,
    BM_LIMITATION_FEATURE_MIRROR_LINK,
    BM_LIMITATION_FEATURE_MIRROR_LINK_IOS,
    BM_LIMITATION_FEATURE_CAR_LIFE,
    BM_LIMITATION_FEATURE_CAR_LIFE_IOS,
    BM_LIMITATION_FEATURE_ON_CAR,
    BM_LIMITATION_FEATURE_ON_CAR_IOS,
    BM_LIMITATION_FEATURE_LAST
 } LimitationFeature;

 typedef enum
 {
    BM_LIMITATION_COMMUNICATION_IF_USB = 0,
    BM_LIMITATION_COMMUNICATION_IF_WIFI_2_4,
    BM_LIMITATION_COMMUNICATION_IF_WIFI_5,
    BM_LIMITATION_COMMUNICATION_IF_BT,
    BM_LIMITATION_COMMUNICATION_IF_WIFI,
    BM_LIMITATION_COMMUNICATION_IF_LAST
 } LimitationCommunicationIf;

 typedef enum
 {
    BM_LIMITATION_ACTION_PREPARE = 0,
    BM_LIMITATION_ACTION_PREACTIVATE,
    BM_LIMITATION_ACTION_ACTIVATE,
    BM_LIMITATION_ACTION_DEACTIVATE,
    BM_LIMITATION_ACTION_DEACTIVATE_WAIT,
    BM_LIMITATION_ACTION_DEACTIVATE_INTERNAL,
    BM_LIMITATION_ACTION_DEACTIVATE_SPM_STATE_OFF,
    BM_LIMITATION_ACTION_LAST
 } LimitationAction;

 typedef enum
 {
    BM_LIMITATION_STATE_IDLE = 0,
    BM_LIMITATION_STATE_PREPARING,
    BM_LIMITATION_STATE_PREPARED,
    BM_LIMITATION_STATE_PREACTIVATING,
    BM_LIMITATION_STATE_PREACTIVATED,
    BM_LIMITATION_STATE_ACTIVATING,
    BM_LIMITATION_STATE_ACTIVE,
    BM_LIMITATION_STATE_DEACTIVATING,
    BM_LIMITATION_STATE_WAITING,
    BM_LIMITATION_STATE_ERROR,
    BM_LIMITATION_STATE_ERROR_USER_DENIED,
    BM_LIMITATION_STATE_LAST
 } LimitationState;

 typedef unsigned int IssueId;

 typedef enum
 {
    BM_CONFLICT_TYPE_GENERIC = 0,
    BM_CONFLICT_TYPE_MAX_NUMBER_PAIRED_DEVICES_REACHED,
    BM_CONFLICT_TYPE_PROFILE_IN_USE,
    BM_CONFLICT_TYPE_INCORRECT_WIFI_MODE,
    BM_CONFLICT_TYPE_CHECK_MAX_NUMBER_PAIRED_DEVICES_REACHED
 } ConflictType;

 typedef enum
 {
    BM_CONFLICT_TRIGGER_NONE = 0,
    BM_CONFLICT_TRIGGER_BT_PAIRING,
    BM_CONFLICT_TRIGGER_OOB_BT_PAIRING,
    BM_CONFLICT_TRIGGER_AAP_USB,
    BM_CONFLICT_TRIGGER_AAP_WIRELESS,
    BM_CONFLICT_TRIGGER_CP_USB,
    BM_CONFLICT_TRIGGER_CP_WIRELESS,
    BM_CONFLICT_TRIGGER_CARLIFE_USB,
    BM_CONFLICT_TRIGGER_CARLIFE_IOS_USB,
    BM_CONFLICT_TRIGGER_ONCAR_USB,
    BM_CONFLICT_TRIGGER_ONCAR_IOS_USB,
    BM_CONFLICT_TRIGGER_MIRRORLINK_USB,
    BM_CONFLICT_TRIGGER_MIRRORLINK_IOS_USB,
    BM_CONFLICT_TRIGGER_MYSPIN_USB,
    BM_CONFLICT_TRIGGER_MYSPIN_IOS_USB
 } ConflictTrigger;

 typedef enum
 {
    BM_CONFLICT_STATE_NEW,
    BM_CONFLICT_STATE_UNCHANGED ,
    BM_CONFLICT_STATE_SOLVED,
    BM_CONFLICT_STATE_LAST
 }ConflictState;

 typedef enum
 {
    BM_USER_DECISION_NONE,
    BM_USER_DECISION_PROCEED,
    BM_USER_DECISION_CANCEL
 } UserDecision;

#define USERDECISION_FORMAT "i"
#define USERDECISION_INIT BM_USER_DECISION_NONE

typedef enum
{
   BM_OOB_TYPE_GENERIC = 0,
   BM_OOB_TYPE_APPLE
} OobType;

typedef enum
{
   BM_UP_UNDECIDED = 0,
   BM_UP_TEMP_CLASSIC_BT,
   BM_UP_CLASSIC_BT,
   BM_UP_CPW
}UsagePreference;

typedef enum
{
   BT_PROFILE_USAGE_NONE,
   BT_PROFILE_USAGE_GENERIC ,
   BT_PROFILE_USAGE_ACTIVE_CALL,
   BT_PROFILE_USAGE_AUDIO_STREAMING
}BTProfileUsageType;

typedef enum
{
   BM_TARGET_CONNECTION_STATUS_DISCONNECTED = 0,
   BM_TARGET_CONNECTION_STATUS_CONNECTED
} TargetConnectionStatus;

typedef enum
{
   SWITCH_STATE_SWITCHED_OFF = 0,
   SWITCH_STATE_SWITCHING_ON,
   SWITCH_STATE_SWITCHED_ON,
   SWITCH_STATE_SWITCHING_OFF
} SwitchState;

typedef enum
{
   SWITCHED_OFF_REASON_NOT_VALID = 0,
   SWITCHED_OFF_REASON_NO_MODULE,
   SWITCHED_OFF_REASON_CONFIGURATION,
   SWITCHED_OFF_REASON_DIAGNOSIS,
   SWITCHED_OFF_REASON_STACK_NOT_RUNNING,
   SWITCHED_OFF_REASON_STARTUP,
   SWITCHED_OFF_REASON_CLIENT,
   SWITCHED_OFF_REASON_TIMEOUT,
   SWITCHED_OFF_REASON_INTERNAL,
   SWITCHED_OFF_REASON_ERROR
} SwitchedOffReason;

typedef enum
{
   TARGET_SWITCH_STATE_SWITCHED_OFF = 0,
   TARGET_SWITCH_STATE_SWITCHED_ON = 2
} TargetSwitchState;

typedef enum
{
   BM_SERVICE_UNAVAILABLE = 0,
   BM_SERVICE_AVAILABLE_RESTRICTED,
   BM_SERVICE_AVAILABLE
} ServiceAvailability;

typedef unsigned int ActType;

#define SWITCHSTATE_FORMAT "i"
#define SWITCHSTATE_INIT SWITCH_STATE_SWITCHED_OFF

#define SWITCHEDOFFREASON_FORMAT "i"
#define SWITCHEDOFFREASON_INIT SWITCHED_OFF_REASON_CLIENT

/**
 * Type definition for scalar time value. Resolution is ms.
 */
typedef unsigned int PageTimeout;

} // namespace bmcore

#endif /* _BM_INTERFACE_TYPES_INTERNAL_H_ */
