/****************************************************************************
*FILE:         BmConfigData.h 
*SW-COMPONENT: bmcore
*DESCRIPTION:  BmConfigData Property
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#ifndef BMCONFIGDATA_H_
#define BMCONFIGDATA_H_

#include "BmInterfaceTypesInternal.h"

namespace bmcore
{
   class BmConfigData 
   {
   public:

      BmConfigData();

      BmConfigData(IN const unsigned int maxNumPairedDevices);

      BmConfigData(const BmConfigData& other);

      ~BmConfigData();

      friend void swap(BmConfigData& first, BmConfigData& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      BmConfigData& operator=(BmConfigData other);

      bool operator==(const BmConfigData& rhs) const;

      bool operator!=(const BmConfigData& rhs) const;

      unsigned int _maxNumPairedDevices;

   private:
   
   };

} // namespace bmcore

#endif /* BMCONFIGDATA_H_ */
