/****************************************************************************
*FILE:         BmConfigData.cpp
*SW-COMPONENT: bmcore
*DESCRIPTION:  BmConfigData Property
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BmConfigData.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "BmConfigData.h"
#include "FunctionTracer.h"

namespace bmcore
{
   BmConfigData::BmConfigData() :  _maxNumPairedDevices(0)
   {
      ENTRY_INTERNAL
   }

   BmConfigData::BmConfigData(IN const unsigned int maxNumPairedDevices) : _maxNumPairedDevices(maxNumPairedDevices)
   {
      ENTRY_INTERNAL
   }

   BmConfigData::BmConfigData(const BmConfigData& other) : _maxNumPairedDevices(other._maxNumPairedDevices)
   {
      ENTRY_INTERNAL
   }

   BmConfigData::~BmConfigData()
   {
      ENTRY_INTERNAL
   }

   void swap(BmConfigData& first, BmConfigData& second)
   {
      using std::swap;

      swap(first._maxNumPairedDevices, second._maxNumPairedDevices);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmConfigData& BmConfigData::operator=(BmConfigData other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmConfigData::operator==(const BmConfigData& rhs) const
   {
      return ((this->_maxNumPairedDevices == rhs._maxNumPairedDevices));
   }

   bool BmConfigData::operator!=(const BmConfigData& rhs) const
   {
      return (!(this->_maxNumPairedDevices == rhs._maxNumPairedDevices));
   }
}

