#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BlockStatus.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "BlockStatus.h"
#include "FunctionTracer.h"

namespace bmcore
{
   BlockStatus::BlockStatus() : _overallDeviceBlockStatus(), _deviceBlockStatusList()
   {
      ENTRY_INTERNAL
   }

   BlockStatus::BlockStatus(const OverallDeviceBlockStatus overallDeviceBlockStatus, const DeviceBlockStatusList& deviceBlockStatusList) :
          _overallDeviceBlockStatus(overallDeviceBlockStatus), _deviceBlockStatusList(deviceBlockStatusList)
   {
      ENTRY_INTERNAL
   }

   BlockStatus::BlockStatus(const BlockStatus& other) : _overallDeviceBlockStatus(other._overallDeviceBlockStatus),
            _deviceBlockStatusList(other._deviceBlockStatusList)
   {
      ENTRY_INTERNAL
   }

   BlockStatus::~BlockStatus()
   {
      ENTRY_INTERNAL
   }

   void swap(BlockStatus& first, BlockStatus& second)
   {
      using std::swap;

      swap(first._overallDeviceBlockStatus, second._overallDeviceBlockStatus);
      swap(first._deviceBlockStatusList, second._deviceBlockStatusList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BlockStatus& BlockStatus::operator=(BlockStatus other)
   {
      swap(*this, other);

      return *this;
   }

   bool BlockStatus::operator==(const BlockStatus& rhs) const
   {
      return ((this->_overallDeviceBlockStatus == rhs._overallDeviceBlockStatus)
    		  && (this->_deviceBlockStatusList == rhs._deviceBlockStatusList));
   }

   bool BlockStatus::operator!=(const BlockStatus& rhs) const
   {
      return (!((this->_overallDeviceBlockStatus == rhs._overallDeviceBlockStatus)
    		  && (this->_deviceBlockStatusList == rhs._deviceBlockStatusList)));
   }
}

