/****************************************************************************
*FILE:         AutoConnectionType.h 
*SW-COMPONENT: bmcore
*DESCRIPTION:  AutoConnectionType property
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#ifndef _AUTO_CONNECTION_TYPE_H_
#define _AUTO_CONNECTION_TYPE_H_

#include "BmInterfaceTypesInternal.h"

namespace bmcore
{
   class AutoConnectionType
   {
   public:

      AutoConnectionType();

      AutoConnectionType(const StandardAutoConnectionType type);

      AutoConnectionType(const AutoConnectionType& other);

      ~AutoConnectionType();

      friend void swap(AutoConnectionType& first, AutoConnectionType& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      AutoConnectionType& operator=(AutoConnectionType other);

      bool operator==(const AutoConnectionType& rhs) const;

      bool operator!=(const AutoConnectionType& rhs) const;

      StandardAutoConnectionType _type;

   private:

   };

} // namespace bmcore

#endif /* _AUTO_CONNECTION_TYPE_H_ */
