#ifndef _BM_CORE_FACTORY_H_
#define _BM_CORE_FACTORY_H_

#include "BmCoreIfTypes.h"

namespace bmcore
{
   // class forward declarations
   class IBmCoreRequestIf;

   /**
    *
    */
   class BmCoreFactory
   {
   public:
      /**
       * Get instance of instance factory (reference).
       *
       * @return = reference to instance factory object
       */
      static BmCoreFactory& getInstance(void);

      /**
       * Get instance of connection request if (pointer).
       *
       * @return = pointer to connection request if object
       */
      IBmCoreRequestIf* getBmCoreRequestIfInstance(void);

      /**
       * Destroy instance of connection request if (pointer).
       */
      void destroyBmCoreRequestIfInstance(void);

      /************************ unit test section ****************************************************/
      /**
       * Set instance of connection request if (pointer).
       * For testing purpose (unit test).
       * If instance is set via this interface the caller is responsible to free the instance at the end of test run.
       *
       * @param[in] testInstance: test version of connection request if (pointer)
       */
      void setBmCoreRequestIfInstanceForTesting(IN IBmCoreRequestIf* bmCoreRequestIfInstance);

   private:
      /**
       * Default constructor. Private!!!
       */
      BmCoreFactory();

      /**
       * Destructor. Private!!!
       */
      virtual ~BmCoreFactory();

      const int localCreate; /**< value for local instance creation */
      const int externCreate; /**< value for extern instance creation (unit test) */

      IBmCoreRequestIf* _bmCoreRequestIfInstance; /**< BM Core request interface instance */
      int _connectionCreator; /**< creator flag for BM Core request interface instance */
   };
}

#endif // _BM_CORE_FACTORY_H_
