/**
 * @file BmCoreCallbackIfWrapper.h
 *
 * @swcomponent BluetoothConnectionManagerCore
 *
 * @brief This file contains the declaration of the class BmCoreCallbackIfWrapper
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmControllerModule
 *
 */

#ifndef _BM_CORE_CALLBACK_IF_WRAPPER_H_
#define _BM_CORE_CALLBACK_IF_WRAPPER_H_

#include "ILocalSpm.h"
#include "BmAllTypes.h"

namespace bmcore
{
   // class forward declarations
   class IBmCoreCallbackIf;

   /**
    * @class BmCoreCallbackIfWrapper
    * @ingroup BmControllerModule
    * 
    * @brief The class BmCoreCallbackIfWrapper
    * 
    */
   class BmCoreCallbackIfWrapper : public ILocalSpm
   {
   public:
      /**
       * @brief Constructor of class BmCoreCallbackIfWrapper which creates an instance
       *
       * @return void
       */
      explicit BmCoreCallbackIfWrapper(ComponentId componentId, IBmCoreCallbackIf* bmCoreCallbackIf);

      /**
       * @brief Destructor of class BmCoreCallbackIfWrapper
       *
       * @return void
       */
      virtual ~BmCoreCallbackIfWrapper();

      void doUpdateConfiguration(INOUT BmCoreConfiguration& bmCoreConfiguration) const;

      void doStateChangeNormalResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doStateChangeOffResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doOnBtSystemStateChanged(IN const BtSystemState& btSystemState) const;

      void doSetProtocolUserAvailabilityResponse(IN const BmResult bmResult, IN const ActType act = 0) const;

      void doSetAutoConnectionTypeResponse(IN const BmResult bmResult, IN const ActType act) const;

      void doSwitchLocalPairableModeResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doOnLocalPairableModeChanged(IN const SwitchStatus& localPairableMode) const;

      void doSwitchLocalConnectableModeResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doOnLocalConnectableModeChanged(IN const SwitchStatus& localConnectableMode) const;

      void doSwitchDiscoveryStatusResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doOnDiscoveryStatusChanged(IN const SwitchStatus& discoveryStatus) const;

      void doOnDiscoveredDeviceChanged(IN const BdAddress& bdAddress, IN const BdName& btDeviceName) const;

      void doOnDiscoveredDeviceListChanged(IN const DiscoveredDeviceList& discoveredDeviceList) const;

      void doSwitchBtStatusResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doOnBtStatusChanged(IN const SwitchStatus& bluetoothStatus) const;

      void doOnBtLocalFriendlyNameChanged(IN const LocalFriendlyName& btLocalFriendlyName) const;

      void doOnBtLocalInfoChanged(IN const LocalInfo& btLocalInfo) const;

      void doOnPairingStatusChanged(IN const PairingStatus& btPairingStatus) const;

      void doOnPairingPinChanged(IN const PairingPin& pairingPin) const;

      void doRejectPairingRequestResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doAcceptPairingRequestResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doSetPairingPinResponse(IN const BmResult bmResult, IN const ActType act) const;

      void doAddOobPairedDeviceResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doOnPairedDeviceListChanged(IN const PairedDeviceList& pairedDeviceList) const;

      void doOnDeviceConnectionStatusListChanged(IN const DeviceConnectionStatusList& deviceConnectionStatusList) const;

      void doCancelPairingResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doStartPairingResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doOnAutoConnectionStatusChanged(IN const AutoConnectionStatus& autoConnectionStatus) const;

      void doConnectDeviceResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doDisconnectDeviceResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doDeleteDeviceResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doBlockDeviceResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doUnblockDeviceResponse(IN const DeviceId deviceHandle,IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doConnectProfilesResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doDisconnectProfilesResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doStoreDeviceRingtoneIdInDbResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doReadDeviceRingtoneIdFromDbResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doStoreSystemWideRingtoneIdInDbResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doReadSystemWideRingtoneIdFromDbResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doBlockProfilesResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doUnblockProfilesResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doOnBlockStatusChanged(IN const BlockStatus& blockStatus) const;

      void doSetFavoriteResponse(IN const BmResult bmResult, IN const ActType act) const;

      void doClearFavoriteResponse(IN const BmResult bmResult, IN const ActType act) const;

      void doOnAutoConnectionTypeChanged(IN const AutoConnectionType& autoConnectionType) const;

      void doStartAutoConnectSequenceResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doStopAutoConnectSequenceResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doOnBmConfigDataChanged(IN const BmConfigData& bmConfigData) const;

      void doOnBmServiceAvailabilityChanged(IN const BmServiceAvailability& bmServiceAvailability) const;

      void doOnLinkQualityChanged(IN const LinkQuality& linkQuality) const;

      void doUpdateLinkQualityResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doSetBtLimitationModeResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doReplaceBtLimitationModeResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doOnBtLimitationModeChanged(IN const BtLimitationMode& btLimitationMode) const;

      void doOnUserDecisionRequiredSignal(IN const IssueInfoList& issueInfoList) const;

      void doNotifyUserDecisionResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doResetToDefaultResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doOnResetToDefaultStatusChanged(IN const ResetToDefaultStatus& status) const;

      void doSwitchTestModeResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      void doOnTestModeChanged(IN const SwitchStatus& testMode) const;

      void doRequestTestModeLinkQualityResponse(IN const BmResult bmResult, IN const LinkQualityInfo& linkQualityInfo, IN const ActType act = 0u) const;

      void doOnLinkQualityTestModeChanged(IN const TestModeLinkQuality& linkQuality) const;
      void doSetPrimaryHfpDeviceResponse(IN const BmResult bmResult) const;
      void doStartServiceSearchResponse(IN const BmResult bmResult, IN const ActType act) const;
      void doStopServiceSearchResponse(IN const BmResult bmResult, IN const ActType act) const;

      void doSwitchMultiHFPSupportResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;
	  
      void doOnMultiHFPSupportStatusChanged(IN const SwitchStatus& bluetoothStatus) const;
	  
	  void doOnBtProfileUsageInfoChanged(IN const ProfileUsageList& btProfileUsageList) const;

      void doOnSetBtProfileUsageInfoResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;
	  
	  void doSetDeviceUsagePreferenceResponse(IN const BmResult bmResult, IN const ActType act = 0u) const;

      virtual void create();

      virtual int init(InitReason reason);

      virtual int run();

      virtual int stop();

      virtual int done();

   private:

      IBmCoreCallbackIf* _bmCoreCallbackIf;
   };
}

#endif // _BM_CORE_CALLBACK_IF_WRAPPER_H_

