/**
 * @file DeviceServiceSearchControl.h
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the declaration of the class DeviceServiceSearchControl
 *
 * @copyright (c) 2017 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#ifndef _DEVICE_SERVICE_SEARCH_CONTROL_H_
#define _DEVICE_SERVICE_SEARCH_CONTROL_H_

#include "BmAllTypesInternal.h"
#include "Timer.h"
#include "Lock.h"

namespace bmcore
{
   class DeviceServiceSearchControl
   {
   public:

      explicit DeviceServiceSearchControl(const DeviceId deviceHandle);

      DeviceServiceSearchControl(const DeviceServiceSearchControl& other);

      ~DeviceServiceSearchControl();

      friend void swap(DeviceServiceSearchControl& first, DeviceServiceSearchControl& second);

      DeviceServiceSearchControl& operator=(DeviceServiceSearchControl other);

      inline DeviceId getDeviceHandle() const
      {
         return _deviceHandle;
      }

      Result startServiceSearchTimer();

      Result stopServiceSearchTimer();

   private:

      static bool serviceSearchTimerCb(timer_t timerId, void *object, const void *userData);

      Result startServiceSearch();

      DeviceId _deviceHandle;

      Timer _serviceSearchTimer;
      timer_t _serviceSearchTimerId;
      LockForever _serviceSearchTimerLock;
   };

   typedef std::vector<DeviceServiceSearchControl*> DeviceServiceSearchControlList;
}

#endif // _DEVICE_SERVICE_SEARCH_CONTROL_H_
