/**
 * @file DeviceBlockRemoteConnectionsControl.h
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the declaration of the class DeviceBlockRemoteConnectionsControl
 *
 * @copyright (c) 2017 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#ifndef _DEVICE_BLOCK_REMOTE_CONNECTIONS_CONTROL_H_
#define _DEVICE_BLOCK_REMOTE_CONNECTIONS_CONTROL_H_

#include "BmAllTypesInternal.h"
#include "BaseTypes.h"
#include "Timer.h"
#include "Lock.h"

namespace bmcore
{
   class DeviceBlockRemoteConnectionsControl
   {
   public:

      explicit DeviceBlockRemoteConnectionsControl(const DeviceId deviceHandle);

      DeviceBlockRemoteConnectionsControl(const DeviceBlockRemoteConnectionsControl& other);

      ~DeviceBlockRemoteConnectionsControl();

      friend void swap(DeviceBlockRemoteConnectionsControl& first, DeviceBlockRemoteConnectionsControl& second);

      DeviceBlockRemoteConnectionsControl& operator=(DeviceBlockRemoteConnectionsControl other);

//      bool operator==(const DeviceBlockRemoteConnectionsControl& rhs) const;

      inline DeviceId getDeviceHandle() const
      {
         return _deviceHandle;
      }

      Result startBlockRemoteConnectionsTimer();

      Result stopBlockRemoteConnectionsTimer();

   private:

      static bool blockRemoteConnectionsTimerCb(timer_t timerId, void *object, const void *userData);

      Result setDeviceRemoteConnectable();

      DeviceId _deviceHandle;

      Timer _blockRemoteConnectionsTimer;
      timer_t _blockRemoteConnectionsTimerId;
      LockForever _blockRemoteConnectionsTimerLock;
   };

   typedef std::vector<DeviceBlockRemoteConnectionsControl*> DeviceBlockRemoteConnectionsControlList;
}

#endif // _DEVICE_BLOCK_REMOTE_CONNECTIONS_CONTROL_H_
