"DROP TABLE IF EXISTS [MAIN].[SchemaVersion];"

"DROP TABLE IF EXISTS [MAIN].[General];"
"DROP TABLE IF EXISTS [MAIN].[Devices];"
"DROP TABLE IF EXISTS [MAIN].[DeviceProtocols];"

"CREATE TABLE IF NOT EXISTS [MAIN].[SchemaVersion]"
"("
"  [Version]                             INTEGER PRIMARY KEY NOT NULL,"
"  [Integrity]                           BOOLEAN NOT NULL,"
"  [SchemaHash]                          TEXT DEFAULT ''"

");"

"INSERT OR REPLACE INTO [MAIN].[SchemaVersion]"
"("
"  [Version],"
"  [Integrity],"
"  [SchemaHash]"

")"
"VALUES"
"("
"  3,"
"  1,"
"  '0'"
");"



/*
 * --- paste here: ---
 */
"CREATE TABLE [General] ("
   "[BtStatus] INTEGER DEFAULT 2,"
   "[LocalBdAddress] TEXT DEFAULT '',"
   "[LocalBdName] TEXT DEFAULT '',"
   "[LegacyPairingPinCode] TEXT DEFAULT '',"
   "[StandardAutoConnectionType] INTEGER DEFAULT 0,"
   "[SystemWideRingtoneId] INTEGER DEFAULT -1,"
   "[MultiHFPSupport] INTEGER DEFAULT 3);"

"INSERT OR REPLACE INTO [MAIN].[General]"
"("
"  [SystemWideRingtoneId]"
")"
"VALUES"
"("
"  -1"
");"


"CREATE TABLE [Devices] ("
   "[ID] INTEGER PRIMARY KEY ON CONFLICT IGNORE AUTOINCREMENT,"
   "[BdAddress] TEXT CONSTRAINT [BdAddress] UNIQUE ON CONFLICT IGNORE,"
   "[BdName] TEXT,"
   "[DeviceHandle] INTEGER DEFAULT 0,"
   "[DeviceConnectionSMHandle] INT64 DEFAULT 0,"
   "[LinkKeyType] INTEGER,"
   "[LinkKey] TEXT,"
   "[DLinkKey] TEXT,"
   "[MajorDeviceClass] INTEGER,"
   "[MinorDeviceClass] INTEGER,"
   "[MajorServiceClass] INTEGER,"
   "[SpecificationID] INTEGER,"
   "[VendorID] INTEGER,"
   "[ProductID] INTEGER,"
   "[Version] INTEGER,"
   "[VendorIDSource] INTEGER,"
   "[ConnectionStatus] INTEGER DEFAULT 1,"
   "[DisconnectedReason] INTEGER DEFAULT 2,"
   "[LastConnectedTimeStamp] INT64 DEFAULT 0,"
   "[LastConnectedIndicator] INTEGER DEFAULT 0,"
   "[BlockStatus] INTEGER DEFAULT 0,"
   "[InbandRingtoneSupport] INTEGER DEFAULT 0,"
   "[RingtoneID] INTEGER DEFAULT -1,"
   "[FavoriteDevice] INTEGER DEFAULT 1,"
   "[UsagePreference] INTEGER DEFAULT 0,"
   "[MasterHFPDevice] INTEGER DEFAULT 0,"
   "[CPWDevice] INTEGER DEFAULT 0,"
   "[LastPairedTimeStamp] INT64 DEFAULT 0,"
   "[LastPairedIndicator] INTEGER DEFAULT 0,"
   "[LastConnectedPANDevice] INTEGER DEFAULT 0);"

"CREATE TABLE [DeviceProtocols] ("
   "[EntryID] INTEGER PRIMARY KEY AUTOINCREMENT,"
   "[DeviceID] INTEGER,"
   "[ProtocolID] INTEGER,"
   "[UUID] TEXT,"
   "[ConnectionStatus] INTEGER DEFAULT 1,"
   "[DisconnectedReason] INTEGER DEFAULT 6,"
   "[LastExpectedProtocolConnectionStatus] INTEGER DEFAULT 0,"
   "[LastConnectedTimeStamp] INT64 DEFAULT 0,"
   "[LastConnectedIndicator] INTEGER DEFAULT 0,"
   "[BlockStatus] INTEGER DEFAULT 0,"
   "[RFCOMMDevicePath] TEXT DEFAULT '',"
   "[ProtocolVersion] INTEGER DEFAULT 0,"
   "[ProtocolSupportedByRemoteDevice] INTEGER DEFAULT 1,"
   "[PrimaryProtocol] INTEGER DEFAULT 0,"
   "[Favorite] INTEGER DEFAULT 1);"

