/*
 * Queries.h
 *
 * File contains all queries of the Bt Connection Manager db manager.
 * It is included in the constructor of the Query object
 *
 *  Created on: Dec 4, 2012
 *      Author: Thömel
 */

#ifndef QUERIES_H_
#define QUERIES_H_


/*
 * define the collation for all ordered lists
 */
#define NO_COLLATE " "
#define SORTLIB_COLLATE " COLLATE SORT_LIB "
#define NOCASE_COLLATE " COLLATE NOCASE "

/* this switches the collation for all queries underneath */
#define COLLATE SORTLIB_COLLATE

/* fill the list of known queries */
tSQLStatement SQLStatement;

//*********************************************************************************
//*** General table
//*********************************************************************************

SQLStatement.query = "/*10*/""SELECT BtStatus,LocalBdAddress,LocalBdName,LegacyPairingPinCode,StandardAutoConnectionType,SystemWideRingtoneId,MultiHFPSupport FROM General WHERE (? OR ?) LIMIT ? OFFSET ?;";
mSQLStatements[LTY_GENERAL] = SQLStatement;

SQLStatement.query = "/*11*/""UPDATE General SET "
      "BtStatus=CASE WHEN ? THEN BtStatus ELSE ? END,"
      "LocalBdAddress=CASE WHEN ? THEN LocalBdAddress ELSE ? END,"
      "LocalBdName=CASE WHEN ? THEN LocalBdName ELSE ? END,"
      "LegacyPairingPinCode=CASE WHEN ? THEN LegacyPairingPinCode ELSE ? END,"
      "StandardAutoConnectionType=CASE WHEN ? THEN StandardAutoConnectionType ELSE ? END,"
      "SystemWideRingtoneId=CASE WHEN ? THEN SystemWideRingtoneId ELSE ? END,"
      "MultiHFPSupport=CASE WHEN ? THEN MultiHFPSupport ELSE ? END;";

mSQLStatements[LTY_GENERAL_UPDATE] = SQLStatement;

//*********************************************************************************
//*** Devices table
//*********************************************************************************

SQLStatement.query = "/*24*/""SELECT COUNT() FROM Devices LIMIT ? OFFSET ?;";
mSQLStatements[LTY_DEVICES_COUNT] = SQLStatement;

SQLStatement.query = "/*25*/""INSERT INTO [Main].[Devices] "
   "("
   "[BdAddress],"
   "[BdName],"
   "[DeviceHandle],"
   "[DeviceConnectionSMHandle],"
   "[LinkKeyType],"
   "[LinkKey],"
   "[DLinkKey],"
   "[MajorDeviceClass],"
   "[MinorDeviceClass],"
   "[MajorServiceClass],"
   "[SpecificationID],"
   "[VendorID],"
   "[ProductID],"
   "[Version],"
   "[VendorIDSource],"
   "[ConnectionStatus],"
   "[DisconnectedReason],"
   "[LastConnectedTimeStamp],"
   "[LastConnectedIndicator],"
   "[BlockStatus],"
   "[InbandRingtoneSupport],"
   "[RingtoneID],"
   "[FavoriteDevice],"
   "[UsagePreference],"
   "[MasterHFPDevice],"
   "[CPWDevice],"
   "[LastPairedTimeStamp],"
   "[LastPairedIndicator],"
   "[LastConnectedPANDevice]"
   ") "
   "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";

mSQLStatements[LTY_DEVICES_INSERT] = SQLStatement;

SQLStatement.query = "/*26*/""SELECT "
   "ID,"
   "BdAddress,"
   "BdName,"
   "DeviceHandle,"
   "DeviceConnectionSMHandle,"
   "LinkKeyType,"
   "LinkKey,"
   "DLinkKey,"
   "MajorDeviceClass,"
   "MinorDeviceClass,"
   "MajorServiceClass,"
   "SpecificationID,"
   "VendorID,"
   "ProductID,"
   "Version,"
   "VendorIDSource,"
   "ConnectionStatus,"
   "DisconnectedReason,"
   "LastConnectedTimeStamp,"
   "LastConnectedIndicator,"
   "BlockStatus,"
   "InbandRingtoneSupport,"
   "RingtoneID,"
   "FavoriteDevice,"
   "UsagePreference,"
   "MasterHFPDevice,"
   "CPWDevice,"
   "LastPairedTimeStamp,"
   "LastPairedIndicator,"
   "LastConnectedPANDevice "
   "FROM Devices WHERE (? OR ID=?) AND (? OR BdAddress=?) AND (? OR DeviceHandle=?) AND (? OR FavoriteDevice=?) LIMIT ? OFFSET ?;";

mSQLStatements[LTY_DEVICES] = SQLStatement;

SQLStatement.query = "/*27*/""UPDATE Devices SET "
   "BdAddress=CASE WHEN ? THEN BdAddress ELSE ? END,"
   "BdName=CASE WHEN ? THEN BdName ELSE ? END,"
   "DeviceHandle=CASE WHEN ? THEN DeviceHandle ELSE ? END,"
   "DeviceConnectionSMHandle=CASE WHEN ? THEN DeviceConnectionSMHandle ELSE ? END,"
   "LinkKeyType=CASE WHEN ? THEN LinkKeyType ELSE ? END,"
   "LinkKey=CASE WHEN ? THEN LinkKey ELSE ? END,"
   "DLinkKey=CASE WHEN ? THEN DLinkKey ELSE ? END,"
   "MajorDeviceClass=CASE WHEN ? THEN MajorDeviceClass ELSE ? END,"
   "MinorDeviceClass=CASE WHEN ? THEN MinorDeviceClass ELSE ? END,"
   "MajorServiceClass=CASE WHEN ? THEN MajorServiceClass ELSE ? END,"
   "SpecificationID=CASE WHEN ? THEN SpecificationID ELSE ? END,"
   "VendorID=CASE WHEN ? THEN VendorID ELSE ? END,"
   "ProductID=CASE WHEN ? THEN ProductID ELSE ? END,"
   "Version=CASE WHEN ? THEN Version ELSE ? END,"
   "VendorIDSource=CASE WHEN ? THEN VendorIDSource ELSE ? END,"
   "ConnectionStatus=CASE WHEN ? THEN ConnectionStatus ELSE ? END,"
   "DisconnectedReason=CASE WHEN ? THEN DisconnectedReason ELSE ? END,"
   "LastConnectedTimeStamp=CASE WHEN ? THEN LastConnectedTimeStamp ELSE ? END,"
   "LastConnectedIndicator=CASE WHEN ? THEN LastConnectedIndicator ELSE ? END,"
   "BlockStatus=CASE WHEN ? THEN BlockStatus ELSE ? END,"
   "InbandRingtoneSupport=CASE WHEN ? THEN InbandRingtoneSupport ELSE ? END,"
   "RingtoneID=CASE WHEN ? THEN RingtoneID ELSE ? END,"
   "FavoriteDevice=CASE WHEN ? THEN FavoriteDevice ELSE ? END,"
   "UsagePreference=CASE WHEN ? THEN UsagePreference ELSE ? END,"
   "MasterHFPDevice=CASE WHEN ? THEN MasterHFPDevice ELSE ? END,"
   "CPWDevice=CASE WHEN ? THEN CPWDevice ELSE ? END,"
   "LastPairedTimeStamp=CASE WHEN ? THEN LastPairedTimeStamp ELSE ? END,"
   "LastPairedIndicator=CASE WHEN ? THEN LastPairedIndicator ELSE ? END,"
   "LastConnectedPANDevice=CASE WHEN ? THEN LastConnectedPANDevice ELSE ? END "
   "WHERE (? OR ID=?);";

mSQLStatements[LTY_DEVICES_UPDATE] = SQLStatement;

SQLStatement.query = "/*28*/""DELETE FROM [Devices] WHERE (? OR ID=?);";

mSQLStatements[LTY_DEVICES_DELETE] = SQLStatement;

SQLStatement.query = "/*29*/""SELECT MAX(LastConnectedIndicator) FROM [Devices] LIMIT ? OFFSET ?;";

mSQLStatements[LTY_DEVICES_SELECT_MAX_CONNECTED_INDICATOR] = SQLStatement;

SQLStatement.query = "/*30*/""SELECT MAX(FavoriteDevice) FROM [Devices] LIMIT ? OFFSET ?;";

mSQLStatements[LTY_DEVICES_SELECT_MAX_FAVORITE] = SQLStatement;

SQLStatement.query = "/*31*/""SELECT MAX(LastPairedIndicator) FROM [Devices] LIMIT ? OFFSET ?;";

mSQLStatements[LTY_DEVICES_SELECT_MAX_PAIRED_INDICATOR] = SQLStatement;


//*********************************************************************************
//*** DeviceProtocols table
//*********************************************************************************

SQLStatement.query = "/*40*/""INSERT INTO [Main].[DeviceProtocols] "
   "("
   "[DeviceID],"
   "[ProtocolID],"
   "[UUID],"
   "[ConnectionStatus],"
   "[DisconnectedReason],"
   "[LastExpectedProtocolConnectionStatus],"
   "[LastConnectedTimeStamp],"
   "[LastConnectedIndicator],"
   "[BlockStatus],"
   "[RFCOMMDevicePath],"
   "[ProtocolVersion],"
   "[ProtocolSupportedByRemoteDevice],"
   "[PrimaryProtocol],"
   "[Favorite]"
   ") "
   "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
mSQLStatements[LTY_DEVICEPROTOCOLS_INSERT] = SQLStatement;

SQLStatement.query = "/*41*/""UPDATE DeviceProtocols SET "
   "DeviceID=CASE WHEN ? THEN DeviceID ELSE ? END,"
   "ProtocolID=CASE WHEN ? THEN ProtocolID ELSE ? END,"
   "UUID=CASE WHEN ? THEN UUID ELSE ? END,"
   "ConnectionStatus=CASE WHEN ? THEN ConnectionStatus ELSE ? END,"
   "DisconnectedReason=CASE WHEN ? THEN DisconnectedReason ELSE ? END,"
   "LastExpectedProtocolConnectionStatus=CASE WHEN ? THEN LastExpectedProtocolConnectionStatus ELSE ? END,"
   "LastConnectedTimeStamp=CASE WHEN ? THEN LastConnectedTimeStamp ELSE ? END,"
   "LastConnectedIndicator=CASE WHEN ? THEN LastConnectedIndicator ELSE ? END,"
   "BlockStatus=CASE WHEN ? THEN BlockStatus ELSE ? END,"
   "RFCOMMDevicePath=CASE WHEN ? THEN RFCOMMDevicePath ELSE ? END,"
   "ProtocolVersion=CASE WHEN ? THEN ProtocolVersion ELSE ? END,"
   "ProtocolSupportedByRemoteDevice=CASE WHEN ? THEN ProtocolSupportedByRemoteDevice ELSE ? END,"
   "PrimaryProtocol=CASE WHEN ? THEN PrimaryProtocol ELSE ? END,"
   "Favorite=CASE WHEN ? THEN Favorite ELSE ? END "
   "WHERE (? OR DeviceID=?) AND (? OR ProtocolID=?) AND (? OR UUID=?);";

mSQLStatements[LTY_DEVICEPROTOCOLS_UPDATE] = SQLStatement;

/* attention: this selects adds the ProtocolId column from the Protocols tables by linking via ProtocolEntryId */
SQLStatement.query = "/*42*/""SELECT "
   "DeviceID,"
   "ProtocolID,"
   "UUID,"
   "ConnectionStatus,"
   "DisconnectedReason,"
   "LastExpectedProtocolConnectionStatus,"
   "LastConnectedTimeStamp,"
   "LastConnectedIndicator,"
   "BlockStatus,"
   "RFCOMMDevicePath,"
   "ProtocolVersion,"
   "ProtocolSupportedByRemoteDevice,"
   "PrimaryProtocol,"
   "Favorite "
   "FROM DeviceProtocols WHERE (? OR DeviceID=?) AND (? OR ProtocolID=?) AND (? OR UUID=?) AND (? OR ConnectionStatus=?) AND (? OR DisconnectedReason=?) AND (? OR LastExpectedProtocolConnectionStatus=?) AND (? OR BlockStatus=?) AND (? OR RFCOMMDevicePath=?) AND (? OR Favorite=?) LIMIT ? OFFSET ?;";

mSQLStatements[LTY_DEVICEPROTOCOLS] = SQLStatement;

SQLStatement.query = "/*43*/""DELETE FROM [DeviceProtocols] WHERE (? OR DeviceID=?) AND (? OR ProtocolID=?) AND (? OR UUID=?);";

mSQLStatements[LTY_DEVICEPROTOCOLS_DELETE] = SQLStatement;

SQLStatement.query = "/*44*/""SELECT MAX(LastConnectedIndicator) FROM [DeviceProtocols] LIMIT ? OFFSET ?;";

mSQLStatements[LTY_DEVICEPROTOCOLS_SELECT_MAX_INDICATOR] = SQLStatement;

SQLStatement.query = "/*45*/""SELECT MAX(Favorite) FROM [DeviceProtocols] WHERE (? OR ProtocolID=?) LIMIT ? OFFSET ?;";

mSQLStatements[LTY_DEVICEPROTOCOLS_SELECT_MAX_FAVORITE] = SQLStatement;

/*
* for removing the old triggers
*/
SQLStatement.query = "/*100*/""SELECT * FROM sqlite_master WHERE (? OR ?) AND (? OR type=?) LIMIT ? OFFSET ?;";
mSQLStatements[LTY_SQLITE_MASTER] = SQLStatement;

#endif /* QUERIES_H_ */
