#ifndef _DATABASE_H_
#define _DATABASE_H_

#include "BmAllTypes.h"
#include "../sqlite/sqlite3.h" //workaround for Gen3, use Framework/sqlite

namespace bmcore
{
   class Database
   {
   public:
      Database();
      virtual ~Database();
      sqlite3* Handle();
      Result DeInit();
      Result RecreateDatabase() const;
      void Close();
      Result Register(const void *ptr) const;
      Result UnRegister(const void *ptr) const;
      Result Refresh();
      Result Sync(sqlite3 *dbHandle) const;
      Result fSync() const;
      Result CheckDatabaseIntegrity(sqlite3 *dbHandle) const;
      Result CheckSchemaHash(sqlite3 *dbHandle);
      int Shutdown(const int waitForAllThreadsFinished = 1) const;

      /* this file name will be used by upper levels of DataBase to signal a needed data base file recreation on next startup */
      static const char* mDatabaseRecreateFile;

   private:
      static const char* mDatabaseFile;
      static const char* mDatabaseSchemaHashFile;
      static const tInteger mSchemaVersion = 3;
      sqlite3 *mDatabase;

      Result CheckSqlite3Version(sqlite3 *dbHandle) const;
      static int BusyCallback(void *userData, int times);
      static int ProgressCallbackCaller(void *userData);
      int ProgressCallback() const;
      sqlite3 *OpenDatabase();
      Result AddModules(sqlite3 *dbHandle) const;
      Result ConfigureConnection(sqlite3 *dbHandle) const;
      Result CloseDatabase(sqlite3 *dbHandle) const;
      void CloseAllHandles() const;
      Result ResetDatabaseIntegrity(sqlite3 *dbHandle) const;
      Result CreateDatabaseSchema(sqlite3 *dbHandle) const;
      Result Refresh(sqlite3 *dbHandle);
      std::string recreateDBSchemaHash();
      void InsertSchemaHasch(sqlite3 *dbHandle) ;
   };
}

#endif // _DATABASE_H_
