#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_CONFLICTMANAGER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/ConflictManager.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_CONFLICTMANAGER
#endif
#endif

#include "LocalSpm.h"
#include "BmVarTrace.h"
#include "ConflictManager.h"
#include "BmUtils.h"
#include "FunctionTracer.h"

namespace bmcore
{
/*************************************************************************
** FUNCTION:  ConflictManager::ConflictManager(...)
**************************************************************************/
ConflictManager::ConflictManager(const ComponentId ComponentId):
      ILocalSpm(ComponentId)
{
   ENTRY_INTERNAL
   ETG_TRACE_USR1(("ConflictManager Constructor Entered"));

   ConflictInfoList conflictList;

   //!Register conflicts of interest for CP, AAP and CarLife USB Limitation Controller
   Protocol protocolLimiMode(BM_PROTOCOL_ID_HFP, "");
   IssueInfo issueInfoLimiMode(BM_CONFLICT_TYPE_PROFILE_IN_USE, 0, protocolLimiMode,
            BT_PROFILE_USAGE_ACTIVE_CALL, BM_CONFLICT_STATE_NEW);
   conflictList.push_back(issueInfoLimiMode);

   //!Register conflicts of interest for CP USB Limitation Controller
   conflictsOfInterest.insert(pair<ConflictTrigger, ConflictInfoList> (BM_CONFLICT_TRIGGER_CP_USB, conflictList));
   conflictsOfInterest.insert(pair<ConflictTrigger, ConflictInfoList> (BM_CONFLICT_TRIGGER_CP_WIRELESS, conflictList));
   conflictsOfInterest.insert(pair<ConflictTrigger, ConflictInfoList> (BM_CONFLICT_TRIGGER_MIRRORLINK_USB, conflictList));
   conflictsOfInterest.insert(pair<ConflictTrigger, ConflictInfoList> (BM_CONFLICT_TRIGGER_MYSPIN_USB, conflictList));
   conflictsOfInterest.insert(pair<ConflictTrigger, ConflictInfoList> (BM_CONFLICT_TRIGGER_MYSPIN_IOS_USB, conflictList));
   conflictsOfInterest.insert(pair<ConflictTrigger, ConflictInfoList> (BM_CONFLICT_TRIGGER_CARLIFE_IOS_USB, conflictList));
   conflictsOfInterest.insert(pair<ConflictTrigger, ConflictInfoList> (BM_CONFLICT_TRIGGER_AAP_WIRELESS, conflictList));

   //!Register conflicts of interest for AAP and CarLife USB Limitation Controller
   Protocol protocolMaxPairedDevices(BM_PROTOCOL_ID_UNKNOWN, "");
   IssueInfo issueInfoMaxPairedDevices(BM_CONFLICT_TYPE_MAX_NUMBER_PAIRED_DEVICES_REACHED, 0, protocolMaxPairedDevices,
         BT_PROFILE_USAGE_NONE, BM_CONFLICT_STATE_NEW);
   conflictList.push_back(issueInfoMaxPairedDevices);

   conflictsOfInterest.insert(pair<ConflictTrigger, ConflictInfoList> (BM_CONFLICT_TRIGGER_AAP_USB, conflictList));
   conflictsOfInterest.insert(pair<ConflictTrigger, ConflictInfoList> (BM_CONFLICT_TRIGGER_CARLIFE_USB, conflictList));
   conflictsOfInterest.insert(pair<ConflictTrigger, ConflictInfoList> (BM_CONFLICT_TRIGGER_ONCAR_USB, conflictList));
   conflictList.clear();

   //!Register conflicts of interest for OOB BT Pairing
   Protocol protocolOob(BM_PROTOCOL_ID_UNKNOWN, "");
   IssueInfo issueInfoOob(BM_CONFLICT_TYPE_GENERIC, 0, protocolOob, BT_PROFILE_USAGE_NONE, BM_CONFLICT_STATE_NEW);
   conflictList.push_back(issueInfoOob);
   conflictsOfInterest.insert(pair<ConflictTrigger, ConflictInfoList> (BM_CONFLICT_TRIGGER_OOB_BT_PAIRING, conflictList));
   conflictList.clear();
}//! end of ConflictManager()

/*************************************************************************
** FUNCTION:  ConflictManager::~ConflictManager(...)
**************************************************************************/
ConflictManager::~ConflictManager()
{
   ETG_TRACE_USR1(("~ConflictManager Destructor Entered"));
}//!End of ~ConflictManager()

/*************************************************************************
** FUNCTION:  ConflictManager::processSetBtProfileUsageRequest(...)
**************************************************************************/
BmResult ConflictManager::processSetBtProfileUsageRequest(IN const BmCoreIfMessage_SetBtProfilesUsageRequest* bmCoreIfMessage)
{
   ETG_TRACE_USR1(("ConflictManager processSetBtProfileUsageRequest entered"));

   BmResult bmResult = BM_RESULT_OK;
   Result result = CC_ERR_INT_NO_ERROR;
   ProfileUsageList profileUsageList = bmCoreIfMessage->getProfileUsageInfoList();

   for(ProfileUsageInfoListItr itr = profileUsageList._btProfileUsageInfoList.begin();
         itr != profileUsageList._btProfileUsageInfoList.end(); itr++)
   {
      //!Check for invalid parameters.
      if((0u == itr->_deviceHandle)
            ||
            ((BM_PROTOCOL_ID_SPP == itr->_protocol._protocolId) && (true == itr->_protocol._uuid.empty()))
            ||
            ((BM_PROTOCOL_ID_SPP != itr->_protocol._protocolId) && (false == itr->_protocol._uuid.empty())))
      {
         bmResult = BM_RESULT_ERR_INVALID_PARAMETER;
         break;
      }//End of if((0u == itr->_deviceHandle) || ((BM_PROTOCOL_ID_SPP == ...)
   }//End of for(ProfileUsageInfoListItr itr = profileUsageList._btProfileUsageInfoList.begin(); ...)

   //!If all parameters are valid, update the profile usage list and inform registered clients
   if(BM_RESULT_OK == bmResult)
   {
      result = LocalSpm::getBmCoreMainController().updateBtProfileUsageInfoList(profileUsageList);
      bmResult = (CC_ERR_INT_NO_ERROR == result)?(BM_RESULT_OK):(BM_RESULT_ERR_GENERAL);
   }//End of if(BM_RESULT_OK == retVal)

   ETG_TRACE_USR4(("processSetBtProfileUsageRequest: (bmResult = %d)", ETG_CENUM(BmResult, bmResult)));
   return bmResult;
}//!End BmResult ConflictManager::processSetBtProfileUsageRequest(...)

/*************************************************************************
** FUNCTION:  ConflictManager::resolveConflicts(...)
**************************************************************************/
void ConflictManager::resolveConflicts(IN const ConflictTrigger conflictTrigger, IN const DeviceId deviceHandle)
{
   ETG_TRACE_USR1(("ConflictManager resolveConflicts entered - conflictTrigger = %d, deviceID = %d ",
         ETG_CENUM(ConflictTrigger, conflictTrigger), deviceHandle));

   bool sendProceed = true;
   map<ConflictTrigger, ConflictInfoList>::iterator itr;
   ConflictInfoList localconflictInfoList;

   itr = conflictsOfInterest.find(conflictTrigger);

   if(itr != conflictsOfInterest.end())
   {
      ConflictInfoList conflictList = itr->second;

      for(ConflictInfoListItr conflictListItr = conflictList.begin(); conflictListItr != conflictList.end(); conflictListItr++)
      {
         if(BM_CONFLICT_TYPE_PROFILE_IN_USE == conflictListItr->_conflictType)
         {
            //! Check if there are any profiles in use for DeviceID other than the input parameter deviceHandle
            ProfileUsageList profileUsageList;
            ProfileUsageInfoListItr profileListitr;
            LocalSpm::getBmCoreMainController().getBtProfileUsageInfoList(profileUsageList);

            for(profileListitr = profileUsageList._btProfileUsageInfoList.begin();
                  profileListitr != profileUsageList._btProfileUsageInfoList.end(); profileListitr++)
            {
               //!Resolve the conflict for Active Phone call if call is active on Non projection device
               if((conflictListItr->_protocol == profileListitr->_protocol) && (profileListitr->_deviceHandle != deviceHandle)
                     && (conflictListItr->_profileUsageType == profileListitr->_ProfileUsageType) && (true == profileListitr->_InUse))
               {
                  ETG_TRACE_USR4(("resolveConflicts - Profile is in use for deviceID = %d . Updating client to resolve the conflict",
                        profileListitr->_deviceHandle));

                  IssueInfo issueInfoLimiMode = *conflictListItr;
                  issueInfoLimiMode._deviceID = profileListitr->_deviceHandle;

                  localconflictInfoList.push_back(issueInfoLimiMode);
                  sendProceed = false;
               }//End of if((conflictListitr->_protocol == profileListitr->_protocol) &&...)
            }//End of for(ProfileUsageInfoListItr profileListitr = profileUsageList._btProfileUsageInfoList.begin();...)
         }//End of if(BM_CONFLICT_TYPE_PROFILE_IN_USE == conflictListItr->_conflictType)
         else if(BM_CONFLICT_TYPE_MAX_NUMBER_PAIRED_DEVICES_REACHED == conflictListItr->_conflictType)
         {
            // Requested devices is not available in db
            if(0 == deviceHandle)
            {
               // device is a new device
               uint32_t numberOfPairedDevices(0u);
               Result result = LocalSpm::getDbManager().getNumberOfDevices(numberOfPairedDevices);

               if (CC_ERR_INT_NO_ERROR == result)
               {
                  if (LocalSpm::getDataProvider().getBmCoreConfiguration()._maxNumPairedDevices <= numberOfPairedDevices)
                  {
                     ETG_TRACE_USR4(("resolveConflicts - Max devices are reached. Updating client to resolve the conflict"));

                     localconflictInfoList.push_back(*conflictListItr);
                     sendProceed = false;
                  }
               }
            }
         }
         //!For other conflict types no need to check the profile usage list
         else
         {
            ETG_TRACE_USR4(("resolveConflicts - ConflictTrigger = %d has registered for ConflictType = %d.Updating client to resolve conflict",
                  ETG_CENUM(ConflictTrigger, conflictTrigger), ETG_CENUM(ConflictType, conflictListItr->_conflictType)));

            localconflictInfoList.push_back(*conflictListItr);
            sendProceed = false;
         }//End of else
      }//End of for(ConflictInfoListItr conflictListItr = conflictList.begin();..)
   }//End of if(itr != conflictsOfInterest.end())


   if(true == sendProceed)
   {
      ETG_TRACE_USR4(("resolveConflicts - There are no conflicts of Interest registered for conflictTrigger = %d ",
            ETG_CENUM(ConflictTrigger, conflictTrigger)));

      //Inform the conflict triggerer to Proceed as there are no registered conflicts of interest.
      UserDecisionInfo userDecision(conflictTrigger, BM_USER_DECISION_PROCEED);
      BmCoreIfMessage_NotifyUserDecisionRequest bmCoreIfMessage;
      bmCoreIfMessage.setUserDecisionInfo(userDecision);
      (void)processNotifyUserDecisionRequest(&bmCoreIfMessage, true);
   }//End of else
   else
   {
      //Request client to resolve the conflict
      IssueInfoList issueList(conflictTrigger, localconflictInfoList);
      (void)LocalSpm::getBmCoreMainController().updateBtConflictsDetectedList(issueList);
   }//End of else
}//End of void ConflictManager::resolveConflicts(IN const ConflictTrigger conflictTrigger ...)

/*************************************************************************
 ** FUNCTION:  ConflictManager::processNotifyUserDecisionRequest(...)
 **************************************************************************/
BmResult ConflictManager::processNotifyUserDecisionRequest(IN const BmCoreIfMessage_NotifyUserDecisionRequest* bmCoreIfMessage, 
      IN const bool isInternallyTriggered)
{
   ETG_TRACE_USR1(("ConflictManager processNotifyUserDecisionRequest entered - isInternallyTriggered = %s",
         isInternallyTriggered ? "true" : "false"));

   BmResult bmResult = BM_RESULT_OK;
   IssueInfoList btConflictsDetectedList;
   UserDecisionInfo userDecision;

   LocalSpm::getBmCoreMainController().getBtConflictsDetectedList(btConflictsDetectedList);

   //!When received User Decision request by external client, process it only if there are any conflicts resolution pending
   //!else send an error as there are no conflicts to be resolved.
   if((false == isInternallyTriggered) && ((BM_CONFLICT_TRIGGER_NONE == btConflictsDetectedList._conflictTrigger) ||
         (true == btConflictsDetectedList._conflictInfoList.empty())))
   {
      ETG_TRACE_ERR(("processNotifyUserDecisionRequest - User decision to resolve conflicts received "
            "when there are no pending conflicts"));
      bmResult = BM_RESULT_ERR_NOT_ALLOWED;
   }//End of if((false == isInternallyTriggered) &&...)
   else if(NULL == bmCoreIfMessage)
   {
	   ETG_TRACE_ERR(("processNotifyUserDecisionRequest - bmCoreIfMessage is NULL "));
	   bmResult = BM_RESULT_ERR_INVALID_PARAMETER;
   }//End of else if(NULL != bmCoreIfMessage)

   if(BM_RESULT_OK == bmResult)
   {
   userDecision = bmCoreIfMessage->getUserDecisionInfo();
   ETG_TRACE_USR4(("processNotifyUserDecisionRequest UserDecisionInfo : ConflictTrigger = %d, UserDecision = %d",
   ETG_CENUM(ConflictTrigger, userDecision._conflictTrigger), ETG_CENUM(UserDecision, userDecision._userDecision)));

   if((false == isInternallyTriggered) && (userDecision._conflictTrigger != btConflictsDetectedList._conflictTrigger))
   {
   ETG_TRACE_ERR(("processNotifyUserDecisionRequest - User decision to resolve conflicts received "
   "for invalid conflict trigger"));
   bmResult = BM_RESULT_ERR_INVALID_PARAMETER;
   }//!End of if((userDecision._conflictTrigger != btConflictsDetectedList._conflictTrigger))
   }//!End of if((BM_RESULT_OK == bmResult) && (NULL != bmCoreIfMessage))

   if(BM_RESULT_OK == bmResult)
   {
      switch(userDecision._conflictTrigger)
      {
         case BM_CONFLICT_TRIGGER_AAP_USB:
         case BM_CONFLICT_TRIGGER_CP_USB:
         case BM_CONFLICT_TRIGGER_CARLIFE_USB:
         case BM_CONFLICT_TRIGGER_CARLIFE_IOS_USB:
         case BM_CONFLICT_TRIGGER_CP_WIRELESS:
         case BM_CONFLICT_TRIGGER_AAP_WIRELESS:
         case BM_CONFLICT_TRIGGER_ONCAR_USB:
         case BM_CONFLICT_TRIGGER_MIRRORLINK_USB:
         case BM_CONFLICT_TRIGGER_MYSPIN_USB:
         case BM_CONFLICT_TRIGGER_MYSPIN_IOS_USB:
         {
            LocalSpm::getBtLimitationController().onConflictsResolved(userDecision);
         }
         break;
         case BM_CONFLICT_TRIGGER_BT_PAIRING:
         case BM_CONFLICT_TRIGGER_OOB_BT_PAIRING:
         {
            //Trigger pairing controller
         }
         break;
         default:
         {
            ETG_TRACE_ERR(("processNotifyUserDecisionRequest - Conflict Trigger not handled"));
            bmResult = BM_RESULT_ERR_NOT_IMPLEMENTED;
         }
         break;
      }//End of switch
   }//End of if(BM_RESULT_OK == bmResult)

   if((BM_RESULT_OK == bmResult) && (false == isInternallyTriggered))
   {
      updateConflictsDetectedList(btConflictsDetectedList);
      LocalSpm::getBmCoreMainController().clearBtConflictsList(userDecision._conflictTrigger);
   }//End of if(BM_RESULT_OK == bmResult)

   return bmResult;
}//End of BmResult ConflictManager::processNotifyUserDecisionRequest(..)..

/*************************************************************************
 ** FUNCTION:  ConflictManager::processNotifyUserDecisionRequest(...)
 **************************************************************************/
void ConflictManager::processNotifyUserDecisionRequest(IN const UserDecisionInfo& userDecision)
{
   ETG_TRACE_USR1(("processNotifyUserDecisionRequest UserDecisionInfo : ConflictTrigger = %d, UserDecision = %d",
         ETG_CENUM(ConflictTrigger, userDecision._conflictTrigger), ETG_CENUM(UserDecision, userDecision._userDecision)));

   IssueInfoList btConflictsDetectedList;
   BmResult bmResult = BM_RESULT_OK;

   LocalSpm::getBmCoreMainController().getBtConflictsDetectedList(btConflictsDetectedList);

   if((false == btConflictsDetectedList._conflictInfoList.empty())
            && (userDecision._conflictTrigger != btConflictsDetectedList._conflictTrigger))
   {
      ETG_TRACE_ERR(("processNotifyUserDecisionRequest - User decision to resolve conflicts received "
            "for invalid conflict trigger"));
      bmResult = BM_RESULT_ERR_INVALID_PARAMETER;
   }//!End of else if(userDecision._conflictTrigger != btConflictsDetectedList._conflictTrigger)

   if(BM_RESULT_OK == bmResult)
   {
      updateConflictsDetectedList(btConflictsDetectedList);
      LocalSpm::getBmCoreMainController().clearBtConflictsList(userDecision._conflictTrigger);
   }//End of if(BM_RESULT_OK == bmResult)
}//!End of BmResult ConflictManager::processNotifyUserDecisionRequest(IN const UserDecisionInfo& userDecision)

/*************************************************************************
** FUNCTION:  ConflictManager::updateConflictsDetectedList(...)
**************************************************************************/
void ConflictManager::updateConflictsDetectedList(IN IssueInfoList& btConflictsDetectedList)
{
   ETG_TRACE_USR1(("ConflictManager updateConflictsDetectedList entered"));

   for(ConflictInfoListItr itr = btConflictsDetectedList._conflictInfoList.begin();
         itr != btConflictsDetectedList._conflictInfoList.end(); itr++)
   {
      itr->_conflictState = BM_CONFLICT_STATE_SOLVED;
   }//End of for(ConflictInfoListItr itr = btConflictsDetectedList._conflictInfoList.begin();...)

   LocalSpm::getBmCoreMainController().updateBtConflictsDetectedList(btConflictsDetectedList);
}//End of void ConflictManager::updateConflictsDetectedList(IN IssueInfoList& btConflictsDetectedList)
}//! End of namespace bmcore
