/**
 * @file BmGlobalLock.cpp
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the definition of global lock used by Bluetooth Connection Manager Core
 *
 * @copyright (c) 2016 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#include "BmGlobalLock.h"

namespace bmcore
{
   BmGlobalLock::BmGlobalLock() :
         _lock()
   {
   }

   BmGlobalLock::~BmGlobalLock()
   {
   }

   BmGlobalLock& BmGlobalLock::getInstance(void)
   {
      static BmGlobalLock globalLock;
      return globalLock;
   }
}
