/**
 * @file RequestData.h
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the declaration of the class RequestData
 *
 * @copyright (c) 2016 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#ifndef _REQUEST_DATA_BASE_H_
#define _REQUEST_DATA_BASE_H_

#include "BmAllTypesInternal.h"

namespace bmcore
{
   class RequestData
   {
   public:
      RequestData();

      RequestData(const RequestType& requestType, const bool& internal, const ConnectionRequestOrigin& origin);

      RequestData(const RequestData& other);

      virtual ~RequestData();

      friend void swap(RequestData& first, RequestData& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      RequestData& operator=(RequestData other);

      bool operator==(const RequestData& rhs) const;

      static std::size_t getRequestId(void);

      RequestType _requestType;
      bool _internal;
      ConnectionRequestOrigin _origin;

   private:
      static std::size_t requestId;
   };

   typedef std::vector<bmcore::RequestData*> RequestDataList;
}

#endif // _REQUEST_DATA_BASE_H_
