/**
 * @file RequestData.cpp
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the definition of the class RequestData
 *
 * @copyright (c) 2016 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/RequestData.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "RequestData.h"
#include "FunctionTracer.h"

namespace bmcore
{
   std::size_t RequestData::requestId = 0;

   RequestData::RequestData() :
      _requestType(BM_REQUEST_TYPE_UNKNOWN), _internal(false), _origin(BM_CONNECTION_REQUEST_ORIGIN_UNKNOWN)
   {
      ENTRY_INTERNAL

      requestId++;
   }

   RequestData::RequestData(const RequestType& requestType, const bool& internal, const ConnectionRequestOrigin& origin) :
      _requestType(requestType), _internal(internal), _origin(origin)
   {
      ENTRY_INTERNAL

      requestId++;
   }

   RequestData::RequestData(const RequestData& other) :
      _requestType(other._requestType), _internal(other._internal), _origin(other._origin)
   {
      ENTRY_INTERNAL

      requestId++;
   }

   RequestData::~RequestData()
   {
      ENTRY_INTERNAL
   }

   void swap(RequestData& first, RequestData& second)
   {
      ENTRY_INTERNAL

      using std::swap;

      swap(first._requestType, second._requestType);
      swap(first._internal, second._internal);
      swap(first._origin, second._origin);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   RequestData& RequestData::operator=(RequestData other)
   {
      ENTRY_INTERNAL

      swap(*this, other);

      return *this;
   }

   bool RequestData::operator==(const RequestData& rhs) const
   {
      ENTRY_INTERNAL

      return ((this->_requestType == rhs._requestType)
            && (this->_internal == rhs._internal)
            && (this->_origin == rhs._origin));
   }

   std::size_t RequestData::getRequestId(void)
   {
      return requestId;
   }
}
