/**
 * @file ConnectionRequestData.h
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the declaration of the class ConnectionRequestData
 *
 * @copyright (c) 2016 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#ifndef _CONNECTION_REQUEST_DATA_
#define _CONNECTION_REQUEST_DATA_

#include "BmAllTypesInternal.h"
#include "BmInterfaceTypesInternal.h"
#include "RequestData.h"
#include "Protocol.h"

namespace bmcore
{
   class ConnectionRequestData : public RequestData
   {
   public:
      ConnectionRequestData();

      ConnectionRequestData(const bool& internal, const ConnectionRequestOrigin& origin, const DeviceId& deviceId,
            const ProtocolList& protocolList, IN const PageTimeout& pageTimeout, const bool delayConnection);

      ConnectionRequestData(const ConnectionRequestData& other);

      virtual ~ConnectionRequestData();

      friend void swap(ConnectionRequestData& first, ConnectionRequestData& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      ConnectionRequestData& operator=(ConnectionRequestData other);

      bool operator==(const ConnectionRequestData& rhs) const;

      DeviceId _deviceId;
      ProtocolList _protocolList;
      PageTimeout _pageTimeout;
      bool _delayConnection;
   };
}

#endif // _CONNECTION_REQUEST_DATA_
