/**
 * @file BtLimitationDeviceType.h
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the declaration of the class BtLimitationDeviceType
 *
 * @copyright (c) 2016 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#ifndef _BT_LIMITATION_DEVICE_TYPE_H_
#define _BT_LIMITATION_DEVICE_TYPE_H_

#include "BmAllTypes.h"

namespace bmcore
{
   class BtLimitationDeviceType
   {
   public:
      BtLimitationDeviceType();

      BtLimitationDeviceType(const LimitationMode& limitationMode, const bool& limitedDevice);

      BtLimitationDeviceType(const BtLimitationDeviceType& other);

      virtual ~BtLimitationDeviceType();

      friend void swap(BtLimitationDeviceType& first, BtLimitationDeviceType& second);

      BtLimitationDeviceType& operator=(BtLimitationDeviceType other);

      bool operator==(const BtLimitationDeviceType& rhs) const;

      bool operator<(const BtLimitationDeviceType& rhs) const;

      LimitationMode _limitationMode;
      bool _limitedDevice;
   };

   typedef std::map<bmcore::BtLimitationDeviceType, ProtocolBlockStatusMap> BtLimitationDeviceTypeProtocolBlockStatusMap;
}

#endif // _BT_LIMITATION_DEVICE_TYPE_H_
