/**
 * @file BtLimitationDeviceType.cpp
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the definition of the class BtLimitationDeviceType
 *
 * @copyright (c) 2016 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BtLimitationDeviceType.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "BtLimitationDeviceType.h"
#include "FunctionTracer.h"

namespace bmcore
{
   BtLimitationDeviceType::BtLimitationDeviceType() :
      _limitationMode(BM_LIMITATION_FEATURE_IAP, BM_LIMITATION_COMMUNICATION_IF_USB), _limitedDevice(true)
   {
      ENTRY_INTERNAL
   }

   BtLimitationDeviceType::BtLimitationDeviceType(const LimitationMode& limitationMode, const bool& limitedDevice) :
      _limitationMode(limitationMode), _limitedDevice(limitedDevice)
   {
      ENTRY_INTERNAL
   }

   BtLimitationDeviceType::BtLimitationDeviceType(const BtLimitationDeviceType& other) :
      _limitationMode(other._limitationMode), _limitedDevice(other._limitedDevice)
   {
      ENTRY_INTERNAL
   }

   BtLimitationDeviceType::~BtLimitationDeviceType()
   {
      ENTRY_INTERNAL
   }

   void swap(BtLimitationDeviceType& first, BtLimitationDeviceType& second)
   {
      ENTRY_INTERNAL

      using std::swap;

      swap(first._limitationMode, second._limitationMode);
      swap(first._limitedDevice, second._limitedDevice);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BtLimitationDeviceType& BtLimitationDeviceType::operator=(BtLimitationDeviceType other)
   {
      ENTRY_INTERNAL

      swap(*this, other);

      return *this;
   }

   bool BtLimitationDeviceType::operator==(const BtLimitationDeviceType& rhs) const
   {
      ENTRY_INTERNAL

      return ((this->_limitationMode == rhs._limitationMode)
            && (this->_limitedDevice == rhs._limitedDevice));
   }

   bool BtLimitationDeviceType::operator<(const BtLimitationDeviceType& rhs) const
   {
      if (this->_limitationMode._limitationFeature < rhs._limitationMode._limitationFeature)
      {
         return true;
      }
      else if (this->_limitationMode._limitationFeature == rhs._limitationMode._limitationFeature)
      {
         if (this->_limitationMode._limitationCommunicationIf < rhs._limitationMode._limitationCommunicationIf)
         {
            return true;
         }
         else if (this->_limitationMode._limitationCommunicationIf == rhs._limitationMode._limitationCommunicationIf)
         {
            if ((true == this->_limitedDevice) && (false == rhs._limitedDevice))
            {
               return true;
            }
            else
            {
               return false;
            }
         }
         else
         {
            return false;
         }
      }
      else
      {
         return false;
      }

      return false;
   }
}
