/**
 * @file BmMeetsDeviceHandle.h
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the declaration of template class MeetsDeviceHandle
 *
 * @copyright (c) 2017 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#ifndef _BM_MEETS_DEVICE_HANDLE_
#define _BM_MEETS_DEVICE_HANDLE_

#include "BmInterfaceTypesInternal.h"

namespace bmcore
{
   template<class ItemType>
   class MeetsDeviceHandle
   {
   public:

      explicit MeetsDeviceHandle(const DeviceId deviceHandle);

      bool operator()(const ItemType& item) const;

   private:
      DeviceId _deviceHandle;
   };
}

#endif // _BM_MEETS_DEVICE_HANDLE_
