#ifndef _BM_CORE_IF_MESSAGES_CREATOR_H_
#define _BM_CORE_IF_MESSAGES_CREATOR_H_

#include "BmCoreIfMessages.h"

namespace bmcore
{
   inline BmCoreIfMessage_SetProtocolUserAvailabilityRequest* getNewBmCoreIfMessage_SetProtocolUserAvailabilityRequest(IN const Protocol& protocol,
         IN const bool available, IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_SetProtocolUserAvailabilityRequest(protocol, available, act, origin);
   }

   inline BmCoreIfMessage_SetAutoConnectionTypeRequest* getNewBmCoreIfMessage_SetAutoConnectionTypeRequest(IN const AutoConnectionType& autoConnectionType,
         IN const ActType act)
   {
      return new BmCoreIfMessage_SetAutoConnectionTypeRequest(autoConnectionType, act);
   }

   inline BmCoreIfMessage_SwitchBtStatusRequest* getNewBmCoreIfMessage_SwitchBtStatusRequest(IN const TargetSwitchState targetSwitchState,
         IN const bool suppressAutoConnectionAfterSwitchedOn, IN const bool delayBtOnRequest,  IN const bool updateLastMode, IN const ActType act)
   {
      return new BmCoreIfMessage_SwitchBtStatusRequest(targetSwitchState, suppressAutoConnectionAfterSwitchedOn, delayBtOnRequest, updateLastMode, act);
   }

   inline BmCoreIfMessage_SetBtLocalFriendlyNameRequest* getNewBmCoreIfMessage_SetBtLocalFriendlyNameRequest(IN const LocalFriendlyNameType& localFriendlyName,
         IN const ActType act)
   {
      return new BmCoreIfMessage_SetBtLocalFriendlyNameRequest(localFriendlyName, act);
   }

   inline BmCoreIfMessage_SwitchLocalPairableModeRequest* getNewBmCoreIfMessage_SwitchLocalPairableModeRequest(IN const TargetSwitchState targetSwitchState,
         IN const BdAddress& bdAddress, IN const ActType act)
   {
      return new BmCoreIfMessage_SwitchLocalPairableModeRequest(targetSwitchState, bdAddress, act);
   }

   inline BmCoreIfMessage_SwitchLocalConnectableModeRequest* getNewBmCoreIfMessage_SwitchLocalConnectableModeRequest(IN const TargetSwitchState targetSwitchState,
         IN const BdAddress& bdAddress, IN const ActType act)
   {
      return new BmCoreIfMessage_SwitchLocalConnectableModeRequest(targetSwitchState, bdAddress, act);
   }

   inline BmCoreIfMessage_SwitchDiscoveryStatusRequest* getNewBmCoreIfMessage_SwitchDiscoveryStatusRequest(void)
   {
      return new BmCoreIfMessage_SwitchDiscoveryStatusRequest();
   }

   inline BmCoreIfMessage_SwitchDiscoveryStatusRequest* getNewBmCoreIfMessage_SwitchDiscoveryStatusRequest(IN const TargetSwitchState targetSwitchState,
         IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_SwitchDiscoveryStatusRequest(targetSwitchState, act, origin);
   }

   inline BmCoreIfMessage_PairingStatusUpdate* getNewBmCoreIfMessage_PairingStatusUpdate(void)
   {
      return new BmCoreIfMessage_PairingStatusUpdate();
   }

   inline BmCoreIfMessage_PairingStatusUpdate* getNewBmCoreIfMessage_PairingStatusUpdate(IN const PairingStatus& pairingStatus)
   {
      return new BmCoreIfMessage_PairingStatusUpdate(pairingStatus);
   }

   inline BmCoreIfMessage_StartPairingRequest* getNewBmCoreIfMessage_StartPairingRequest(IN const BdAddress& bdAddress,
         IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_StartPairingRequest(bdAddress, act, origin);
   }

   inline BmCoreIfMessage_CancelPairingRequest* getNewBmCoreIfMessage_CancelPairingRequest(IN const ActType act,
         IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_CancelPairingRequest(act, origin);
   }

   inline BmCoreIfMessage_AcceptPairingRequestRequest* getNewBmCoreIfMessage_AcceptPairingRequestRequest(IN const ActType act,
         IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_AcceptPairingRequestRequest(act, origin);
   }

   inline BmCoreIfMessage_RejectPairingRequestRequest* getNewBmCoreIfMessage_RejectPairingRequestRequest(IN const ActType act,
         IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_RejectPairingRequestRequest(act, origin);
   }

   inline BmCoreIfMessage_SetPairingPinRequest* getNewBmCoreIfMessage_SetPairingPinRequest(IN const PairingPin& pairingPin,
         IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_SetPairingPinRequest(pairingPin, act, origin);
   }

   inline BmCoreIfMessage_AddOobPairedDeviceRequest* getNewBmCoreIfMessage_AddOobPairedDeviceRequest(IN const BdAddress& bdAddress,
         IN const BdName& bdName, IN const LinkKey& linkKey, IN const OobType oobType, IN const ActType act,
         IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_AddOobPairedDeviceRequest(bdAddress, bdName, linkKey, oobType, act, origin);
   }

   inline BmCoreIfMessage_DeleteDeviceRequest* getNewBmCoreIfMessage_DeleteDeviceRequest(IN const DeviceId deviceHandle,
         IN const DeviceHandleType deviceHandleType, IN const ActType act,
         IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_DeleteDeviceRequest(deviceHandle, deviceHandleType, act, origin);
   }

   inline BmCoreIfMessage_StartAutoConnectionSequenceRequest* getNewBmCoreIfMessage_StartAutoConnectionSequenceRequest(IN const TemporaryAutoConnectionType autoConnectionType,
         IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_StartAutoConnectionSequenceRequest(autoConnectionType, act, origin);
   }

   inline BmCoreIfMessage_StopAutoConnectionSequenceRequest* getNewBmCoreIfMessage_StopAutoConnectionSequenceRequest(IN const ActType act,
         IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_StopAutoConnectionSequenceRequest(act, origin);
   }

   inline BmCoreIfMessage_ConnectDeviceRequest* getNewBmCoreIfMessage_ConnectDeviceRequest(IN const DeviceId deviceHandle,
         IN const bool delayRequestProcessing, IN const PageTimeout pageTimeout, IN const ActType act,
         IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_ConnectDeviceRequest(deviceHandle, delayRequestProcessing, pageTimeout, act, origin);
   }

   inline BmCoreIfMessage_DisconnectDeviceRequest* getNewBmCoreIfMessage_DisconnectDeviceRequest(IN const DeviceId deviceHandle,
         IN const DeviceHandleType deviceHandleType, IN const DisconnectedReason disconnectedReason,
         IN const bool deleteDevice, IN const ActType act,
         IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_DisconnectDeviceRequest(deviceHandle, deviceHandleType, disconnectedReason,
            deleteDevice, act, origin);
   }

   inline BmCoreIfMessage_ConnectProfilesRequest* getNewBmCoreIfMessage_ConnectProfilesRequest(IN const DeviceId deviceHandle,
         IN const ProtocolList& protocolList, IN const PageTimeout pageTimeout, IN const ActType act,
         IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_ConnectProfilesRequest(deviceHandle, protocolList, pageTimeout, act, origin);
   }

   inline BmCoreIfMessage_DisconnectProfilesRequest* getNewBmCoreIfMessage_DisconnectProfilesRequest(IN const DeviceId deviceHandle,
         IN const ProtocolList& protocolList, IN const ActType act,
         IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_DisconnectProfilesRequest(deviceHandle, protocolList, act, origin);
   }

   inline BmCoreIfMessage_BlockDeviceRequest* getNewBmCoreIfMessage_BlockDeviceRequest(IN const DeviceId deviceHandle,
         IN const DeviceHandleType deviceHandleType, IN const ActType act,
         IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_BlockDeviceRequest(deviceHandle, deviceHandleType, act, origin);
   }

   inline BmCoreIfMessage_UnblockDeviceRequest* getNewBmCoreIfMessage_UnblockDeviceRequest(IN const DeviceId deviceHandle,
         IN const DeviceHandleType deviceHandleType, IN const ActType act,
         IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_UnblockDeviceRequest(deviceHandle, deviceHandleType, act, origin);
   }

   inline BmCoreIfMessage_BlockProfilesRequest* getNewBmCoreIfMessage_BlockProfilesRequest(IN const DeviceId deviceHandle,
         IN const ProtocolList& protocolList, IN const bool ignoreStopAutoconnection, IN const ActType act,
         IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_BlockProfilesRequest(deviceHandle, protocolList, ignoreStopAutoconnection, act, origin);
   }

   inline BmCoreIfMessage_UnblockProfilesRequest* getNewBmCoreIfMessage_UnblockProfilesRequest(IN const DeviceId deviceHandle,
         IN const ProtocolList& protocolList, IN const ActType act,
         IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_UnblockProfilesRequest(deviceHandle, protocolList, act, origin);
   }

   inline BmCoreIfMessage_PairedDeviceListUpdate* getNewBmCoreIfMessage_PairedDeviceListUpdate(void)
   {
      return new BmCoreIfMessage_PairedDeviceListUpdate();
   }

   inline BmCoreIfMessage_PairedDeviceListUpdate* getNewBmCoreIfMessage_PairedDeviceListUpdate(IN const PairedDeviceList& pairedDeviceList)
   {
      return new BmCoreIfMessage_PairedDeviceListUpdate(pairedDeviceList);
   }

   inline BmCoreIfMessage_DeviceConnectionStatusListUpdate* getNewBmCoreIfMessage_DeviceConnectionStatusListUpdate(void)
   {
      return new BmCoreIfMessage_DeviceConnectionStatusListUpdate();
   }

   inline BmCoreIfMessage_DeviceConnectionStatusListUpdate* getNewBmCoreIfMessage_DeviceConnectionStatusListUpdate(IN const DeviceConnectionStatusList& deviceConnectionStatusList)
   {
      return new BmCoreIfMessage_DeviceConnectionStatusListUpdate(deviceConnectionStatusList);
   }

   inline BmCoreIfMessage_SetFavoriteRequest* getNewBmCoreIfMessage_SetFavoriteRequest(IN const DeviceId deviceHandle,
         IN const FavoriteType favoriteType, IN const FavoriteIndex favoriteIndex, IN const ActType act,
         IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_SetFavoriteRequest(deviceHandle, favoriteType, favoriteIndex, act, origin);
   }

   inline BmCoreIfMessage_ClearFavoriteRequest* getNewBmCoreIfMessage_ClearFavoriteRequest(IN const DeviceId deviceHandle,
         IN const FavoriteType favoriteType, IN const ActType act,
         IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return new BmCoreIfMessage_ClearFavoriteRequest(deviceHandle, favoriteType, act, origin);
   }

   inline BmCoreIfMessage_StartServiceSearchRequest* getNewBmCoreIfMessage_StartServiceSearchRequest(IN const DeviceId deviceHandle,IN const ActType act,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
      {
         return new BmCoreIfMessage_StartServiceSearchRequest(deviceHandle, act, origin);
      }

      inline BmCoreIfMessage_StopServiceSearchRequest* getNewBmCoreIfMessage_StopServiceSearchRequest(IN const DeviceId deviceHandle,
            IN const ActType act,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT)
      {
         return new BmCoreIfMessage_StopServiceSearchRequest(deviceHandle,act, origin);
      }

   inline BmCoreIfMessage_UpdateLinkQualityRequest* getNewBmCoreIfMessage_UpdateLinkQualityRequest(void)
   {
      return new BmCoreIfMessage_UpdateLinkQualityRequest();
   }

   inline BmCoreIfMessage_UpdateLinkQualityRequest* getNewBmCoreIfMessage_UpdateLinkQualityRequest(IN const ActType act,
         IN const BmCoreIfMsgOrigin origin)
   {
      return new BmCoreIfMessage_UpdateLinkQualityRequest(act, origin);
   }

   inline BmCoreIfMessage_BlockStatusUpdate* getNewBmCoreIfMessage_BlockStatusUpdate(void)
   {
      return new BmCoreIfMessage_BlockStatusUpdate();
   }

   inline BmCoreIfMessage_BlockStatusUpdate* getNewBmCoreIfMessage_BlockStatusUpdate(IN const BlockStatus& blockStatus)
   {
      return new BmCoreIfMessage_BlockStatusUpdate(blockStatus);
   }

   inline BmCoreIfMessage_SetBtLimitationModeRequest* getNewBmCoreIfMessage_SetBtLimitationModeRequest(void)
   {
      return new BmCoreIfMessage_SetBtLimitationModeRequest();
   }

   inline BmCoreIfMessage_SetBtLimitationModeRequest* getNewBmCoreIfMessage_SetBtLimitationModeRequest(IN const ActType act)
   {
      return new BmCoreIfMessage_SetBtLimitationModeRequest(act);
   }

   inline BmCoreIfMessage_ReplaceBtLimitationModeRequest* getNewBmCoreIfMessage_ReplaceBtLimitationModeRequest(void)
   {
      return new BmCoreIfMessage_ReplaceBtLimitationModeRequest();
   }

   inline BmCoreIfMessage_ReplaceBtLimitationModeRequest* getNewBmCoreIfMessage_ReplaceBtLimitationModeRequest(IN const ActType act)
   {
      return new BmCoreIfMessage_ReplaceBtLimitationModeRequest(act);
   }

   inline BmCoreIfMessage_BtLimitationModeUpdate* getNewBmCoreIfMessage_BtLimitationModeUpdate(void)
   {
      return new BmCoreIfMessage_BtLimitationModeUpdate();
   }

   inline BmCoreIfMessage_BtLimitationModeUpdate* getNewBmCoreIfMessage_BtLimitationModeUpdate(IN const BtLimitationMode& btLimitationMode)
   {
      return new BmCoreIfMessage_BtLimitationModeUpdate(btLimitationMode);
   }

   inline BmCoreIfMessage_NotifyUserDecisionRequest* getNewBmCoreIfMessage_NotifyUserDecisionRequest(void)
   {
      return new BmCoreIfMessage_NotifyUserDecisionRequest();
   }

   inline BmCoreIfMessage_NotifyUserDecisionRequest* getNewBmCoreIfMessage_NotifyUserDecisionRequest(IN const ActType act)
   {
      return new BmCoreIfMessage_NotifyUserDecisionRequest(act);
   }

   inline BmCoreIfMessage_SwitchTestModeRequest* getNewBmCoreIfMessage_SwitchTestModeRequest(IN const TargetSwitchState& targetSwitchState,
         IN const BdAddress& bdAddress, IN const ActType act)
   {
      return new BmCoreIfMessage_SwitchTestModeRequest(targetSwitchState, bdAddress, act);
   }

   inline BmCoreIfMessage_ResetToDefaultRequest* getNewBmCoreIfMessage_ResetToDefaultRequest(IN const bool factorySettingsChanged,
         IN const ActType act)
   {
      return new BmCoreIfMessage_ResetToDefaultRequest(factorySettingsChanged, act);
   }

   inline BmCoreIfMessage_BtsFbConnectionInitialized* getNewBmCoreIfMessage_BtsFbConnectionInitialized(IN const BTSRequestResult requestResult,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsFbConnectionInitialized(requestResult, act);
   }

   inline BmCoreIfMessage_BtsLocalVersionInfo* getNewBmCoreIfMessage_BtsLocalVersionInfo(IN const BTSLocalVersionInfo& versionInfo,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsLocalVersionInfo(versionInfo, act);
   }

   inline BmCoreIfMessage_BtsSwitchBluetoothOnOffResult* getNewBmCoreIfMessage_BtsSwitchBluetoothOnOffResult(IN const BTSRequestResult requestResult,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsSwitchBluetoothOnOffResult(requestResult, act);
   }

   inline BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus* getNewBmCoreIfMessage_BtsCurrentBluetoothOnOffStatus(IN const BTSBluetoothMode bluetoothMode,
         IN const BTSBluetoothOffReason bluetoothOffReason, IN const BTSAdapterMode adapterMode,
         IN const BTSBDAddress& localDeviceAddress, IN const ActType act)
   {
      return new BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus(bluetoothMode, bluetoothOffReason, adapterMode,
            localDeviceAddress, act);
   }

   inline BmCoreIfMessage_BtsBluetoothHardwareOnOffResult* getNewBmCoreIfMessage_BtsBluetoothHardwareOnOffResult(IN const BTSRequestResult btsResult,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsBluetoothHardwareOnOffResult(btsResult, act);
   }

   inline BmCoreIfMessage_BtsSetLocalBtNameResult* getNewBmCoreIfMessage_BtsSetLocalBtNameResult(IN const BTSRequestResult requestResult,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsSetLocalBtNameResult(requestResult, act);
   }

   inline BmCoreIfMessage_BtsCurrentLocalBtName* getNewBmCoreIfMessage_BtsCurrentLocalBtName(IN const BTSDeviceName& adapterName)
   {
      return new BmCoreIfMessage_BtsCurrentLocalBtName(adapterName);
   }

   inline BmCoreIfMessage_BtsSetLocalAdapterModesResult* getNewBmCoreIfMessage_BtsSetLocalAdapterModesResult(IN const BTSRequestResult requestResult,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsSetLocalAdapterModesResult(requestResult, act);
   }

   inline BmCoreIfMessage_BtsCurrentDiscoverableMode* getNewBmCoreIfMessage_BtsCurrentDiscoverableMode(IN const BTSLocalMode discoverableMode,
         IN const BTSLocalModeOffReason offReason, IN const ActType act)
   {
      return new BmCoreIfMessage_BtsCurrentDiscoverableMode(discoverableMode, offReason, act);
   }

   inline BmCoreIfMessage_BtsCurrentConnectableMode* getNewBmCoreIfMessage_BtsCurrentConnectableMode(IN const BTSLocalMode connectableMode,
         IN const BTSLocalModeOffReason offReason, IN const ActType act)
   {
      return new BmCoreIfMessage_BtsCurrentConnectableMode(connectableMode, offReason, act);
   }

   inline BmCoreIfMessage_BtsStartDiscoveryResult* getNewBmCoreIfMessage_BtsStartDiscoveryResult(void)
   {
      return new BmCoreIfMessage_BtsStartDiscoveryResult();
   }

   inline BmCoreIfMessage_BtsStartDiscoveryResult* getNewBmCoreIfMessage_BtsStartDiscoveryResult(IN const BTSRequestResult requestResult,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsStartDiscoveryResult(requestResult, act);
   }

   inline BmCoreIfMessage_BtsStopDiscoveryResult* getNewBmCoreIfMessage_BtsStopDiscoveryResult(void)
   {
      return new BmCoreIfMessage_BtsStopDiscoveryResult();
   }

   inline BmCoreIfMessage_BtsStopDiscoveryResult* getNewBmCoreIfMessage_BtsStopDiscoveryResult(IN const BTSRequestResult requestResult,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsStopDiscoveryResult(requestResult, act);
   }

   inline BmCoreIfMessage_BtsDiscoveringStatus* getNewBmCoreIfMessage_BtsDiscoveringStatus(void)
   {
      return new BmCoreIfMessage_BtsDiscoveringStatus();
   }

   inline BmCoreIfMessage_BtsDiscoveringStatus* getNewBmCoreIfMessage_BtsDiscoveringStatus(IN const BTSDiscoveringStatus discoveringStatus,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsDiscoveringStatus(discoveringStatus, act);
   }

   inline BmCoreIfMessage_BtsDiscoveredDeviceFound* getNewBmCoreIfMessage_BtsDiscoveredDeviceFound(void)
   {
      return new BmCoreIfMessage_BtsDiscoveredDeviceFound();
   }

   inline BmCoreIfMessage_BtsDiscoveredDeviceFound* getNewBmCoreIfMessage_BtsDiscoveredDeviceFound(IN const BTSDiscoveredDeviceInfo discoveredDevice,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsDiscoveredDeviceFound(discoveredDevice, act);
   }

   inline BmCoreIfMessage_BtsStartPairingResult* getNewBmCoreIfMessage_BtsStartPairingResult(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const ActType act)
   {
      return new BmCoreIfMessage_BtsStartPairingResult(btsBdAddress, btsResult, act);
   }

   inline BmCoreIfMessage_BtsPinCodeRequested* getNewBmCoreIfMessage_BtsPinCodeRequested(IN const BTSBDAddress& btsBdAddress,
         IN const BTSDeviceName& btsBdName, IN const BTSPairConnectOriginator btsPairingOriginator,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsPinCodeRequested(btsBdAddress, btsBdName, btsPairingOriginator, act);
   }

   inline BmCoreIfMessage_BtsSecureSimplePairingRequested* getNewBmCoreIfMessage_BtsSecureSimplePairingRequested(IN const BTSBDAddress& btsBdAddress,
         IN const BTSDeviceName& btsBdName, IN const BTSSspMode btsSspMode, IN const BTSNumericValue& btsNumericValue,
         IN const BTSPairConnectOriginator btsPairingOriginator, IN const ActType act)
   {
      return new BmCoreIfMessage_BtsSecureSimplePairingRequested(btsBdAddress, btsBdName, btsSspMode, btsNumericValue,
            btsPairingOriginator, act);
   }

   inline BmCoreIfMessage_BtsPairingFinished* getNewBmCoreIfMessage_BtsPairingFinished(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const BTSLinkKeyType btsLinkKeyType, IN const BTSLinkKey& btsLinkKey,
         IN const BTSDLinkKey& btsDLinkKey, IN const BTSMajorServiceClass& btsMajorServiceClass,
         IN const BTSMajorDeviceClass btsMajorDeviceClass, IN const BTSMinorDeviceClass btsMinorDeviceClass,
         IN const BTSDeviceName& btsBdName, IN const ActType act)
   {
      return new BmCoreIfMessage_BtsPairingFinished(btsBdAddress, btsResult, btsLinkKeyType, btsLinkKey, btsDLinkKey,
            btsMajorServiceClass, btsMajorDeviceClass, btsMinorDeviceClass, btsBdName, act);
   }
/*
   inline BmCoreIfMessage_BtsPairingFinished* getNewBmCoreIfMessage_BtsPairingFinished(IN const DeviceBaseInfo& deviceBaseInfo,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsPairingFinished(deviceBaseInfo, act);
   }
*/

   inline BmCoreIfMessage_BtsLinkKeyRequested* getNewBmCoreIfMessage_BtsLinkKeyRequested(IN const BTSBDAddress& btsBdAddress,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsLinkKeyRequested(btsBdAddress, act);
   }

   inline BmCoreIfMessage_BtsSupportedServices* getNewBmCoreIfMessage_BtsSupportedServices(void)
   {
      return new BmCoreIfMessage_BtsSupportedServices();
   }

   inline BmCoreIfMessage_BtsSupportedServices* getNewBmCoreIfMessage_BtsSupportedServices(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const BTSSupportedServices& btsSupportedServices,
         IN const BTSServiceInfoList& btsServiceInfoList,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsSupportedServices(btsBdAddress, btsResult, btsSupportedServices,
            btsServiceInfoList, act);
   }

   inline BmCoreIfMessage_BtsSppCapabilities* getNewBmCoreIfMessage_BtsSppCapabilities(void)
   {
      return new BmCoreIfMessage_BtsSppCapabilities();
   }

   inline BmCoreIfMessage_BtsSppCapabilities* getNewBmCoreIfMessage_BtsSppCapabilities(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const BTSSppCapabilityList& btsSppCapabilities,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsSppCapabilities(btsBdAddress, btsResult, btsSppCapabilities, act);
   }

   inline BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords* getNewBmCoreIfMessage_BtsRemoteDeviceIdServiceRecords(void)
   {
      return new BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords();
   }

   inline BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords* getNewBmCoreIfMessage_BtsRemoteDeviceIdServiceRecords(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const BTSDeviceIdServiceRecordList& btsDeviceIdServiceRecords,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords(btsBdAddress, btsResult, btsDeviceIdServiceRecords, act);
   }

   inline BmCoreIfMessage_BtsDeviceCapabilities* getNewBmCoreIfMessage_BtsDeviceCapabilities(void)
   {
      return new BmCoreIfMessage_BtsDeviceCapabilities();
   }

   inline BmCoreIfMessage_BtsDeviceCapabilities* getNewBmCoreIfMessage_BtsDeviceCapabilities(IN const BTSBDAddress& bdAddress,
         IN const BTSDeviceCapabilities& deviceCapabilities, IN const ActType act)
   {
      return new BmCoreIfMessage_BtsDeviceCapabilities(bdAddress, deviceCapabilities, act);
   }

   inline BmCoreIfMessage_BtsRemoteServiceSearchResult* getNewBmCoreIfMessage_BtsRemoteServiceSearchResult(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsSupportedServicesResult, IN const BTSRequestResult btsSppCapabilitiesResult,
         IN const BTSRequestResult btsDeviceIdServiceRecordsResult,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsRemoteServiceSearchResult(btsBdAddress, btsSupportedServicesResult,
            btsSppCapabilitiesResult, btsDeviceIdServiceRecordsResult, act);
   }

   inline BmCoreIfMessage_BtsRemoteNameResult* getNewBmCoreIfMessage_BtsRemoteNameResult(IN const BTSBDAddress& btsBdAddress,
         IN const BTSDeviceName& btsBdName, IN const BTSRequestResult btsResult, IN const ActType act)
   {
      return new BmCoreIfMessage_BtsRemoteNameResult(btsBdAddress, btsBdName, btsResult, act);
   }

   inline BmCoreIfMessage_BtsRemoteNameStatusUpdate* getNewBmCoreIfMessage_BtsRemoteNameStatusUpdate(IN const BTSBDAddress& btsBdAddress,
         IN const BTSDeviceName& btsBdName, IN const ActType act)
   {
      return new BmCoreIfMessage_BtsRemoteNameStatusUpdate(btsBdAddress, btsBdName, act);
   }

   inline BmCoreIfMessage_BtsConnectProtocolResult* getNewBmCoreIfMessage_BtsConnectProtocolResult(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const BTSProtocolId btsProtocolId, IN const BTSUuid& btsSppUuid,
         IN const BTSMasInstanceName& btsMasInstance, IN const ActType act)
   {
      return new BmCoreIfMessage_BtsConnectProtocolResult(btsBdAddress, btsResult, btsProtocolId, btsSppUuid,
            btsMasInstance, act);
   }

   inline BmCoreIfMessage_BtsRemoteProtocolConnectRequest* getNewBmCoreIfMessage_BtsRemoteProtocolConnectRequest(IN const BTSBDAddress& btsBdAddress,
         IN const BTSProtocolId btsProtocolId, IN const BTSUuid& btsSppUuid, IN const ActType act)
   {
      return new BmCoreIfMessage_BtsRemoteProtocolConnectRequest(btsBdAddress, btsProtocolId, btsSppUuid, act);
   }

   inline BmCoreIfMessage_BtsDisconnectProtocolResult* getNewBmCoreIfMessage_BtsDisconnectProtocolResult(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const BTSProtocolId btsProtocolId, IN const BTSUuid& btsSppUuid,
         IN const BTSMasInstanceName& btsMasInstance, IN const ActType act)
   {
      return new BmCoreIfMessage_BtsDisconnectProtocolResult(btsBdAddress, btsResult, btsProtocolId, btsSppUuid,
            btsMasInstance, act);
   }

   inline BmCoreIfMessage_BtsDisconnectDeviceResult* getNewBmCoreIfMessage_BtsDisconnectDeviceResult(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const ActType act)
   {
      return new BmCoreIfMessage_BtsDisconnectDeviceResult(btsBdAddress, btsResult, act);
   }

   inline BmCoreIfMessage_BtsProtocolConnectionStatus* getNewBmCoreIfMessage_BtsProtocolConnectionStatus(IN const BTSBDAddress& btsBdAddress,
         IN const BTSConnectionStatus btsConnectionStatus, IN const BTSDisconnectReason btsDisconnectReason,
         IN const BTSProtocolId btsProtocolId, IN const BTSUuid& btsSppUuid, IN const BTSMasInstanceName& btsMasInstance,
         IN const BTSDeviceName& btsRfCommDevice, IN const ActType act)
   {
      return new BmCoreIfMessage_BtsProtocolConnectionStatus(btsBdAddress, btsConnectionStatus, btsDisconnectReason,
            btsProtocolId, btsSppUuid, btsMasInstance, btsRfCommDevice, act);
   }

   inline BmCoreIfMessage_BtsDeviceConnectionStatus* getNewBmCoreIfMessage_BtsDeviceConnectionStatus(IN const BTSBDAddress& btsBdAddress,
         IN const BTSConnectionStatus btsConnectionStatus, IN const BTSDisconnectReason btsDisconnectReason,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsDeviceConnectionStatus(btsBdAddress, btsConnectionStatus, btsDisconnectReason, act);
   }

   inline BmCoreIfMessage_BtsLinkQualityResult* getNewBmCoreIfMessage_BtsLinkQualityResult(void)
   {
      return new BmCoreIfMessage_BtsLinkQualityResult();
   }

   inline BmCoreIfMessage_BtsLinkQualityResult* getNewBmCoreIfMessage_BtsLinkQualityResult(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const BTSRssi btsRssi, IN const BTSLinkQuality btsLinkQuality,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsLinkQualityResult(btsBdAddress, btsResult, btsRssi, btsLinkQuality, act);
   }

   inline BmCoreIfMessage_BtsStartTestModeResult* getNewBmCoreIfMessage_BtsStartTestModeResult(IN const BTSRequestResult requestResult,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsStartTestModeResult(requestResult, act);
   }

   inline BmCoreIfMessage_BtsStopTestModeResult* getNewBmCoreIfMessage_BtsStopTestModeResult(IN const BTSRequestResult requestResult,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsStopTestModeResult(requestResult, act);
   }

   inline BmCoreIfMessage_BtsTestModeStatus* getNewBmCoreIfMessage_BtsTestModeStatus(IN const BTSBDAddress& deviceAddress,
         IN const BTSConnectionStatus connectionStatus, IN const BTSSessionHandle sessionHandle)
   {
      return new BmCoreIfMessage_BtsTestModeStatus(deviceAddress, connectionStatus, sessionHandle);
   }

   inline BmCoreIfMessage_BtsFbWblInitialized* getNewBmCoreIfMessage_BtsFbWblInitialized(IN const BTSRequestResult requestResult,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsFbWblInitialized(requestResult, act);
   }
   
   inline BmCoreIfMessage_BtsWblServiceAvailability* getNewBmCoreIfMessage_BtsWblServiceAvailability(IN const bool wblServiceAvailable,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsWblServiceAvailability(wblServiceAvailable, act);
   }

   inline BmCoreIfMessage_BtsWblLastIntendedMode* getNewBmCoreIfMessage_BtsWblLastIntendedMode(IN const BTSWblLastIntendedModeList& lastIntendedModeList,
         IN const ActType act)
   {
      return new BmCoreIfMessage_BtsWblLastIntendedMode(lastIntendedModeList, act);
   }

   inline BmCoreIfMessage_BtsWblSupportedFrequencies* getNewBmCoreIfMessage_BtsWblSupportedFrequencies(IN const BTSWblSupportedRestrictionEntryList&
		   supportedFrequenciesList, IN const ActType act)
   {
      return new BmCoreIfMessage_BtsWblSupportedFrequencies(supportedFrequenciesList, act);
   }

   inline BmCoreIfMessage_BtsWblHealthinessIndicator* getNewBmCoreIfMessage_BtsWblHealthinessIndicator(IN const BTSWblHealthinessIndicator&
         wblHealthinessIndicator, IN const ActType act)
   {
      return new BmCoreIfMessage_BtsWblHealthinessIndicator(wblHealthinessIndicator, act);
   }

   inline BmCoreIfMessage_TerminateMessageHandlerThread* getNewBmCoreIfMessage_TerminateMessageHandlerThread(void)
   {
      return new BmCoreIfMessage_TerminateMessageHandlerThread();
   }

   inline BmCoreIfMessage_SetDeviceRemoteConnectable* getNewBmCoreIfMessage_SetDeviceRemoteConnectable(IN const DeviceId deviceHandle,
         IN const RemoteConnectable remoteConnectable, IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL)
   {
      return new BmCoreIfMessage_SetDeviceRemoteConnectable(deviceHandle, remoteConnectable, act, origin);
   }

   inline BmCoreIfMessage_SetPrimaryHfpDeviceRequest* getNewBmCoreIfMessage_SetPrimaryHfpDeviceRequest(void)
   {
      return new BmCoreIfMessage_SetPrimaryHfpDeviceRequest();
   }

   inline BmCoreIfMessage_SetPrimaryHfpDeviceRequest* getNewBmCoreIfMessage_SetPrimaryHfpDeviceRequest(IN const DeviceId deviceHandle)
   {
      return new BmCoreIfMessage_SetPrimaryHfpDeviceRequest(deviceHandle);
   }

   inline BmCoreIfMessage_SmTimeout* getNewBmCoreIfMessage_BmCoreIfMessage_SmTimeout(void)
   {
      return new BmCoreIfMessage_SmTimeout();
   }

   inline BmCoreIfMessage_SmTimeout* getNewBmCoreIfMessage_BmCoreIfMessage_SmTimeout(IN const char* message)
   {
      return new BmCoreIfMessage_SmTimeout(message);
   }

   inline BmCoreIfMessage_SwitchMultiHFPSupportRequest* getNewBmCoreIfMessage_SwitchMultiHFPSupportRequest(IN const TargetSwitchState targetSwitchState, IN const ActType act)
   {
      return new BmCoreIfMessage_SwitchMultiHFPSupportRequest(targetSwitchState, act);
   }

   inline BmCoreIfMessage_SetBtProfilesUsageRequest* getNewBmCoreIfMessage_SetBtProfilesUsageRequest(void)
   {
      return new BmCoreIfMessage_SetBtProfilesUsageRequest();
   }

   inline BmCoreIfMessage_SetBtProfilesUsageRequest* getNewBmCoreIfMessage_SetBtProfilesUsageRequest(IN const ActType act)
   {
      return new BmCoreIfMessage_SetBtProfilesUsageRequest(act);
   }
   
   inline BmCoreIfMessage_SetDeviceUsagePreferenceRequest* getNewBmCoreIfMessage_SetDeviceUsagePreferenceRequest(IN const DeviceId deviceHandle,
         IN const UsagePreference usagePreference, IN const ActType act)
   {
      return new BmCoreIfMessage_SetDeviceUsagePreferenceRequest(deviceHandle, usagePreference, act);
   }

   inline BmCoreIfMessage_BtSystemState* getNewBmCoreIfMessage_BtSystemState(void)
   {
      return new BmCoreIfMessage_BtSystemState();
   }

   inline BmCoreIfMessage_BtSystemState* getNewBmCoreIfMessage_BtSystemState(IN const BtSystemState btSystemState, IN const ActType act,
		   IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL)
   {
      return new BmCoreIfMessage_BtSystemState(btSystemState, act, origin);
   }

}

#endif // _BM_CORE_IF_MESSAGES_CREATOR_H_
