#ifndef _BM_CORE_IF_MESSAGES_H_
#define _BM_CORE_IF_MESSAGES_H_

#include "BmCoreIfMessage.h"
#include "BmAllTypes.h"

namespace bmcore
{
   // *****************************************************************************************
   // ******************** Messages corresponding to BM Core IF calls *************************
   // *****************************************************************************************

   class BmCoreIfMessage_SetProtocolUserAvailabilityRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_SetProtocolUserAvailabilityRequest& first, BmCoreIfMessage_SetProtocolUserAvailabilityRequest& second);

      explicit BmCoreIfMessage_SetProtocolUserAvailabilityRequest();

      explicit BmCoreIfMessage_SetProtocolUserAvailabilityRequest(IN const Protocol& protocol, IN const bool available,
            IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_SetProtocolUserAvailabilityRequest(IN const BmCoreIfMessage_SetProtocolUserAvailabilityRequest& other);

      virtual ~BmCoreIfMessage_SetProtocolUserAvailabilityRequest();

      BmCoreIfMessage_SetProtocolUserAvailabilityRequest& operator=(BmCoreIfMessage_SetProtocolUserAvailabilityRequest other);

      bool operator==(const BmCoreIfMessage_SetProtocolUserAvailabilityRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setProtocol(IN const Protocol& protocol)
      {
         _protocol = protocol;
      }

      inline const Protocol getProtocol(void) const
      {
         return _protocol;
      }

      inline void setAvailable(IN const bool available)
      {
         _available = available;
      }

      inline bool isAvailable(void) const
      {
         return _available;
      }

   private:
      Protocol _protocol;
      bool     _available;
   };


   class BmCoreIfMessage_SetAutoConnectionTypeRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_SetAutoConnectionTypeRequest& first, BmCoreIfMessage_SetAutoConnectionTypeRequest& second);

      explicit BmCoreIfMessage_SetAutoConnectionTypeRequest();

      explicit BmCoreIfMessage_SetAutoConnectionTypeRequest(IN const AutoConnectionType& autoConnectionType,
            IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_SetAutoConnectionTypeRequest(IN const BmCoreIfMessage_SetAutoConnectionTypeRequest& other);

      virtual ~BmCoreIfMessage_SetAutoConnectionTypeRequest();

      BmCoreIfMessage_SetAutoConnectionTypeRequest& operator=(BmCoreIfMessage_SetAutoConnectionTypeRequest other);

      bool operator==(const BmCoreIfMessage_SetAutoConnectionTypeRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setAutoConnectionType(IN const AutoConnectionType& autoConnectionType)
      {
         _autoConnectionType = autoConnectionType;
      }

      inline const AutoConnectionType& getAutoConnectionType(void) const
      {
         return _autoConnectionType;
      }

   private:
      AutoConnectionType _autoConnectionType;
   };


   class BmCoreIfMessage_SwitchBtStatusRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_SwitchBtStatusRequest& first, BmCoreIfMessage_SwitchBtStatusRequest& second);

      explicit BmCoreIfMessage_SwitchBtStatusRequest();

      explicit BmCoreIfMessage_SwitchBtStatusRequest(IN const TargetSwitchState targetSwitchState,
            IN const bool suppressAutoConnectionAfterSwitchedOn, IN const bool delayBtOnRequest, IN const bool updateLastMode,
            IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_SwitchBtStatusRequest(IN const BmCoreIfMessage_SwitchBtStatusRequest& other);

      virtual ~BmCoreIfMessage_SwitchBtStatusRequest();

      BmCoreIfMessage_SwitchBtStatusRequest& operator=(BmCoreIfMessage_SwitchBtStatusRequest other);

      bool operator==(const BmCoreIfMessage_SwitchBtStatusRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setTargetSwitchState(IN const TargetSwitchState targetSwitchState)
      {
         _targetSwitchState = targetSwitchState;
      }

      inline TargetSwitchState getTargetSwitchState(void) const
      {
         return _targetSwitchState;
      }

      inline void setSuppressAutoConnectionAfterSwitchedOn(IN const bool suppressAutoConnectionAfterSwitchedOn)
      {
         _suppressAutoConnectionAfterSwitchedOn = suppressAutoConnectionAfterSwitchedOn;
      }

      inline bool getSuppressAutoConnectionAfterSwitchedOn(void) const
      {
         return _suppressAutoConnectionAfterSwitchedOn;
      }

      inline void setDelayBtOnRequest(IN const bool delayBtOnrequest)
      {
         _delayBtOnRequest = delayBtOnrequest;
      }

      inline bool getDelayBtOnRequest(void) const
      {
         return _delayBtOnRequest;
      }

      inline void setUpdateLastMode(IN const bool updateLastMode)
      {
         _updateLastMode = updateLastMode;
      }

      inline bool getUpdateLastMode(void) const
      {
         return _updateLastMode;
      }

   private:
      TargetSwitchState _targetSwitchState;
      bool _suppressAutoConnectionAfterSwitchedOn;
      bool _delayBtOnRequest;
      bool _updateLastMode;
   };


   class BmCoreIfMessage_SetBtLocalFriendlyNameRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_SetBtLocalFriendlyNameRequest& first, BmCoreIfMessage_SetBtLocalFriendlyNameRequest& second);

      explicit BmCoreIfMessage_SetBtLocalFriendlyNameRequest();

      explicit BmCoreIfMessage_SetBtLocalFriendlyNameRequest(IN const LocalFriendlyNameType& localFriendlyName,
            IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_SetBtLocalFriendlyNameRequest(IN const BmCoreIfMessage_SetBtLocalFriendlyNameRequest& other);

      virtual ~BmCoreIfMessage_SetBtLocalFriendlyNameRequest();

      BmCoreIfMessage_SetBtLocalFriendlyNameRequest& operator=(BmCoreIfMessage_SetBtLocalFriendlyNameRequest other);

      bool operator==(const BmCoreIfMessage_SetBtLocalFriendlyNameRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setLocalFriendlyName(IN const LocalFriendlyNameType& localFriendlyName)
      {
         _localFriendlyName = localFriendlyName;
      }

      inline const LocalFriendlyNameType& getLocalFriendlyName(void) const
      {
         return _localFriendlyName;
      }

   private:
      LocalFriendlyNameType _localFriendlyName;
   };


   class BmCoreIfMessage_SwitchLocalPairableModeRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_SwitchLocalPairableModeRequest& first, BmCoreIfMessage_SwitchLocalPairableModeRequest& second);

      explicit BmCoreIfMessage_SwitchLocalPairableModeRequest();

      explicit BmCoreIfMessage_SwitchLocalPairableModeRequest(IN const TargetSwitchState targetSwitchState,
            IN const BdAddress& bdAddress, IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_SwitchLocalPairableModeRequest(IN const BmCoreIfMessage_SwitchLocalPairableModeRequest& other);

      virtual ~BmCoreIfMessage_SwitchLocalPairableModeRequest();

      BmCoreIfMessage_SwitchLocalPairableModeRequest& operator=(BmCoreIfMessage_SwitchLocalPairableModeRequest other);

      bool operator==(const BmCoreIfMessage_SwitchLocalPairableModeRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setTargetSwitchState(IN const TargetSwitchState targetSwitchState)
      {
         _targetSwitchState = targetSwitchState;
      }

      inline TargetSwitchState getTargetSwitchState(void) const
      {
         return _targetSwitchState;
      }

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

   private:
      TargetSwitchState _targetSwitchState;
      BdAddress _bdAddress;
   };


   class BmCoreIfMessage_SwitchLocalConnectableModeRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_SwitchLocalConnectableModeRequest& first, BmCoreIfMessage_SwitchLocalConnectableModeRequest& second);

      explicit BmCoreIfMessage_SwitchLocalConnectableModeRequest();

      explicit BmCoreIfMessage_SwitchLocalConnectableModeRequest(IN const TargetSwitchState targetSwitchState,
            IN const BdAddress& bdAddress, IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_SwitchLocalConnectableModeRequest(IN const BmCoreIfMessage_SwitchLocalConnectableModeRequest& other);

      virtual ~BmCoreIfMessage_SwitchLocalConnectableModeRequest();

      BmCoreIfMessage_SwitchLocalConnectableModeRequest& operator=(BmCoreIfMessage_SwitchLocalConnectableModeRequest other);

      bool operator==(const BmCoreIfMessage_SwitchLocalConnectableModeRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setTargetSwitchState(IN const TargetSwitchState targetSwitchState)
      {
         _targetSwitchState = targetSwitchState;
      }

      inline TargetSwitchState getTargetSwitchState(void) const
      {
         return _targetSwitchState;
      }

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

   private:
      TargetSwitchState _targetSwitchState;
      BdAddress _bdAddress;
   };


   class BmCoreIfMessage_SwitchDiscoveryStatusRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_SwitchDiscoveryStatusRequest& first, BmCoreIfMessage_SwitchDiscoveryStatusRequest& second);

      explicit BmCoreIfMessage_SwitchDiscoveryStatusRequest();

      explicit BmCoreIfMessage_SwitchDiscoveryStatusRequest(IN const TargetSwitchState targetSwitchState,
            IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_SwitchDiscoveryStatusRequest(IN const BmCoreIfMessage_SwitchDiscoveryStatusRequest& other);

      virtual ~BmCoreIfMessage_SwitchDiscoveryStatusRequest();

      BmCoreIfMessage_SwitchDiscoveryStatusRequest& operator=(BmCoreIfMessage_SwitchDiscoveryStatusRequest other);

      bool operator==(const BmCoreIfMessage_SwitchDiscoveryStatusRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setTargetSwitchState(IN const TargetSwitchState targetSwitchState)
      {
         _targetSwitchState = targetSwitchState;
      }

      inline TargetSwitchState getTargetSwitchState(void) const
      {
         return _targetSwitchState;
      }

   private:
      TargetSwitchState _targetSwitchState;
   };


   class BmCoreIfMessage_PairingStatusUpdate : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_PairingStatusUpdate& first, BmCoreIfMessage_PairingStatusUpdate& second);

      explicit BmCoreIfMessage_PairingStatusUpdate();

      explicit BmCoreIfMessage_PairingStatusUpdate(IN const PairingStatus& pairingStatus);

      BmCoreIfMessage_PairingStatusUpdate(IN const BmCoreIfMessage_PairingStatusUpdate& other);

      virtual ~BmCoreIfMessage_PairingStatusUpdate();

      BmCoreIfMessage_PairingStatusUpdate& operator=(BmCoreIfMessage_PairingStatusUpdate other);

      bool operator==(const BmCoreIfMessage_PairingStatusUpdate& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setPairingStatus(IN const PairingStatus& pairingStatus)
      {
         _pairingStatus = pairingStatus;
      }

      inline const PairingStatus& getPairingStatus(void) const
      {
         return _pairingStatus;
      }

   private:

      PairingStatus _pairingStatus;
   };


   class BmCoreIfMessage_PairedDeviceListUpdate : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_PairedDeviceListUpdate& first, BmCoreIfMessage_PairedDeviceListUpdate& second);

      explicit BmCoreIfMessage_PairedDeviceListUpdate();

      explicit BmCoreIfMessage_PairedDeviceListUpdate(IN const PairedDeviceList& pairedDeviceList);

      BmCoreIfMessage_PairedDeviceListUpdate(IN const BmCoreIfMessage_PairedDeviceListUpdate& other);

      virtual ~BmCoreIfMessage_PairedDeviceListUpdate();

      BmCoreIfMessage_PairedDeviceListUpdate& operator=(BmCoreIfMessage_PairedDeviceListUpdate other);

      bool operator==(const BmCoreIfMessage_PairedDeviceListUpdate& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setPairedDeviceList(IN const PairedDeviceList& pairedDeviceList)
      {
         _pairedDeviceList = pairedDeviceList;
      }

      inline const PairedDeviceList& getPairedDeviceList(void) const
      {
         return _pairedDeviceList;
      }

   private:

      PairedDeviceList _pairedDeviceList;
   };


   class BmCoreIfMessage_StartPairingRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_StartPairingRequest& first, BmCoreIfMessage_StartPairingRequest& second);

      explicit BmCoreIfMessage_StartPairingRequest();

      explicit BmCoreIfMessage_StartPairingRequest(IN const BdAddress& bdAddress, IN const ActType act,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_StartPairingRequest(IN const BmCoreIfMessage_StartPairingRequest& other);

      virtual ~BmCoreIfMessage_StartPairingRequest();

      BmCoreIfMessage_StartPairingRequest& operator=(BmCoreIfMessage_StartPairingRequest other);

      bool operator==(const BmCoreIfMessage_StartPairingRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

   private:
      BdAddress _bdAddress;
   };


   class BmCoreIfMessage_CancelPairingRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_CancelPairingRequest& first, BmCoreIfMessage_CancelPairingRequest& second);

      explicit BmCoreIfMessage_CancelPairingRequest();

      explicit BmCoreIfMessage_CancelPairingRequest(IN const ActType act,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_CancelPairingRequest(IN const BmCoreIfMessage_CancelPairingRequest& other);

      virtual ~BmCoreIfMessage_CancelPairingRequest();

      BmCoreIfMessage_CancelPairingRequest& operator=(BmCoreIfMessage_CancelPairingRequest other);

      bool operator==(const BmCoreIfMessage_CancelPairingRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;
   };


   class BmCoreIfMessage_AcceptPairingRequestRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_AcceptPairingRequestRequest& first, BmCoreIfMessage_AcceptPairingRequestRequest& second);

      explicit BmCoreIfMessage_AcceptPairingRequestRequest();

      explicit BmCoreIfMessage_AcceptPairingRequestRequest(IN const ActType act,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_AcceptPairingRequestRequest(IN const BmCoreIfMessage_AcceptPairingRequestRequest& other);

      virtual ~BmCoreIfMessage_AcceptPairingRequestRequest();

      BmCoreIfMessage_AcceptPairingRequestRequest& operator=(BmCoreIfMessage_AcceptPairingRequestRequest other);

      bool operator==(const BmCoreIfMessage_AcceptPairingRequestRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;
   };


   class BmCoreIfMessage_RejectPairingRequestRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_RejectPairingRequestRequest& first, BmCoreIfMessage_RejectPairingRequestRequest& second);

      explicit BmCoreIfMessage_RejectPairingRequestRequest();

      explicit BmCoreIfMessage_RejectPairingRequestRequest(IN const ActType act,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_RejectPairingRequestRequest(IN const BmCoreIfMessage_RejectPairingRequestRequest& other);

      virtual ~BmCoreIfMessage_RejectPairingRequestRequest();

      BmCoreIfMessage_RejectPairingRequestRequest& operator=(BmCoreIfMessage_RejectPairingRequestRequest other);

      bool operator==(const BmCoreIfMessage_RejectPairingRequestRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;
   };


   class BmCoreIfMessage_SetPairingPinRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_SetPairingPinRequest& first, BmCoreIfMessage_SetPairingPinRequest& second);

      explicit BmCoreIfMessage_SetPairingPinRequest();

      explicit BmCoreIfMessage_SetPairingPinRequest(IN const PairingPin& pairingPin, IN const ActType act,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_SetPairingPinRequest(IN const BmCoreIfMessage_SetPairingPinRequest& other);

      virtual ~BmCoreIfMessage_SetPairingPinRequest();

      BmCoreIfMessage_SetPairingPinRequest& operator=(BmCoreIfMessage_SetPairingPinRequest other);

      bool operator==(const BmCoreIfMessage_SetPairingPinRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setPairingPin(IN const PairingPin& pairingPin)
      {
         _pairingPin = pairingPin;
      }

      inline const PairingPin& getPairingPin(void) const
      {
         return _pairingPin;
      }

   private:
      PairingPin _pairingPin;
   };


   class BmCoreIfMessage_AddOobPairedDeviceRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_AddOobPairedDeviceRequest& first, BmCoreIfMessage_AddOobPairedDeviceRequest& second);

      explicit BmCoreIfMessage_AddOobPairedDeviceRequest();

      explicit BmCoreIfMessage_AddOobPairedDeviceRequest(IN const BdAddress& bdAddress, IN const BdName& bdName,
            IN const LinkKey& linkKey, IN const OobType oobType, IN const ActType act,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_AddOobPairedDeviceRequest(IN const BmCoreIfMessage_AddOobPairedDeviceRequest& other);

      virtual ~BmCoreIfMessage_AddOobPairedDeviceRequest();

      BmCoreIfMessage_AddOobPairedDeviceRequest& operator=(BmCoreIfMessage_AddOobPairedDeviceRequest other);

      bool operator==(const BmCoreIfMessage_AddOobPairedDeviceRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setBdName(IN const BdName& bdName)
      {
         _bdName = bdName;
      }

      inline const BdName& getBdName(void) const
      {
         return _bdName;
      }

      inline void setLinkKey(IN const LinkKey& linkKey)
      {
         _linkKey = linkKey;
      }

      inline const LinkKey& getLinkKey(void) const
      {
         return _linkKey;
      }

      inline void setOobType(IN const OobType oobType)
      {
         _oobType = oobType;
      }

      inline OobType getOobType(void) const
      {
         return _oobType;
      }
   private:
      BdAddress _bdAddress;
      BdName    _bdName;
      LinkKey   _linkKey;
      OobType   _oobType;
   };


   class BmCoreIfMessage_DeleteDeviceRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_DeleteDeviceRequest& first, BmCoreIfMessage_DeleteDeviceRequest& second);

      explicit BmCoreIfMessage_DeleteDeviceRequest();

      explicit BmCoreIfMessage_DeleteDeviceRequest(IN const DeviceId deviceHandle,
            IN const DeviceHandleType deviceHandleType, IN const ActType act,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_DeleteDeviceRequest(IN const BmCoreIfMessage_DeleteDeviceRequest& other);

      virtual ~BmCoreIfMessage_DeleteDeviceRequest();

      BmCoreIfMessage_DeleteDeviceRequest& operator=(BmCoreIfMessage_DeleteDeviceRequest other);

      bool operator==(const BmCoreIfMessage_DeleteDeviceRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDeviceHandle(IN const DeviceId deviceHandle)
      {
         _deviceHandle = deviceHandle;
      }

      inline DeviceId getDeviceHandle(void) const
      {
         return _deviceHandle;
      }

      inline void setDeviceHandleType(IN const DeviceHandleType deviceHandleType)
      {
         _deviceHandleType = deviceHandleType;
      }

      inline DeviceHandleType getDeviceHandleType(void) const
      {
         return _deviceHandleType;
      }

   private:
      DeviceId _deviceHandle;
      DeviceHandleType _deviceHandleType;
   };


   class BmCoreIfMessage_StartAutoConnectionSequenceRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_StartAutoConnectionSequenceRequest& first, BmCoreIfMessage_StartAutoConnectionSequenceRequest& second);

      explicit BmCoreIfMessage_StartAutoConnectionSequenceRequest();

      explicit BmCoreIfMessage_StartAutoConnectionSequenceRequest(IN const TemporaryAutoConnectionType autoConnectionType,
            IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_StartAutoConnectionSequenceRequest(IN const BmCoreIfMessage_StartAutoConnectionSequenceRequest& other);

      virtual ~BmCoreIfMessage_StartAutoConnectionSequenceRequest();

      BmCoreIfMessage_StartAutoConnectionSequenceRequest& operator=(BmCoreIfMessage_StartAutoConnectionSequenceRequest other);

      bool operator==(const BmCoreIfMessage_StartAutoConnectionSequenceRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setTemporaryAutoConnectionType(IN const TemporaryAutoConnectionType temporaryAutoConnectionType)
      {
         _temporaryAutoConnectionType = temporaryAutoConnectionType;
      }

      inline TemporaryAutoConnectionType getTemporaryAutoConnectionType(void) const
      {
         return _temporaryAutoConnectionType;
      }

   private:
      TemporaryAutoConnectionType _temporaryAutoConnectionType;
   };


   class BmCoreIfMessage_StopAutoConnectionSequenceRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_StopAutoConnectionSequenceRequest& first, BmCoreIfMessage_StopAutoConnectionSequenceRequest& second);

      explicit BmCoreIfMessage_StopAutoConnectionSequenceRequest();

      explicit BmCoreIfMessage_StopAutoConnectionSequenceRequest(IN const ActType act,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_StopAutoConnectionSequenceRequest(IN const BmCoreIfMessage_StopAutoConnectionSequenceRequest& other);

      virtual ~BmCoreIfMessage_StopAutoConnectionSequenceRequest();

      BmCoreIfMessage_StopAutoConnectionSequenceRequest& operator=(BmCoreIfMessage_StopAutoConnectionSequenceRequest other);

      bool operator==(const BmCoreIfMessage_StopAutoConnectionSequenceRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;
   };


   class BmCoreIfMessage_ConnectDeviceRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_ConnectDeviceRequest& first, BmCoreIfMessage_ConnectDeviceRequest& second);

      explicit BmCoreIfMessage_ConnectDeviceRequest();

      explicit BmCoreIfMessage_ConnectDeviceRequest(IN const DeviceId deviceHandle, IN const bool delayRequestProcessing, IN const PageTimeout pageTimeout,
            IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_ConnectDeviceRequest(IN const BmCoreIfMessage_ConnectDeviceRequest& other);

      virtual ~BmCoreIfMessage_ConnectDeviceRequest();

      BmCoreIfMessage_ConnectDeviceRequest& operator=(BmCoreIfMessage_ConnectDeviceRequest other);

      bool operator==(const BmCoreIfMessage_ConnectDeviceRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDeviceHandle(IN const DeviceId deviceHandle)
      {
         _deviceHandle = deviceHandle;
      }

      inline DeviceId getDeviceHandle(void) const
      {
         return _deviceHandle;
      }

      inline void setDelayRequestProcessing(IN const bool delayRequestProcessing)
      {
         _delayRequestProcessing = delayRequestProcessing;
      }

      inline bool getDelayRequestProcessing(void) const
      {
         return _delayRequestProcessing;
      }
      inline PageTimeout getPageTimeout(void) const
      {
         return _pageTimeout;
      }
      inline void setPageTimeout( IN const PageTimeout pageTimeout)
      {
         _pageTimeout = pageTimeout;
      }

   private:
      DeviceId _deviceHandle;
      bool _delayRequestProcessing;
      PageTimeout _pageTimeout;
   };


   class BmCoreIfMessage_DisconnectDeviceRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_DisconnectDeviceRequest& first, BmCoreIfMessage_DisconnectDeviceRequest& second);

      explicit BmCoreIfMessage_DisconnectDeviceRequest();

      explicit BmCoreIfMessage_DisconnectDeviceRequest(IN const DeviceId deviceHandle,
            IN const DeviceHandleType deviceHandleType, IN const DisconnectedReason disconnectedReason,
            IN const bool deleteDevice, IN const ActType act,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_DisconnectDeviceRequest(IN const BmCoreIfMessage_DisconnectDeviceRequest& other);

      virtual ~BmCoreIfMessage_DisconnectDeviceRequest();

      BmCoreIfMessage_DisconnectDeviceRequest& operator=(BmCoreIfMessage_DisconnectDeviceRequest other);

      bool operator==(const BmCoreIfMessage_DisconnectDeviceRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDeviceHandle(IN const DeviceId deviceHandle)
      {
         _deviceHandle = deviceHandle;
      }

      inline DeviceId getDeviceHandle(void) const
      {
         return _deviceHandle;
      }

      inline void setDeviceHandleType(IN const DeviceHandleType deviceHandleType)
      {
         _deviceHandleType = deviceHandleType;
      }

      inline DeviceHandleType getDeviceHandleType(void) const
      {
         return _deviceHandleType;
      }

      inline void setDisconnectedReason(IN const DisconnectedReason disconnectedReason)
      {
         _disconnectedReason = disconnectedReason;
      }

      inline DisconnectedReason getDisconnectedReason(void) const
      {
         return _disconnectedReason;
      }

      inline void setDeleteDevice(IN const bool deleteDevice)
      {
         _deleteDevice = deleteDevice;
      }

      inline bool getDeleteDevice(void) const
      {
         return _deleteDevice;
      }

   private:
      DeviceId _deviceHandle;
      DeviceHandleType _deviceHandleType;
      DisconnectedReason _disconnectedReason;
      bool _deleteDevice;
   };


   class BmCoreIfMessage_ConnectProfilesRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_ConnectProfilesRequest& first, BmCoreIfMessage_ConnectProfilesRequest& second);

      explicit BmCoreIfMessage_ConnectProfilesRequest();

      explicit BmCoreIfMessage_ConnectProfilesRequest(IN const DeviceId deviceHandle, IN const ProtocolList& protocolList,
            IN const PageTimeout pageTimeout, IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_ConnectProfilesRequest(IN const BmCoreIfMessage_ConnectProfilesRequest& other);

      virtual ~BmCoreIfMessage_ConnectProfilesRequest();

      BmCoreIfMessage_ConnectProfilesRequest& operator=(BmCoreIfMessage_ConnectProfilesRequest other);

      bool operator==(const BmCoreIfMessage_ConnectProfilesRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDeviceHandle(IN const DeviceId deviceHandle)
      {
         _deviceHandle = deviceHandle;
      }

      inline DeviceId getDeviceHandle(void) const
      {
         return _deviceHandle;
      }

      inline void setProtocolList(IN const ProtocolList& protocolList)
      {
         _protocolList = protocolList;
      }

      inline const ProtocolList& getProtocolList(void) const
      {
         return _protocolList;
      }

      inline const PageTimeout& getPageTimeout(void) const
      {
         return _pageTimeout;
      }

   private:
      DeviceId _deviceHandle;
      ProtocolList _protocolList;
      PageTimeout _pageTimeout;
   };


   class BmCoreIfMessage_DisconnectProfilesRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_DisconnectProfilesRequest& first, BmCoreIfMessage_DisconnectProfilesRequest& second);

      explicit BmCoreIfMessage_DisconnectProfilesRequest();

      explicit BmCoreIfMessage_DisconnectProfilesRequest(IN const DeviceId deviceHandle, IN const ProtocolList& protocolList,
            IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_DisconnectProfilesRequest(IN const BmCoreIfMessage_DisconnectProfilesRequest& other);

      virtual ~BmCoreIfMessage_DisconnectProfilesRequest();

      BmCoreIfMessage_DisconnectProfilesRequest& operator=(BmCoreIfMessage_DisconnectProfilesRequest other);

      bool operator==(const BmCoreIfMessage_DisconnectProfilesRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDeviceHandle(IN const DeviceId deviceHandle)
      {
         _deviceHandle = deviceHandle;
      }

      inline DeviceId getDeviceHandle(void) const
      {
         return _deviceHandle;
      }

      inline void setProtocolList(IN const ProtocolList& protocolList)
      {
         _protocolList = protocolList;
      }

      inline const ProtocolList& getProtocolList(void) const
      {
         return _protocolList;
      }

   private:
      DeviceId _deviceHandle;
      ProtocolList _protocolList;
   };


   class BmCoreIfMessage_BlockDeviceRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BlockDeviceRequest& first, BmCoreIfMessage_BlockDeviceRequest& second);

      explicit BmCoreIfMessage_BlockDeviceRequest();

      explicit BmCoreIfMessage_BlockDeviceRequest(IN const DeviceId deviceHandle,
            IN const DeviceHandleType deviceHandleType, IN const ActType act,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_BlockDeviceRequest(IN const BmCoreIfMessage_BlockDeviceRequest& other);

      virtual ~BmCoreIfMessage_BlockDeviceRequest();

      BmCoreIfMessage_BlockDeviceRequest& operator=(BmCoreIfMessage_BlockDeviceRequest other);

      bool operator==(const BmCoreIfMessage_BlockDeviceRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDeviceHandle(IN const DeviceId deviceHandle)
      {
         _deviceHandle = deviceHandle;
      }

      inline DeviceId getDeviceHandle(void) const
      {
         return _deviceHandle;
      }

      inline void setDeviceHandleType(IN const DeviceHandleType deviceHandleType)
      {
         _deviceHandleType = deviceHandleType;
      }

      inline DeviceHandleType getDeviceHandleType(void) const
      {
         return _deviceHandleType;
      }

   private:
      DeviceId _deviceHandle;
      DeviceHandleType _deviceHandleType;
   };


   class BmCoreIfMessage_UnblockDeviceRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_UnblockDeviceRequest& first, BmCoreIfMessage_UnblockDeviceRequest& second);

      explicit BmCoreIfMessage_UnblockDeviceRequest();

      explicit BmCoreIfMessage_UnblockDeviceRequest(IN const DeviceId deviceHandle,
            IN const DeviceHandleType deviceHandleType, IN const ActType act,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_UnblockDeviceRequest(IN const BmCoreIfMessage_UnblockDeviceRequest& other);

      virtual ~BmCoreIfMessage_UnblockDeviceRequest();

      BmCoreIfMessage_UnblockDeviceRequest& operator=(BmCoreIfMessage_UnblockDeviceRequest other);

      bool operator==(const BmCoreIfMessage_UnblockDeviceRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDeviceHandle(IN const DeviceId deviceHandle)
      {
         _deviceHandle = deviceHandle;
      }

      inline DeviceId getDeviceHandle(void) const
      {
         return _deviceHandle;
      }

      inline void setDeviceHandleType(IN const DeviceHandleType deviceHandleType)
      {
         _deviceHandleType = deviceHandleType;
      }

      inline DeviceHandleType getDeviceHandleType(void) const
      {
         return _deviceHandleType;
      }

   private:
      DeviceId _deviceHandle;
      DeviceHandleType _deviceHandleType;
   };


   class BmCoreIfMessage_BlockProfilesRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BlockProfilesRequest& first, BmCoreIfMessage_BlockProfilesRequest& second);

      explicit BmCoreIfMessage_BlockProfilesRequest();

      explicit BmCoreIfMessage_BlockProfilesRequest(IN const DeviceId deviceHandle, IN const ProtocolList& protocolList, IN const bool ignoreStopAutoconnection,
            IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_BlockProfilesRequest(IN const BmCoreIfMessage_BlockProfilesRequest& other);

      virtual ~BmCoreIfMessage_BlockProfilesRequest();

      BmCoreIfMessage_BlockProfilesRequest& operator=(BmCoreIfMessage_BlockProfilesRequest other);

      bool operator==(const BmCoreIfMessage_BlockProfilesRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDeviceHandle(IN const DeviceId deviceHandle)
      {
         _deviceHandle = deviceHandle;
      }

      inline DeviceId getDeviceHandle(void) const
      {
         return _deviceHandle;
      }

      inline void setProtocolList(IN const ProtocolList& protocolList)
      {
         _protocolList = protocolList;
      }

      inline const ProtocolList& getProtocolList(void) const
      {
         return _protocolList;
      }

      inline const bool& getIgnoreStopAutoconectionStatus(void) const
       {
          return _ignoreStopAutoconnection;
       }


   private:
      DeviceId _deviceHandle;
      ProtocolList _protocolList;
      bool _ignoreStopAutoconnection;
   };


   class BmCoreIfMessage_UnblockProfilesRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_UnblockProfilesRequest& first, BmCoreIfMessage_UnblockProfilesRequest& second);

      explicit BmCoreIfMessage_UnblockProfilesRequest();

      explicit BmCoreIfMessage_UnblockProfilesRequest(IN const DeviceId deviceHandle, IN const ProtocolList& protocolList,
            IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_UnblockProfilesRequest(IN const BmCoreIfMessage_UnblockProfilesRequest& other);

      virtual ~BmCoreIfMessage_UnblockProfilesRequest();

      BmCoreIfMessage_UnblockProfilesRequest& operator=(BmCoreIfMessage_UnblockProfilesRequest other);

      bool operator==(const BmCoreIfMessage_UnblockProfilesRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDeviceHandle(IN const DeviceId deviceHandle)
      {
         _deviceHandle = deviceHandle;
      }

      inline DeviceId getDeviceHandle(void) const
      {
         return _deviceHandle;
      }

      inline void setProtocolList(IN const ProtocolList& protocolList)
      {
         _protocolList = protocolList;
      }

      inline const ProtocolList& getProtocolList(void) const
      {
         return _protocolList;
      }

   private:
      DeviceId _deviceHandle;
      ProtocolList _protocolList;
   };


   class BmCoreIfMessage_DeviceConnectionStatusListUpdate : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_DeviceConnectionStatusListUpdate& first, BmCoreIfMessage_DeviceConnectionStatusListUpdate& second);

      explicit BmCoreIfMessage_DeviceConnectionStatusListUpdate();

      explicit BmCoreIfMessage_DeviceConnectionStatusListUpdate(IN const DeviceConnectionStatusList& deviceConnectionStatusList);

      BmCoreIfMessage_DeviceConnectionStatusListUpdate(IN const BmCoreIfMessage_DeviceConnectionStatusListUpdate& other);

      virtual ~BmCoreIfMessage_DeviceConnectionStatusListUpdate();

      BmCoreIfMessage_DeviceConnectionStatusListUpdate& operator=(BmCoreIfMessage_DeviceConnectionStatusListUpdate other);

      bool operator==(const BmCoreIfMessage_DeviceConnectionStatusListUpdate& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDeviceConnectionStatusList(IN const DeviceConnectionStatusList& deviceConnectionStatusList)
      {
         _deviceConnectionStatusList = deviceConnectionStatusList;
      }

      inline const DeviceConnectionStatusList& getDeviceConnectionStatusList(void) const
      {
         return _deviceConnectionStatusList;
      }

   private:

      DeviceConnectionStatusList _deviceConnectionStatusList;
   };


   class BmCoreIfMessage_SetFavoriteRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_SetFavoriteRequest& first, BmCoreIfMessage_SetFavoriteRequest& second);

      explicit BmCoreIfMessage_SetFavoriteRequest();

      explicit BmCoreIfMessage_SetFavoriteRequest(IN const DeviceId deviceHandle, IN const FavoriteType favoriteType,
            IN const FavoriteIndex favoriteIndex, IN const ActType act,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_SetFavoriteRequest(IN const BmCoreIfMessage_SetFavoriteRequest& other);

      virtual ~BmCoreIfMessage_SetFavoriteRequest();

      BmCoreIfMessage_SetFavoriteRequest& operator=(BmCoreIfMessage_SetFavoriteRequest other);

      bool operator==(const BmCoreIfMessage_SetFavoriteRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDeviceHandle(IN const DeviceId deviceHandle)
      {
         _deviceHandle = deviceHandle;
      }

      inline DeviceId getDeviceHandle(void) const
      {
         return _deviceHandle;
      }

      inline void setFavoriteType(IN const FavoriteType favoriteType)
      {
         _favoriteType = favoriteType;
      }

      inline FavoriteType getFavoriteType(void) const
      {
         return _favoriteType;
      }

      inline void setFavoriteIndex(IN const FavoriteIndex favoriteIndex)
      {
         _favoriteIndex = favoriteIndex;
      }

      inline FavoriteIndex getFavoriteIndex(void) const
      {
         return _favoriteIndex;
      }

   private:
      DeviceId        _deviceHandle;
      FavoriteType    _favoriteType;
      FavoriteIndex   _favoriteIndex;
   };


   class BmCoreIfMessage_ClearFavoriteRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_ClearFavoriteRequest& first, BmCoreIfMessage_ClearFavoriteRequest& second);

      explicit BmCoreIfMessage_ClearFavoriteRequest();

      explicit BmCoreIfMessage_ClearFavoriteRequest(IN const DeviceId deviceHandle, IN const FavoriteType favoriteType,
            IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_ClearFavoriteRequest(IN const BmCoreIfMessage_ClearFavoriteRequest& other);

      virtual ~BmCoreIfMessage_ClearFavoriteRequest();

      BmCoreIfMessage_ClearFavoriteRequest& operator=(BmCoreIfMessage_ClearFavoriteRequest other);

      bool operator==(const BmCoreIfMessage_ClearFavoriteRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDeviceHandle(IN const DeviceId deviceHandle)
      {
         _deviceHandle = deviceHandle;
      }

      inline DeviceId getDeviceHandle(void) const
      {
         return _deviceHandle;
      }

      inline void setFavoriteType(IN const FavoriteType favoriteType)
      {
         _favoriteType = favoriteType;
      }

      inline FavoriteType getFavoriteType(void) const
      {
         return _favoriteType;
      }

   private:
      DeviceId        _deviceHandle;
      FavoriteType    _favoriteType;
   };

   class BmCoreIfMessage_StartServiceSearchRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_StartServiceSearchRequest& first, BmCoreIfMessage_StartServiceSearchRequest& second);

      explicit BmCoreIfMessage_StartServiceSearchRequest();

      explicit BmCoreIfMessage_StartServiceSearchRequest(IN const DeviceId deviceHandle,
            IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_StartServiceSearchRequest(IN const BmCoreIfMessage_StartServiceSearchRequest& other);

      virtual ~BmCoreIfMessage_StartServiceSearchRequest();

      BmCoreIfMessage_StartServiceSearchRequest& operator=(BmCoreIfMessage_StartServiceSearchRequest other);

      bool operator==(const BmCoreIfMessage_StartServiceSearchRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDeviceHandle(IN const DeviceId deviceHandle)
      {
         _deviceHandle = deviceHandle;
      }

      inline DeviceId getDeviceHandle(void) const
      {
         return _deviceHandle;
      }

   private:
      DeviceId        _deviceHandle;

   };


   class BmCoreIfMessage_StopServiceSearchRequest: public BmCoreIfMessage
      {
      public:

         friend void swap(BmCoreIfMessage_StopServiceSearchRequest& first, BmCoreIfMessage_StopServiceSearchRequest& second);

         explicit BmCoreIfMessage_StopServiceSearchRequest();

         explicit BmCoreIfMessage_StopServiceSearchRequest(IN const DeviceId deviceHandle,
               IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

         BmCoreIfMessage_StopServiceSearchRequest(IN const BmCoreIfMessage_StopServiceSearchRequest& other);

         virtual ~BmCoreIfMessage_StopServiceSearchRequest();

         BmCoreIfMessage_StopServiceSearchRequest& operator=(BmCoreIfMessage_StopServiceSearchRequest other);

         bool operator==(const BmCoreIfMessage_StopServiceSearchRequest& rhs) const;

         virtual BmCoreIfMessage* clone(void) const;

         virtual void traceMessage(void) const;

         inline void setDeviceHandle(IN const DeviceId deviceHandle)
         {
            _deviceHandle = deviceHandle;
         }

         inline DeviceId getDeviceHandle(void) const
         {
            return _deviceHandle;
         }


      private:
         DeviceId        _deviceHandle;
      };

   class BmCoreIfMessage_UpdateLinkQualityRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_UpdateLinkQualityRequest& first, BmCoreIfMessage_UpdateLinkQualityRequest& second);

      explicit BmCoreIfMessage_UpdateLinkQualityRequest();

      explicit BmCoreIfMessage_UpdateLinkQualityRequest(IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_UpdateLinkQualityRequest(IN const BmCoreIfMessage_UpdateLinkQualityRequest& other);

      virtual ~BmCoreIfMessage_UpdateLinkQualityRequest();

      BmCoreIfMessage_UpdateLinkQualityRequest& operator=(BmCoreIfMessage_UpdateLinkQualityRequest other);

      bool operator==(const BmCoreIfMessage_UpdateLinkQualityRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

   private:

   };


   class BmCoreIfMessage_BlockStatusUpdate : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BlockStatusUpdate& first, BmCoreIfMessage_BlockStatusUpdate& second);

      explicit BmCoreIfMessage_BlockStatusUpdate();

      explicit BmCoreIfMessage_BlockStatusUpdate(IN const BlockStatus& blockStatus);

      BmCoreIfMessage_BlockStatusUpdate(IN const BmCoreIfMessage_BlockStatusUpdate& other);

      virtual ~BmCoreIfMessage_BlockStatusUpdate();

      BmCoreIfMessage_BlockStatusUpdate& operator=(BmCoreIfMessage_BlockStatusUpdate other);

      bool operator==(const BmCoreIfMessage_BlockStatusUpdate& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBlockStatus(IN const BlockStatus& blockStatus)
      {
         _blockStatus = blockStatus;
      }

      inline const BlockStatus& getBlockStatus(void) const
      {
         return _blockStatus;
      }

   private:

      BlockStatus _blockStatus;
   };


   class BmCoreIfMessage_SetBtLimitationModeRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_SetBtLimitationModeRequest& first, BmCoreIfMessage_SetBtLimitationModeRequest& second);

      explicit BmCoreIfMessage_SetBtLimitationModeRequest();

      explicit BmCoreIfMessage_SetBtLimitationModeRequest(IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_SetBtLimitationModeRequest(IN const BmCoreIfMessage_SetBtLimitationModeRequest& other);

      virtual ~BmCoreIfMessage_SetBtLimitationModeRequest();

      BmCoreIfMessage_SetBtLimitationModeRequest& operator=(BmCoreIfMessage_SetBtLimitationModeRequest other);

      bool operator==(const BmCoreIfMessage_SetBtLimitationModeRequest& rhs) const;

      BmCoreIfMessage_SetBtLimitationModeRequest(IN const BdAddress& bdAddress, IN const BdName& bdName, IN const LimitationMode& limitationMode,
            IN const LimitationAction limitationAction, IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setBdName(IN const BdName& bdName)
      {
         _bdName = bdName;
      }

      inline const BdName& getBdName(void) const
      {
         return _bdName;
      }

      inline void setLimitationMode(IN const LimitationMode& limitationMode)
      {
         _limitationMode = limitationMode;
      }

      inline const LimitationMode& getLimitationMode(void) const
      {
         return _limitationMode;
      }

      inline void setLimitationAction(IN const LimitationAction limitationAction)
      {
         _limitationAction = limitationAction;
      }

      inline LimitationAction getLimitationAction(void) const
      {
         return _limitationAction;
      }

   private:
      BdAddress        _bdAddress;
      BdName           _bdName;
      LimitationMode   _limitationMode;
      LimitationAction _limitationAction;
   };


   class BmCoreIfMessage_ReplaceBtLimitationModeRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_ReplaceBtLimitationModeRequest& first, BmCoreIfMessage_ReplaceBtLimitationModeRequest& second);

      explicit BmCoreIfMessage_ReplaceBtLimitationModeRequest();

      explicit BmCoreIfMessage_ReplaceBtLimitationModeRequest(IN const ActType act,
    		  IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_ReplaceBtLimitationModeRequest(IN const BmCoreIfMessage_ReplaceBtLimitationModeRequest& other);

      virtual ~BmCoreIfMessage_ReplaceBtLimitationModeRequest();

      BmCoreIfMessage_ReplaceBtLimitationModeRequest& operator=(BmCoreIfMessage_ReplaceBtLimitationModeRequest other);

      bool operator==(const BmCoreIfMessage_ReplaceBtLimitationModeRequest& rhs) const;

      BmCoreIfMessage_ReplaceBtLimitationModeRequest(IN const BtLimitationModeInfo& limitationModeToBeReplaced,
      IN const BdAddress& bdAddress, IN const BdName& bdName, IN const LimitationMode& limitationMode,
      IN const LimitationAction limitationAction, IN const ActType act,
      IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setNewBdAddress(IN const BdAddress& bdAddress)
      {
      _newBdAddress = bdAddress;
      }

      inline const BdAddress& getNewBdAddress(void) const
      {
         return _newBdAddress;
      }

      inline void setNewBdName(IN const BdName& bdName)
      {
         _newBdName = bdName;
      }

      inline const BdAddress& getNewBdName(void) const
      {
         return _newBdName;
      }

      inline void setNewLimitationMode(IN const LimitationMode& limitationMode)
      {
    	  _newLimitationMode = limitationMode;
      }

      inline const LimitationMode& getNewLimitationMode(void) const
      {
         return _newLimitationMode;
      }

      inline void setNewLimitationAction(IN const LimitationAction limitationAction)
      {
      _newLimitationAction = limitationAction;
      }

      inline LimitationAction getNewLimitationAction(void) const
      {
         return _newLimitationAction;
      }

      inline void setLimitationModeToBeReplaced(IN const BtLimitationModeInfo& limitationModeToBeReplaced)
      {
      _limitationModeToBeReplaced = limitationModeToBeReplaced;
      }

      inline const BtLimitationModeInfo& getLimitationModeToBeReplaced(void) const
      {
         return _limitationModeToBeReplaced;
      }

   private:
      BtLimitationModeInfo  _limitationModeToBeReplaced;
      BdAddress             _newBdAddress;
      BdName                _newBdName;
      LimitationMode        _newLimitationMode;
      LimitationAction      _newLimitationAction;
   };


   class BmCoreIfMessage_BtLimitationModeUpdate : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtLimitationModeUpdate& first, BmCoreIfMessage_BtLimitationModeUpdate& second);

      explicit BmCoreIfMessage_BtLimitationModeUpdate();

      explicit BmCoreIfMessage_BtLimitationModeUpdate(IN const BtLimitationMode& btLimitationMode);

      BmCoreIfMessage_BtLimitationModeUpdate(IN const BmCoreIfMessage_BtLimitationModeUpdate& other);

      virtual ~BmCoreIfMessage_BtLimitationModeUpdate();

      BmCoreIfMessage_BtLimitationModeUpdate& operator=(BmCoreIfMessage_BtLimitationModeUpdate other);

      bool operator==(const BmCoreIfMessage_BtLimitationModeUpdate& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBtLimitationMode(IN const BtLimitationMode& btLimitationMode)
      {
         _btLimitationMode = btLimitationMode;
      }

      inline const BtLimitationMode& getBtLimitationMode(void) const
      {
         return _btLimitationMode;
      }

   private:

      BtLimitationMode _btLimitationMode;
   };


   class BmCoreIfMessage_NotifyUserDecisionRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_NotifyUserDecisionRequest& first, BmCoreIfMessage_NotifyUserDecisionRequest& second);

      explicit BmCoreIfMessage_NotifyUserDecisionRequest();

      explicit BmCoreIfMessage_NotifyUserDecisionRequest(IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_NotifyUserDecisionRequest(IN const BmCoreIfMessage_NotifyUserDecisionRequest& other);

      virtual ~BmCoreIfMessage_NotifyUserDecisionRequest();

      BmCoreIfMessage_NotifyUserDecisionRequest& operator=(BmCoreIfMessage_NotifyUserDecisionRequest other);

      bool operator==(const BmCoreIfMessage_NotifyUserDecisionRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setUserDecisionInfo(IN const UserDecisionInfo userDecisionInfo)
      {
         _userDecisionInfo = userDecisionInfo;
      }

      inline const UserDecisionInfo& getUserDecisionInfo(void) const
      {
         return _userDecisionInfo;
      }

   private:
      UserDecisionInfo _userDecisionInfo;
   };


   class  BmCoreIfMessage_SetPrimaryHfpDeviceRequest : public BmCoreIfMessage
      {
      public:

         friend void swap( BmCoreIfMessage_SetPrimaryHfpDeviceRequest& first,  BmCoreIfMessage_SetPrimaryHfpDeviceRequest& second);

         explicit  BmCoreIfMessage_SetPrimaryHfpDeviceRequest();

         explicit  BmCoreIfMessage_SetPrimaryHfpDeviceRequest(IN const DeviceId deviceHandle, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

         BmCoreIfMessage_SetPrimaryHfpDeviceRequest(IN const  BmCoreIfMessage_SetPrimaryHfpDeviceRequest& other);

         virtual ~BmCoreIfMessage_SetPrimaryHfpDeviceRequest();

         BmCoreIfMessage_SetPrimaryHfpDeviceRequest& operator=(BmCoreIfMessage_SetPrimaryHfpDeviceRequest other);

         bool operator==(const BmCoreIfMessage_SetPrimaryHfpDeviceRequest& rhs) const;

         virtual BmCoreIfMessage* clone(void) const;

         virtual void traceMessage(void) const;

         inline void setDeviceHandle(IN const DeviceId deviceHandle)
         {
            _deviceHandle = deviceHandle;
         }

         inline const DeviceId& getDeviceHandle(void) const
         {
            return _deviceHandle;
         }

      private:
         DeviceId _deviceHandle;
      };

   class BmCoreIfMessage_SwitchTestModeRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_SwitchTestModeRequest& first, BmCoreIfMessage_SwitchTestModeRequest& second);

      explicit BmCoreIfMessage_SwitchTestModeRequest();

      explicit BmCoreIfMessage_SwitchTestModeRequest(IN const TargetSwitchState targetSwitchState,
            IN const BdAddress& bdAddress, IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_SwitchTestModeRequest(IN const BmCoreIfMessage_SwitchTestModeRequest& other);

      virtual ~BmCoreIfMessage_SwitchTestModeRequest();

      BmCoreIfMessage_SwitchTestModeRequest& operator=(BmCoreIfMessage_SwitchTestModeRequest other);

      bool operator==(const BmCoreIfMessage_SwitchTestModeRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setTargetSwitchState(IN const TargetSwitchState targetSwitchState)
      {
         _targetSwitchState = targetSwitchState;
      }

      inline TargetSwitchState getTargetSwitchState(void) const
      {
         return _targetSwitchState;
      }

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

   private:
      TargetSwitchState _targetSwitchState;
      BdAddress _bdAddress;
   };


   class BmCoreIfMessage_SwitchMultiHFPSupportRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_SwitchMultiHFPSupportRequest& first, BmCoreIfMessage_SwitchMultiHFPSupportRequest& second);

      explicit BmCoreIfMessage_SwitchMultiHFPSupportRequest();

      explicit BmCoreIfMessage_SwitchMultiHFPSupportRequest(IN const TargetSwitchState targetSwitchState,
            IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_SwitchMultiHFPSupportRequest(IN const BmCoreIfMessage_SwitchMultiHFPSupportRequest& other);

      virtual ~BmCoreIfMessage_SwitchMultiHFPSupportRequest();

      BmCoreIfMessage_SwitchMultiHFPSupportRequest& operator=(BmCoreIfMessage_SwitchMultiHFPSupportRequest other);

      bool operator==(const BmCoreIfMessage_SwitchMultiHFPSupportRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setTargetSwitchState(IN const TargetSwitchState targetSwitchState)
      {
         _targetSwitchState = targetSwitchState;
      }

      inline TargetSwitchState getTargetSwitchState(void) const
      {
         return _targetSwitchState;
      }

   private:
      TargetSwitchState _targetSwitchState;
   };


   class BmCoreIfMessage_SetDeviceUsagePreferenceRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_SetDeviceUsagePreferenceRequest& first, BmCoreIfMessage_SetDeviceUsagePreferenceRequest& second);

      explicit BmCoreIfMessage_SetDeviceUsagePreferenceRequest();

      explicit BmCoreIfMessage_SetDeviceUsagePreferenceRequest(IN const DeviceId deviceHandle, IN const UsagePreference usagePreference,
            IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_SetDeviceUsagePreferenceRequest(IN const BmCoreIfMessage_SetDeviceUsagePreferenceRequest& other);

      virtual ~BmCoreIfMessage_SetDeviceUsagePreferenceRequest();

      BmCoreIfMessage_SetDeviceUsagePreferenceRequest& operator=(BmCoreIfMessage_SetDeviceUsagePreferenceRequest other);

      bool operator==(const BmCoreIfMessage_SetDeviceUsagePreferenceRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDeviceId(IN const DeviceId deviceHandle)
      {
         _deviceHandle = deviceHandle;
      }

      inline void setUsagePreference(IN const UsagePreference usagePreference)
      {
         _usagePreference = usagePreference;
      }

      inline UsagePreference getUsagePreference(void) const
      {
         return _usagePreference;
      }

      inline DeviceId getDeviceHandle(void) const
      {
         return _deviceHandle;
      }

   private:
      DeviceId _deviceHandle;
      UsagePreference _usagePreference;
   };


   class BmCoreIfMessage_ResetToDefaultRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_ResetToDefaultRequest& first, BmCoreIfMessage_ResetToDefaultRequest& second);

      explicit BmCoreIfMessage_ResetToDefaultRequest();

      explicit BmCoreIfMessage_ResetToDefaultRequest(IN const bool factorySettingsChanged, IN const ActType act,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_ResetToDefaultRequest(IN const BmCoreIfMessage_ResetToDefaultRequest& other);

      virtual ~BmCoreIfMessage_ResetToDefaultRequest();

      BmCoreIfMessage_ResetToDefaultRequest& operator=(BmCoreIfMessage_ResetToDefaultRequest other);

      bool operator==(const BmCoreIfMessage_ResetToDefaultRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setFactorySettingsChanged(IN const bool factorySettingsChanged)
      {
         _factorySettingsChanged = factorySettingsChanged;
      }

      inline bool getFactorySettingsChanged(void) const
      {
         return _factorySettingsChanged;
      }

   private:
      bool _factorySettingsChanged;
   };

   class BmCoreIfMessage_SetBtProfilesUsageRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_SetBtProfilesUsageRequest& first, BmCoreIfMessage_SetBtProfilesUsageRequest& second);

      explicit BmCoreIfMessage_SetBtProfilesUsageRequest();

      explicit BmCoreIfMessage_SetBtProfilesUsageRequest(IN const ActType act, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreIfMessage_SetBtProfilesUsageRequest(IN const BmCoreIfMessage_SetBtProfilesUsageRequest& other);

      virtual ~BmCoreIfMessage_SetBtProfilesUsageRequest();

      BmCoreIfMessage_SetBtProfilesUsageRequest& operator=(BmCoreIfMessage_SetBtProfilesUsageRequest other);

      bool operator==(const BmCoreIfMessage_SetBtProfilesUsageRequest& rhs) const;

      //virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setProfileUsageInfoList(IN const ProfileUsageList& profileUsageInfoList)
      {
        _BTProfileUsageInfoListReq = profileUsageInfoList;
      }

      inline const ProfileUsageList& getProfileUsageInfoList(void) const
      {
         return _BTProfileUsageInfoListReq;
      }

   private:
      ProfileUsageList _BTProfileUsageInfoListReq;
   };

   // *****************************************************************************************
   // ******************** Messages corresponding to BT Stack IF callbacks ********************
   // *****************************************************************************************

   class BmCoreIfMessage_BtsFbConnectionInitialized : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsFbConnectionInitialized& first, BmCoreIfMessage_BtsFbConnectionInitialized& second);

      explicit BmCoreIfMessage_BtsFbConnectionInitialized();

      explicit BmCoreIfMessage_BtsFbConnectionInitialized(IN const BTSRequestResult requestResult, IN const ActType act);

      BmCoreIfMessage_BtsFbConnectionInitialized(IN const BmCoreIfMessage_BtsFbConnectionInitialized& other);

      virtual ~BmCoreIfMessage_BtsFbConnectionInitialized();

      BmCoreIfMessage_BtsFbConnectionInitialized& operator=(BmCoreIfMessage_BtsFbConnectionInitialized other);

      bool operator==(const BmCoreIfMessage_BtsFbConnectionInitialized& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setRequestResult(IN const BTSRequestResult requestResult)
      {
         _requestResult = requestResult;
      }

      inline BTSRequestResult getRequestResult(void) const
      {
         return _requestResult;
      }

   private:
      BTSRequestResult _requestResult;
   };


   class BmCoreIfMessage_BtsLocalVersionInfo : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsLocalVersionInfo& first, BmCoreIfMessage_BtsLocalVersionInfo& second);

      explicit BmCoreIfMessage_BtsLocalVersionInfo();

      explicit BmCoreIfMessage_BtsLocalVersionInfo(IN const BTSLocalVersionInfo& versionInfo, IN const ActType act);

      BmCoreIfMessage_BtsLocalVersionInfo(IN const BmCoreIfMessage_BtsLocalVersionInfo& other);

      virtual ~BmCoreIfMessage_BtsLocalVersionInfo();

      BmCoreIfMessage_BtsLocalVersionInfo& operator=(BmCoreIfMessage_BtsLocalVersionInfo other);

      bool operator==(const BmCoreIfMessage_BtsLocalVersionInfo& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setVersionInfo(IN const BTSLocalVersionInfo& versionInfo)
      {
         _btsVersionInfo = versionInfo;
      }

      inline const BTSLocalVersionInfo getVersionInfo(void) const
      {
         return _btsVersionInfo;
      }

   private:
      BTSLocalVersionInfo _btsVersionInfo;
   };


   class BmCoreIfMessage_BtsSwitchBluetoothOnOffResult : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsSwitchBluetoothOnOffResult& first, BmCoreIfMessage_BtsSwitchBluetoothOnOffResult& second);

      explicit BmCoreIfMessage_BtsSwitchBluetoothOnOffResult();

      explicit BmCoreIfMessage_BtsSwitchBluetoothOnOffResult(IN const BTSRequestResult requestResult, IN const ActType act);

      BmCoreIfMessage_BtsSwitchBluetoothOnOffResult(IN const BmCoreIfMessage_BtsSwitchBluetoothOnOffResult& other);

      virtual ~BmCoreIfMessage_BtsSwitchBluetoothOnOffResult();

      BmCoreIfMessage_BtsSwitchBluetoothOnOffResult& operator=(BmCoreIfMessage_BtsSwitchBluetoothOnOffResult other);

      bool operator==(const BmCoreIfMessage_BtsSwitchBluetoothOnOffResult& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setRequestResult(IN const BTSRequestResult requestResult)
      {
         _requestResult = requestResult;
      }

      inline BTSRequestResult getRequestResult(void) const
      {
         return _requestResult;
      }

   private:
      BTSRequestResult _requestResult;
   };


   class BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus& first, BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus& second);

      explicit BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus();

      explicit BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus(IN const BTSBluetoothMode bluetoothMode,
            IN const BTSBluetoothOffReason bluetoothOffReason, IN const BTSAdapterMode adapterMode,
            IN const BTSBDAddress& localDeviceAddress, IN const ActType act);

      BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus(IN const BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus& other);

      virtual ~BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus();

      BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus& operator=(BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus other);

      bool operator==(const BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBluetoothMode(IN const BTSBluetoothMode bluetoothMode)
      {
         _bluetoothMode = bluetoothMode;
      }

      inline BTSBluetoothMode getBluetoothMode(void) const
      {
         return _bluetoothMode;
      }

      inline void setBluetoothOffReason(IN const BTSBluetoothOffReason bluetoothOffReason)
      {
         _bluetoothOffReason = bluetoothOffReason;
      }

      inline BTSBluetoothOffReason getBluetoothOffReason(void) const
      {
         return _bluetoothOffReason;
      }

      inline void setAdapterMode(IN const BTSAdapterMode adapterMode)
      {
         _adapterMode = adapterMode;
      }

      inline BTSAdapterMode getAdapterMode(void) const
      {
         return _adapterMode;
      }

      inline void setLocalDeviceAddress(IN const BTSBDAddress& localDeviceAddress)
      {
         _localDeviceAddress = localDeviceAddress;
      }

      inline const BTSBDAddress& getLocalDeviceAddress(void) const
      {
         return _localDeviceAddress;
      }

   private:
      BTSBluetoothMode      _bluetoothMode;
      BTSBluetoothOffReason _bluetoothOffReason;
      BTSAdapterMode        _adapterMode;
      BTSBDAddress          _localDeviceAddress;
   };


   class BmCoreIfMessage_BtsBluetoothHardwareOnOffResult : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsBluetoothHardwareOnOffResult& first, BmCoreIfMessage_BtsBluetoothHardwareOnOffResult& second);

      explicit BmCoreIfMessage_BtsBluetoothHardwareOnOffResult();

      explicit BmCoreIfMessage_BtsBluetoothHardwareOnOffResult(IN const BTSRequestResult requestResult, IN const ActType act);

      BmCoreIfMessage_BtsBluetoothHardwareOnOffResult(IN const BmCoreIfMessage_BtsBluetoothHardwareOnOffResult& other);

      virtual ~BmCoreIfMessage_BtsBluetoothHardwareOnOffResult();

      BmCoreIfMessage_BtsBluetoothHardwareOnOffResult& operator=(BmCoreIfMessage_BtsBluetoothHardwareOnOffResult other);

      bool operator==(const BmCoreIfMessage_BtsBluetoothHardwareOnOffResult& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setRequestResult(IN const BTSRequestResult btsResult)
      {
         _btsResult = btsResult;
      }

      inline BTSRequestResult getRequestResult(void) const
      {
         return _btsResult;
      }

   private:
      BTSRequestResult _btsResult;
   };


   class BmCoreIfMessage_BtsSetLocalBtNameResult : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsSetLocalBtNameResult& first, BmCoreIfMessage_BtsSetLocalBtNameResult& second);

      explicit BmCoreIfMessage_BtsSetLocalBtNameResult();

      explicit BmCoreIfMessage_BtsSetLocalBtNameResult(IN const BTSRequestResult requestResult, IN const ActType act);

      BmCoreIfMessage_BtsSetLocalBtNameResult(IN const BmCoreIfMessage_BtsSetLocalBtNameResult& other);

      virtual ~BmCoreIfMessage_BtsSetLocalBtNameResult();

      BmCoreIfMessage_BtsSetLocalBtNameResult& operator=(BmCoreIfMessage_BtsSetLocalBtNameResult other);

      bool operator==(const BmCoreIfMessage_BtsSetLocalBtNameResult& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setRequestResult(IN const BTSRequestResult requestResult)
      {
         _requestResult = requestResult;
      }

      inline BTSRequestResult getRequestResult(void) const
      {
         return _requestResult;
      }

   private:
      BTSRequestResult _requestResult;
   };


   class BmCoreIfMessage_BtsCurrentLocalBtName : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsCurrentLocalBtName& first, BmCoreIfMessage_BtsCurrentLocalBtName& second);

      explicit BmCoreIfMessage_BtsCurrentLocalBtName();

      explicit BmCoreIfMessage_BtsCurrentLocalBtName(IN const BTSDeviceName& adapterName);

      BmCoreIfMessage_BtsCurrentLocalBtName(IN const BmCoreIfMessage_BtsCurrentLocalBtName& other);

      virtual ~BmCoreIfMessage_BtsCurrentLocalBtName();

      BmCoreIfMessage_BtsCurrentLocalBtName& operator=(BmCoreIfMessage_BtsCurrentLocalBtName other);

      bool operator==(const BmCoreIfMessage_BtsCurrentLocalBtName& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setAdapterName(IN const BTSDeviceName& adapterName)
      {
         _adapterName = adapterName;
      }

      inline const BTSDeviceName& getAdapterName(void) const
      {
         return _adapterName;
      }

   private:
      BTSDeviceName _adapterName;
   };


   class BmCoreIfMessage_BtsSetLocalAdapterModesResult : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsSetLocalAdapterModesResult& first, BmCoreIfMessage_BtsSetLocalAdapterModesResult& second);

      explicit BmCoreIfMessage_BtsSetLocalAdapterModesResult();

      explicit BmCoreIfMessage_BtsSetLocalAdapterModesResult(IN const BTSRequestResult requestResult, IN const ActType act);

      BmCoreIfMessage_BtsSetLocalAdapterModesResult(IN const BmCoreIfMessage_BtsSetLocalAdapterModesResult& other);

      virtual ~BmCoreIfMessage_BtsSetLocalAdapterModesResult();

      BmCoreIfMessage_BtsSetLocalAdapterModesResult& operator=(BmCoreIfMessage_BtsSetLocalAdapterModesResult other);

      bool operator==(const BmCoreIfMessage_BtsSetLocalAdapterModesResult& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setRequestResult(IN const BTSRequestResult requestResult)
      {
         _requestResult = requestResult;
      }

      inline BTSRequestResult getRequestResult(void) const
      {
         return _requestResult;
      }

   private:
      BTSRequestResult _requestResult;
   };


   class BmCoreIfMessage_BtsCurrentDiscoverableMode : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsCurrentDiscoverableMode& first, BmCoreIfMessage_BtsCurrentDiscoverableMode& second);

      explicit BmCoreIfMessage_BtsCurrentDiscoverableMode();

      explicit BmCoreIfMessage_BtsCurrentDiscoverableMode(IN const BTSLocalMode discoverableMode,
            IN const BTSLocalModeOffReason offReason, IN const ActType act);

      BmCoreIfMessage_BtsCurrentDiscoverableMode(IN const BmCoreIfMessage_BtsCurrentDiscoverableMode& other);

      virtual ~BmCoreIfMessage_BtsCurrentDiscoverableMode();

      BmCoreIfMessage_BtsCurrentDiscoverableMode& operator=(BmCoreIfMessage_BtsCurrentDiscoverableMode other);

      bool operator==(const BmCoreIfMessage_BtsCurrentDiscoverableMode& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDiscoverableMode(IN const BTSLocalMode discoverableMode)
      {
         _discoverableMode = discoverableMode;
      }

      inline BTSLocalMode getDiscoverableMode(void) const
      {
         return _discoverableMode;
      }

      inline void setOffReason(IN const BTSLocalModeOffReason offReason)
      {
         _offReason = offReason;
      }

      inline BTSLocalModeOffReason getOffReason(void) const
      {
         return _offReason;
      }

   private:
      BTSLocalMode          _discoverableMode;
      BTSLocalModeOffReason _offReason;
   };

   class BmCoreIfMessage_BtsCurrentConnectableMode : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsCurrentConnectableMode& first, BmCoreIfMessage_BtsCurrentConnectableMode& second);

      explicit BmCoreIfMessage_BtsCurrentConnectableMode();

      explicit BmCoreIfMessage_BtsCurrentConnectableMode(IN const BTSLocalMode connectableMode,
            IN const BTSLocalModeOffReason offReason, IN const ActType act);

      BmCoreIfMessage_BtsCurrentConnectableMode(IN const BmCoreIfMessage_BtsCurrentConnectableMode& other);

      virtual ~BmCoreIfMessage_BtsCurrentConnectableMode();

      BmCoreIfMessage_BtsCurrentConnectableMode& operator=(BmCoreIfMessage_BtsCurrentConnectableMode other);

      bool operator==(const BmCoreIfMessage_BtsCurrentConnectableMode& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setConnectableMode(IN const BTSLocalMode connectableMode)
      {
         _connectableMode = connectableMode;
      }

      inline BTSLocalMode getConnectableMode(void) const
      {
         return _connectableMode;
      }

      inline void setOffReason(IN const BTSLocalModeOffReason offReason)
      {
         _offReason = offReason;
      }

      inline BTSLocalModeOffReason getOffReason(void) const
      {
         return _offReason;
      }

   private:
      BTSLocalMode          _connectableMode;
      BTSLocalModeOffReason _offReason;
   };

   class BmCoreIfMessage_BtsStartDiscoveryResult : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsStartDiscoveryResult& first, BmCoreIfMessage_BtsStartDiscoveryResult& second);

      explicit BmCoreIfMessage_BtsStartDiscoveryResult();

      explicit BmCoreIfMessage_BtsStartDiscoveryResult(IN const BTSRequestResult requestResult, IN const ActType act);

      BmCoreIfMessage_BtsStartDiscoveryResult(IN const BmCoreIfMessage_BtsStartDiscoveryResult& other);

      virtual ~BmCoreIfMessage_BtsStartDiscoveryResult();

      BmCoreIfMessage_BtsStartDiscoveryResult& operator=(BmCoreIfMessage_BtsStartDiscoveryResult other);

      bool operator==(const BmCoreIfMessage_BtsStartDiscoveryResult& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setRequestResult(IN const BTSRequestResult requestResult)
      {
         _requestResult = requestResult;
      }

      inline BTSRequestResult getRequestResult(void) const
      {
         return _requestResult;
      }

   private:
      BTSRequestResult _requestResult;
   };


   class BmCoreIfMessage_BtsStopDiscoveryResult : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsStopDiscoveryResult& first, BmCoreIfMessage_BtsStopDiscoveryResult& second);

      explicit BmCoreIfMessage_BtsStopDiscoveryResult();

      explicit BmCoreIfMessage_BtsStopDiscoveryResult(IN const BTSRequestResult requestResult, IN const ActType act);

      BmCoreIfMessage_BtsStopDiscoveryResult(IN const BmCoreIfMessage_BtsStopDiscoveryResult& other);

      virtual ~BmCoreIfMessage_BtsStopDiscoveryResult();

      BmCoreIfMessage_BtsStopDiscoveryResult& operator=(BmCoreIfMessage_BtsStopDiscoveryResult other);

      bool operator==(const BmCoreIfMessage_BtsStopDiscoveryResult& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setRequestResult(IN const BTSRequestResult requestResult)
      {
         _requestResult = requestResult;
      }

      inline BTSRequestResult getRequestResult(void) const
      {
         return _requestResult;
      }

   private:
      BTSRequestResult _requestResult;
   };


   class BmCoreIfMessage_BtsDiscoveringStatus : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsDiscoveringStatus& first, BmCoreIfMessage_BtsDiscoveringStatus& second);

      explicit BmCoreIfMessage_BtsDiscoveringStatus();

      explicit BmCoreIfMessage_BtsDiscoveringStatus(IN const BTSDiscoveringStatus discoveringStatus, IN const ActType act);

      BmCoreIfMessage_BtsDiscoveringStatus(IN const BmCoreIfMessage_BtsDiscoveringStatus& other);

      virtual ~BmCoreIfMessage_BtsDiscoveringStatus();

      BmCoreIfMessage_BtsDiscoveringStatus& operator=(BmCoreIfMessage_BtsDiscoveringStatus other);

      bool operator==(const BmCoreIfMessage_BtsDiscoveringStatus& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDiscoveringStatus(IN const BTSDiscoveringStatus discoveringStatus)
      {
         _discoveringStatus = discoveringStatus;
      }

      inline BTSDiscoveringStatus getDiscoveringStatus(void) const
      {
         return _discoveringStatus;
      }

   private:
      BTSDiscoveringStatus _discoveringStatus;
   };


   class BmCoreIfMessage_BtsDiscoveredDeviceFound : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsDiscoveredDeviceFound& first, BmCoreIfMessage_BtsDiscoveredDeviceFound& second);

      explicit BmCoreIfMessage_BtsDiscoveredDeviceFound();

      explicit BmCoreIfMessage_BtsDiscoveredDeviceFound(IN const BTSDiscoveredDeviceInfo& discoveredDevice, IN const ActType act);

      BmCoreIfMessage_BtsDiscoveredDeviceFound(IN const BmCoreIfMessage_BtsDiscoveredDeviceFound& other);

      virtual ~BmCoreIfMessage_BtsDiscoveredDeviceFound();

      BmCoreIfMessage_BtsDiscoveredDeviceFound& operator=(BmCoreIfMessage_BtsDiscoveredDeviceFound other);

      bool operator==(const BmCoreIfMessage_BtsDiscoveredDeviceFound& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDiscoveredDevice(IN const BTSDiscoveredDeviceInfo& discoveredDevice)
      {
         _discoveredDevice = discoveredDevice;
      }

      inline const BTSDiscoveredDeviceInfo& getDiscoveredDevice(void) const
      {
         return _discoveredDevice;
      }

   private:
      BTSDiscoveredDeviceInfo _discoveredDevice;
   };


   class BmCoreIfMessage_BtsStartPairingResult : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsStartPairingResult& first, BmCoreIfMessage_BtsStartPairingResult& second);

      explicit BmCoreIfMessage_BtsStartPairingResult();

      explicit BmCoreIfMessage_BtsStartPairingResult(IN const BTSBDAddress& btsBdAddress,
            IN const BTSRequestResult btsResult, IN const ActType act);

      BmCoreIfMessage_BtsStartPairingResult(IN const BmCoreIfMessage_BtsStartPairingResult& other);

      virtual ~BmCoreIfMessage_BtsStartPairingResult();

      BmCoreIfMessage_BtsStartPairingResult& operator=(BmCoreIfMessage_BtsStartPairingResult other);

      bool operator==(const BmCoreIfMessage_BtsStartPairingResult& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BTSBDAddress& btsBdAddress)
      {
         _btsBdAddress = btsBdAddress;
      }

      inline const BTSBDAddress& getBdAddress(void) const
      {
         return _btsBdAddress;
      }

      inline void setRequestResult(IN const BTSRequestResult btsResult)
      {
         _btsResult = btsResult;
      }

      inline BTSRequestResult getRequestResult(void) const
      {
         return _btsResult;
      }

   private:
      BTSBDAddress       _btsBdAddress;
      BTSRequestResult   _btsResult;
   };


   class BmCoreIfMessage_BtsPinCodeRequested : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsPinCodeRequested& first, BmCoreIfMessage_BtsPinCodeRequested& second);

      explicit BmCoreIfMessage_BtsPinCodeRequested();

      explicit BmCoreIfMessage_BtsPinCodeRequested(IN const BTSBDAddress& btsBdAddress,
            IN const BTSDeviceName& btsBdName, IN const BTSPairConnectOriginator btsPairingOriginator,
            IN const ActType act);

      BmCoreIfMessage_BtsPinCodeRequested(IN const BmCoreIfMessage_BtsPinCodeRequested& other);

      virtual ~BmCoreIfMessage_BtsPinCodeRequested();

      BmCoreIfMessage_BtsPinCodeRequested& operator=(BmCoreIfMessage_BtsPinCodeRequested other);

      bool operator==(const BmCoreIfMessage_BtsPinCodeRequested& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BTSBDAddress& btsBdAddress)
      {
         _btsBdAddress = btsBdAddress;
      }

      inline const BTSBDAddress& getBdAddress(void) const
      {
         return _btsBdAddress;
      }

      inline void setBdName(IN const BTSDeviceName& btsBdName)
      {
         _btsBdName = btsBdName;
      }

      inline const BTSDeviceName& getBdName(void) const
      {
         return _btsBdName;
      }

      inline void setPairingOriginator(IN const BTSPairConnectOriginator btsPairingOriginator)
      {
         _btsPairingOriginator = btsPairingOriginator;
      }

      inline BTSPairConnectOriginator getPairingOriginator(void) const
      {
         return _btsPairingOriginator;
      }

   private:
      BTSBDAddress             _btsBdAddress;
      BTSDeviceName            _btsBdName;
      BTSPairConnectOriginator _btsPairingOriginator;
   };


   class BmCoreIfMessage_BtsSecureSimplePairingRequested : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsSecureSimplePairingRequested& first, BmCoreIfMessage_BtsSecureSimplePairingRequested& second);

      explicit BmCoreIfMessage_BtsSecureSimplePairingRequested();

      explicit BmCoreIfMessage_BtsSecureSimplePairingRequested(IN const BTSBDAddress& btsBdAddress,
            IN const BTSDeviceName& btsBdName, IN const BTSSspMode btsSspMode, IN const BTSNumericValue& btsNumericValue,
            IN const BTSPairConnectOriginator btsPairingOriginator, IN const ActType act);

      BmCoreIfMessage_BtsSecureSimplePairingRequested(IN const BmCoreIfMessage_BtsSecureSimplePairingRequested& other);

      virtual ~BmCoreIfMessage_BtsSecureSimplePairingRequested();

      BmCoreIfMessage_BtsSecureSimplePairingRequested& operator=(BmCoreIfMessage_BtsSecureSimplePairingRequested other);

      bool operator==(const BmCoreIfMessage_BtsSecureSimplePairingRequested& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BTSBDAddress& btsBdAddress)
      {
         _btsBdAddress = btsBdAddress;
      }

      inline const BTSBDAddress& getBdAddress(void) const
      {
         return _btsBdAddress;
      }

      inline void setBdName(IN const BTSDeviceName& btsBdName)
      {
         _btsBdName = btsBdName;
      }

      inline const BTSDeviceName& getBdName(void) const
      {
         return _btsBdName;
      }

      inline void setSspMode(IN const BTSSspMode btsSspMode)
      {
         _btsSspMode = btsSspMode;
      }

      inline BTSSspMode getSspMode(void) const
      {
         return _btsSspMode;
      }

      inline void setNumericValue(IN const BTSNumericValue& btsNumericValue)
      {
         _btsNumericValue = btsNumericValue;
      }

      inline const BTSNumericValue& getNumericValue(void) const
      {
         return _btsNumericValue;
      }

      inline void setPairingOriginator(IN const BTSPairConnectOriginator btsPairingOriginator)
      {
         _btsPairingOriginator = btsPairingOriginator;
      }

      inline BTSPairConnectOriginator getPairingOriginator(void) const
      {
         return _btsPairingOriginator;
      }

   private:
      BTSBDAddress             _btsBdAddress;
      BTSDeviceName            _btsBdName;
      BTSSspMode               _btsSspMode;
      BTSNumericValue          _btsNumericValue;
      BTSPairConnectOriginator _btsPairingOriginator;
   };


   class BmCoreIfMessage_BtsPairingFinished : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsPairingFinished& first, BmCoreIfMessage_BtsPairingFinished& second);

      explicit BmCoreIfMessage_BtsPairingFinished();

      explicit BmCoreIfMessage_BtsPairingFinished(IN const BTSBDAddress& btsBdAddress, IN const BTSRequestResult btsResult,
            IN const BTSLinkKeyType btsLinkKeyType, IN const BTSLinkKey& btsLinkKey, IN const BTSDLinkKey& btsDLinkKey,
            IN const BTSMajorServiceClass& btsMajorServiceClass, IN const BTSMajorDeviceClass btsMajorDeviceClass,
            IN const BTSMinorDeviceClass btsMinorDeviceClass, IN const BTSDeviceName& btsBdName,
            IN const ActType act);

//      explicit BmCoreIfMessage_BtsPairingFinished(IN const DeviceBaseInfo& deviceBaseInfo, IN const ::cc::ActType act);

      BmCoreIfMessage_BtsPairingFinished(IN const BmCoreIfMessage_BtsPairingFinished& other);

      virtual ~BmCoreIfMessage_BtsPairingFinished();

      BmCoreIfMessage_BtsPairingFinished& operator=(BmCoreIfMessage_BtsPairingFinished other);

      bool operator==(const BmCoreIfMessage_BtsPairingFinished& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBtsBdAddress(IN const BTSBDAddress& btsBdAddress)
      {
         _btsBdAddress = btsBdAddress;
      }

      inline const BTSBDAddress& getBtsBdAddress(void) const
      {
         return _btsBdAddress;
      }

      inline void setBtsResult(IN const BTSRequestResult& btsResult)
      {
         _btsResult = btsResult;
      }

      inline BTSRequestResult getBtsResult(void) const
      {
         return _btsResult;
      }

      inline void setBtsLinkKeyType(IN const BTSLinkKeyType btsLinkKeyType)
      {
         _btsLinkKeyType = btsLinkKeyType;
      }

      inline BTSLinkKeyType getBtsLinkKeyType(void) const
      {
         return _btsLinkKeyType;
      }

      inline void setBtsLinkKey(IN const BTSLinkKey& btsLinkKey)
      {
         _btsLinkKey = btsLinkKey;
      }

      inline const BTSLinkKey& getBtsLinkKey(void) const
      {
         return _btsLinkKey;
      }

      inline void setBtsDLinkKey(IN const BTSDLinkKey& btsDLinkKey)
      {
         _btsDLinkKey = btsDLinkKey;
      }

      inline const BTSDLinkKey& getBtsDLinkKey(void) const
      {
         return _btsDLinkKey;
      }

      inline void setBtsMajorServiceClass(IN const BTSMajorServiceClass& btsMajorServiceClass)
      {
         _btsMajorServiceClass = btsMajorServiceClass;
      }

      inline const BTSMajorServiceClass& getBtsMajorServiceClass(void) const
      {
         return _btsMajorServiceClass;
      }

      inline void setBtsMajorDeviceClass(IN const BTSMajorDeviceClass btsMajorDeviceClass)
      {
         _btsMajorDeviceClass = btsMajorDeviceClass;
      }

      inline BTSMajorDeviceClass getBtsMajorDeviceClass(void) const
      {
         return _btsMajorDeviceClass;
      }

      inline void setBtsMinorDeviceClass(IN const BTSMinorDeviceClass btsMinorDeviceClass)
      {
         _btsMinorDeviceClass = btsMinorDeviceClass;
      }

      inline BTSMinorDeviceClass getBtsMinorDeviceClass(void) const
      {
         return _btsMinorDeviceClass;
      }

      inline void setBtsDeviceName(IN const BTSDeviceName& btsBdName)
      {
         _btsBdName = btsBdName;
      }

      inline const BTSDeviceName& getBtsDeviceName(void) const
      {
         return _btsBdName;
      }

   private:

      BTSBDAddress         _btsBdAddress;
      BTSRequestResult     _btsResult;
      BTSLinkKeyType       _btsLinkKeyType;
      BTSLinkKey           _btsLinkKey;
      BTSDLinkKey          _btsDLinkKey;
      BTSMajorServiceClass _btsMajorServiceClass;
      BTSMajorDeviceClass  _btsMajorDeviceClass;
      BTSMinorDeviceClass  _btsMinorDeviceClass;
      BTSDeviceName        _btsBdName;
/*
      DeviceBaseInfo _deviceBaseInfo;
*/
   };


   class BmCoreIfMessage_BtsSupportedServices : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsSupportedServices& first, BmCoreIfMessage_BtsSupportedServices& second);

      explicit BmCoreIfMessage_BtsSupportedServices();

      explicit BmCoreIfMessage_BtsSupportedServices(IN const BTSBDAddress& btsBdAddress,
            IN const BTSRequestResult btsResult, IN const BTSSupportedServices& btsSupportedServices,
            IN const BTSServiceInfoList& btsServiceInfoList, IN const ActType act);

      BmCoreIfMessage_BtsSupportedServices(IN const BmCoreIfMessage_BtsSupportedServices& other);

      virtual ~BmCoreIfMessage_BtsSupportedServices();

      BmCoreIfMessage_BtsSupportedServices& operator=(BmCoreIfMessage_BtsSupportedServices other);

      bool operator==(const BmCoreIfMessage_BtsSupportedServices& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBtsBdAddress(IN const BTSBDAddress& btsBdAddress)
      {
         _btsBdAddress = btsBdAddress;
      }

      inline const BTSBDAddress& getBtsBdAddress(void) const
      {
         return _btsBdAddress;
      }

      inline void setBtsResult(IN const BTSRequestResult btsResult)
      {
         _btsResult = btsResult;
      }

      inline BTSRequestResult getBtsResult(void) const
      {
         return _btsResult;
      }

      inline void setBtsSupportedServices(IN const BTSSupportedServices& btsSupportedServices)
      {
         _btsSupportedServices = btsSupportedServices;
      }

      inline const BTSSupportedServices& getBtsSupportedServices(void) const
      {
         return _btsSupportedServices;
      }

      inline void setBtsServiceInfoList(IN const BTSServiceInfoList& btsServiceInfoList)
      {
         _btsServiceInfoList = btsServiceInfoList;
      }

      inline const BTSServiceInfoList& getBtsServiceInfoList(void) const
      {
         return _btsServiceInfoList;
      }

   private:
      BTSBDAddress _btsBdAddress;
      BTSRequestResult _btsResult;
      BTSSupportedServices _btsSupportedServices;
      BTSServiceInfoList _btsServiceInfoList;
   };


   class BmCoreIfMessage_BtsSppCapabilities : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsSppCapabilities& first, BmCoreIfMessage_BtsSppCapabilities& second);

      explicit BmCoreIfMessage_BtsSppCapabilities();

      explicit BmCoreIfMessage_BtsSppCapabilities(IN const BTSBDAddress& btsBdAddress,
            IN const BTSRequestResult btsResult, IN const BTSSppCapabilityList& btsSppCapabilities,
            IN const ActType act);

      BmCoreIfMessage_BtsSppCapabilities(IN const BmCoreIfMessage_BtsSppCapabilities& other);

      virtual ~BmCoreIfMessage_BtsSppCapabilities();

      BmCoreIfMessage_BtsSppCapabilities& operator=(BmCoreIfMessage_BtsSppCapabilities other);

      bool operator==(const BmCoreIfMessage_BtsSppCapabilities& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBtsBdAddress(IN const BTSBDAddress& btsBdAddress)
      {
         _btsBdAddress = btsBdAddress;
      }

      inline const BTSBDAddress& getBtsBdAddress(void) const
      {
         return _btsBdAddress;
      }

      inline void setBtsResult(IN const BTSRequestResult btsResult)
      {
         _btsResult = btsResult;
      }

      inline BTSRequestResult getBtsResult(void) const
      {
         return _btsResult;
      }

      inline void setBtsSppCapabilities(IN const BTSSppCapabilityList& btsSppCapabilities)
      {
         _btsSppCapabilities = btsSppCapabilities;
      }

      inline const BTSSppCapabilityList& getBtsSppCapabilities(void) const
      {
         return _btsSppCapabilities;
      }

   private:
      BTSBDAddress _btsBdAddress;
      BTSRequestResult _btsResult;
      BTSSppCapabilityList _btsSppCapabilities;
   };


   class BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords& first, BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords& second);

      explicit BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords();

      explicit BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords(IN const BTSBDAddress& btsBdAddress,
            IN const BTSRequestResult btsResult, IN const BTSDeviceIdServiceRecordList& btsDeviceIdServiceRecords,
            IN const ActType act);

      BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords(IN const BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords& other);

      virtual ~BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords();

      BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords& operator=(BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords other);

      bool operator==(const BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BTSBDAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BTSBDAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setResult(IN const BTSRequestResult result)
      {
         _result = result;
      }

      inline BTSRequestResult getResult(void) const
      {
         return _result;
      }

      inline void setDeviceIdServiceRecordList(IN const BTSDeviceIdServiceRecordList& deviceIdServiceRecordList)
      {
         _deviceIdServiceRecordList = deviceIdServiceRecordList;
      }

      inline const BTSDeviceIdServiceRecordList& getDeviceIdServiceRecordList(void) const
      {
         return _deviceIdServiceRecordList;
      }

   private:
      BTSBDAddress _bdAddress;
      BTSRequestResult _result;
      BTSDeviceIdServiceRecordList _deviceIdServiceRecordList;
   };


   class BmCoreIfMessage_BtsDeviceCapabilities : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsDeviceCapabilities& first, BmCoreIfMessage_BtsDeviceCapabilities& second);

      explicit BmCoreIfMessage_BtsDeviceCapabilities();

      explicit BmCoreIfMessage_BtsDeviceCapabilities(IN const BTSBDAddress& bdAddress,
            IN const BTSDeviceCapabilities& deviceCapabilities, IN const ActType act);

      BmCoreIfMessage_BtsDeviceCapabilities(IN const BmCoreIfMessage_BtsDeviceCapabilities& other);

      virtual ~BmCoreIfMessage_BtsDeviceCapabilities();

      BmCoreIfMessage_BtsDeviceCapabilities& operator=(BmCoreIfMessage_BtsDeviceCapabilities other);

      bool operator==(const BmCoreIfMessage_BtsDeviceCapabilities& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BTSBDAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BTSBDAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setDeviceCapabilities(IN const BTSDeviceCapabilities& deviceCapabilities)
      {
         _deviceCapabilities = deviceCapabilities;
      }

      inline const BTSDeviceCapabilities& getDeviceCapabilities(void) const
      {
         return _deviceCapabilities;
      }

   private:
      BTSBDAddress _bdAddress;
      BTSDeviceCapabilities _deviceCapabilities;
   };


   class BmCoreIfMessage_BtsRemoteServiceSearchResult : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsRemoteServiceSearchResult& first, BmCoreIfMessage_BtsRemoteServiceSearchResult& second);

      explicit BmCoreIfMessage_BtsRemoteServiceSearchResult();

      explicit BmCoreIfMessage_BtsRemoteServiceSearchResult(IN const BTSBDAddress& btsBdAddress,
            IN const BTSRequestResult btsSupportedServicesResult, IN const BTSRequestResult btsSppCapabilitiesResult,
            IN const BTSRequestResult btsDeviceIdServiceRecordsResult, IN const ActType act);

      BmCoreIfMessage_BtsRemoteServiceSearchResult(IN const BmCoreIfMessage_BtsRemoteServiceSearchResult& other);

      virtual ~BmCoreIfMessage_BtsRemoteServiceSearchResult();

      BmCoreIfMessage_BtsRemoteServiceSearchResult& operator=(BmCoreIfMessage_BtsRemoteServiceSearchResult other);

      bool operator==(const BmCoreIfMessage_BtsRemoteServiceSearchResult& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BTSBDAddress& btsBdAddress)
      {
         _btsBdAddress = btsBdAddress;
      }

      inline const BTSBDAddress& getBdAddress(void) const
      {
         return _btsBdAddress;
      }

      inline void setSupportedServicesResult(IN const BTSRequestResult btsSupportedServicesResult)
      {
         _btsSupportedServicesResult = btsSupportedServicesResult;
      }

      inline BTSRequestResult getSupportedServicesResult(void) const
      {
         return _btsSupportedServicesResult;
      }

      inline void setSppCapabilitiesResult(IN const BTSRequestResult btsSppCapabilitiesResult)
      {
         _btsSppCapabilitiesResult = btsSppCapabilitiesResult;
      }

      inline BTSRequestResult getSppCapabilitiesResult(void) const
      {
         return _btsSppCapabilitiesResult;
      }

      inline void setDeviceIdServiceRecordsResult(IN const BTSRequestResult btsDeviceIdServiceRecordsResult)
      {
         _btsDeviceIdServiceRecordsResult = btsDeviceIdServiceRecordsResult;
      }

      inline BTSRequestResult getDeviceIdServiceRecordsResult(void) const
      {
         return _btsDeviceIdServiceRecordsResult;
      }

   private:
      BTSBDAddress     _btsBdAddress;
      BTSRequestResult _btsSupportedServicesResult;
      BTSRequestResult _btsSppCapabilitiesResult;
      BTSRequestResult _btsDeviceIdServiceRecordsResult;
   };


   class BmCoreIfMessage_BtsRemoteNameResult : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsRemoteNameResult& first, BmCoreIfMessage_BtsRemoteNameResult& second);

      explicit BmCoreIfMessage_BtsRemoteNameResult();

      explicit BmCoreIfMessage_BtsRemoteNameResult(IN const BTSBDAddress& btsBdAddress,
            IN const BTSDeviceName& btsBdName, IN const BTSRequestResult btsResult, IN const ActType act);

      BmCoreIfMessage_BtsRemoteNameResult(IN const BmCoreIfMessage_BtsRemoteNameResult& other);

      virtual ~BmCoreIfMessage_BtsRemoteNameResult();

      BmCoreIfMessage_BtsRemoteNameResult& operator=(BmCoreIfMessage_BtsRemoteNameResult other);

      bool operator==(const BmCoreIfMessage_BtsRemoteNameResult& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BTSBDAddress& btsBdAddress)
      {
         _btsBdAddress = btsBdAddress;
      }

      inline const BTSBDAddress& getBdAddress(void) const
      {
         return _btsBdAddress;
      }

      inline void setBdName(IN const BTSDeviceName& btsBdName)
      {
         _btsBdName = btsBdName;
      }

      inline const BTSDeviceName& getBdName(void) const
      {
         return _btsBdName;
      }

      inline void setRequestResult(IN const BTSRequestResult btsResult)
      {
         _btsResult = btsResult;
      }

      inline BTSRequestResult getRequestResult(void) const
      {
         return _btsResult;
      }

   private:
      BTSBDAddress     _btsBdAddress;
      BTSDeviceName    _btsBdName;
      BTSRequestResult _btsResult;
   };

   class BmCoreIfMessage_BtsRemoteNameStatusUpdate : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsRemoteNameStatusUpdate& first, BmCoreIfMessage_BtsRemoteNameStatusUpdate& second);

      explicit BmCoreIfMessage_BtsRemoteNameStatusUpdate();

      explicit BmCoreIfMessage_BtsRemoteNameStatusUpdate(IN const BTSBDAddress& btsBdAddress,
            IN const BTSDeviceName& btsBdName, IN const ActType act);

      BmCoreIfMessage_BtsRemoteNameStatusUpdate(IN const BmCoreIfMessage_BtsRemoteNameStatusUpdate& other);

      virtual ~BmCoreIfMessage_BtsRemoteNameStatusUpdate();

      BmCoreIfMessage_BtsRemoteNameStatusUpdate& operator=(BmCoreIfMessage_BtsRemoteNameStatusUpdate other);

      bool operator==(const BmCoreIfMessage_BtsRemoteNameStatusUpdate& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BTSBDAddress& btsBdAddress)
      {
         _btsBdAddress = btsBdAddress;
      }

      inline const BTSBDAddress& getBdAddress(void) const
      {
         return _btsBdAddress;
      }

      inline void setBdName(IN const BTSDeviceName& btsBdName)
      {
         _btsBdName = btsBdName;
      }

      inline const BTSDeviceName& getBdName(void) const
      {
         return _btsBdName;
      }

   private:
      BTSBDAddress     _btsBdAddress;
      BTSDeviceName    _btsBdName;
   };


   class BmCoreIfMessage_BtsLinkKeyRequested : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsLinkKeyRequested& first, BmCoreIfMessage_BtsLinkKeyRequested& second);

      explicit BmCoreIfMessage_BtsLinkKeyRequested();

      explicit BmCoreIfMessage_BtsLinkKeyRequested(IN const BTSBDAddress& btsBdAddress, IN const ActType act);

      BmCoreIfMessage_BtsLinkKeyRequested(IN const BmCoreIfMessage_BtsLinkKeyRequested& other);

      virtual ~BmCoreIfMessage_BtsLinkKeyRequested();

      BmCoreIfMessage_BtsLinkKeyRequested& operator=(BmCoreIfMessage_BtsLinkKeyRequested other);

      bool operator==(const BmCoreIfMessage_BtsLinkKeyRequested& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BTSBDAddress& btsBdAddress)
      {
         _btsBdAddress = btsBdAddress;
      }

      inline const BTSBDAddress& getBdAddress(void) const
      {
         return _btsBdAddress;
      }

   private:
      BTSBDAddress _btsBdAddress;
   };


   class BmCoreIfMessage_BtsConnectProtocolResult : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsConnectProtocolResult& first, BmCoreIfMessage_BtsConnectProtocolResult& second);

      explicit BmCoreIfMessage_BtsConnectProtocolResult();

      explicit BmCoreIfMessage_BtsConnectProtocolResult(IN const BTSBDAddress& btsBdAddress,
            IN const BTSRequestResult btsResult, IN const BTSProtocolId btsProtocolId, IN const BTSUuid& btsSppUuid,
            IN const BTSMasInstanceName& btsMasInstance, IN const ActType act);

      BmCoreIfMessage_BtsConnectProtocolResult(IN const BmCoreIfMessage_BtsConnectProtocolResult& other);

      virtual ~BmCoreIfMessage_BtsConnectProtocolResult();

      BmCoreIfMessage_BtsConnectProtocolResult& operator=(BmCoreIfMessage_BtsConnectProtocolResult other);

      bool operator==(const BmCoreIfMessage_BtsConnectProtocolResult& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BTSBDAddress& btsBdAddress)
      {
         _btsBdAddress = btsBdAddress;
      }

      inline const BTSBDAddress& getBdAddress(void) const
      {
         return _btsBdAddress;
      }

      inline void setRequestResult(IN const BTSRequestResult btsResult)
      {
         _btsResult = btsResult;
      }

      inline BTSRequestResult getRequestResult(void) const
      {
         return _btsResult;
      }

      inline void setProtocolId(IN const BTSProtocolId btsProtocolId)
      {
         _btsProtocolId = btsProtocolId;
      }

      inline BTSProtocolId getProtocolId(void) const
      {
         return _btsProtocolId;
      }

      inline void setSppUuid(IN const BTSUuid& btsSppUuid)
      {
         _btsSppUuid = btsSppUuid;
      }

      inline const BTSUuid& getSppUuid(void) const
      {
         return _btsSppUuid;
      }

      inline void setMasInstanceName(IN const BTSMasInstanceName& btsMasInstance)
      {
         _btsMasInstance = btsMasInstance;
      }

      inline const BTSMasInstanceName& getMasInstanceName(void) const
      {
         return _btsMasInstance;
      }

   private:
      BTSBDAddress       _btsBdAddress;
      BTSRequestResult   _btsResult;
      BTSProtocolId      _btsProtocolId;
      BTSUuid            _btsSppUuid;
      BTSMasInstanceName _btsMasInstance;
   };


   class BmCoreIfMessage_BtsRemoteProtocolConnectRequest : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsRemoteProtocolConnectRequest& first, BmCoreIfMessage_BtsRemoteProtocolConnectRequest& second);

      explicit BmCoreIfMessage_BtsRemoteProtocolConnectRequest();

      explicit BmCoreIfMessage_BtsRemoteProtocolConnectRequest(IN const BTSBDAddress& btsBdAddress,
            IN const BTSProtocolId btsProtocolId, IN const BTSUuid& btsSppUuid, IN const ActType act);

      BmCoreIfMessage_BtsRemoteProtocolConnectRequest(IN const BmCoreIfMessage_BtsRemoteProtocolConnectRequest& other);

      virtual ~BmCoreIfMessage_BtsRemoteProtocolConnectRequest();

      BmCoreIfMessage_BtsRemoteProtocolConnectRequest& operator=(BmCoreIfMessage_BtsRemoteProtocolConnectRequest other);

      bool operator==(const BmCoreIfMessage_BtsRemoteProtocolConnectRequest& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BTSBDAddress& btsBdAddress)
      {
         _btsBdAddress = btsBdAddress;
      }

      inline const BTSBDAddress& getBdAddress(void) const
      {
         return _btsBdAddress;
      }

      inline void setProtocolId(IN const BTSProtocolId btsProtocolId)
      {
         _btsProtocolId = btsProtocolId;
      }

      inline BTSProtocolId getProtocolId(void) const
      {
         return _btsProtocolId;
      }

      inline void setSppUuid(IN const BTSUuid& btsSppUuid)
      {
         _btsSppUuid = btsSppUuid;
      }

      inline const BTSUuid& getSppUuid(void) const
      {
         return _btsSppUuid;
      }

   private:
      BTSBDAddress       _btsBdAddress;
      BTSProtocolId      _btsProtocolId;
      BTSUuid            _btsSppUuid;
   };


   class BmCoreIfMessage_BtsDisconnectProtocolResult : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsDisconnectProtocolResult& first, BmCoreIfMessage_BtsDisconnectProtocolResult& second);

      explicit BmCoreIfMessage_BtsDisconnectProtocolResult();

      explicit BmCoreIfMessage_BtsDisconnectProtocolResult(IN const BTSBDAddress& btsBdAddress,
            IN const BTSRequestResult btsResult, IN const BTSProtocolId btsProtocolId, IN const BTSUuid& btsSppUuid,
            IN const BTSMasInstanceName& btsMasInstance, IN const ActType act);

      BmCoreIfMessage_BtsDisconnectProtocolResult(IN const BmCoreIfMessage_BtsDisconnectProtocolResult& other);

      virtual ~BmCoreIfMessage_BtsDisconnectProtocolResult();

      BmCoreIfMessage_BtsDisconnectProtocolResult& operator=(BmCoreIfMessage_BtsDisconnectProtocolResult other);

      bool operator==(const BmCoreIfMessage_BtsDisconnectProtocolResult& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BTSBDAddress& btsBdAddress)
      {
         _btsBdAddress = btsBdAddress;
      }

      inline const BTSBDAddress& getBdAddress(void) const
      {
         return _btsBdAddress;
      }

      inline void setRequestResult(IN const BTSRequestResult btsResult)
      {
         _btsResult = btsResult;
      }

      inline BTSRequestResult getRequestResult(void) const
      {
         return _btsResult;
      }

      inline void setProtocolId(IN const BTSProtocolId btsProtocolId)
      {
         _btsProtocolId = btsProtocolId;
      }

      inline BTSProtocolId getProtocolId(void) const
      {
         return _btsProtocolId;
      }

      inline void setSppUuid(IN const BTSUuid& btsSppUuid)
      {
         _btsSppUuid = btsSppUuid;
      }

      inline const BTSUuid& getSppUuid(void) const
      {
         return _btsSppUuid;
      }

      inline void setMasInstanceName(IN const BTSMasInstanceName& btsMasInstance)
      {
         _btsMasInstance = btsMasInstance;
      }

      inline const BTSMasInstanceName& getMasInstanceName(void) const
      {
         return _btsMasInstance;
      }

   private:
      BTSBDAddress       _btsBdAddress;
      BTSRequestResult   _btsResult;
      BTSProtocolId      _btsProtocolId;
      BTSUuid            _btsSppUuid;
      BTSMasInstanceName _btsMasInstance;
   };


   class BmCoreIfMessage_BtsDisconnectDeviceResult : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsDisconnectDeviceResult& first, BmCoreIfMessage_BtsDisconnectDeviceResult& second);

      explicit BmCoreIfMessage_BtsDisconnectDeviceResult();

      explicit BmCoreIfMessage_BtsDisconnectDeviceResult(IN const BTSBDAddress& btsBdAddress,
            IN const BTSRequestResult btsResult, IN const ActType act);

      BmCoreIfMessage_BtsDisconnectDeviceResult(IN const BmCoreIfMessage_BtsDisconnectDeviceResult& other);

      virtual ~BmCoreIfMessage_BtsDisconnectDeviceResult();

      BmCoreIfMessage_BtsDisconnectDeviceResult& operator=(BmCoreIfMessage_BtsDisconnectDeviceResult other);

      bool operator==(const BmCoreIfMessage_BtsDisconnectDeviceResult& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BTSBDAddress& btsBdAddress)
      {
         _btsBdAddress = btsBdAddress;
      }

      inline const BTSBDAddress& getBdAddress(void) const
      {
         return _btsBdAddress;
      }

      inline void setRequestResult(IN const BTSRequestResult btsResult)
      {
         _btsResult = btsResult;
      }

      inline BTSRequestResult getRequestResult(void) const
      {
         return _btsResult;
      }

   private:
      BTSBDAddress       _btsBdAddress;
      BTSRequestResult   _btsResult;
   };


   class BmCoreIfMessage_BtsProtocolConnectionStatus : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsProtocolConnectionStatus& first, BmCoreIfMessage_BtsProtocolConnectionStatus& second);

      explicit BmCoreIfMessage_BtsProtocolConnectionStatus();

      explicit BmCoreIfMessage_BtsProtocolConnectionStatus(IN const BTSBDAddress& btsBdAddress,
            IN const BTSConnectionStatus btsConnectionStatus, IN const BTSDisconnectReason btsDisconnectReason,
            IN const BTSProtocolId btsProtocolId, IN const BTSUuid& btsSppUuid,
            IN const BTSMasInstanceName& btsMasInstance, IN const BTSDeviceName& btsRfCommDevice,
            IN const ActType act);

      BmCoreIfMessage_BtsProtocolConnectionStatus(IN const BmCoreIfMessage_BtsProtocolConnectionStatus& other);

      virtual ~BmCoreIfMessage_BtsProtocolConnectionStatus();

      BmCoreIfMessage_BtsProtocolConnectionStatus& operator=(BmCoreIfMessage_BtsProtocolConnectionStatus other);

      bool operator==(const BmCoreIfMessage_BtsProtocolConnectionStatus& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BTSBDAddress& btsBdAddress)
      {
         _btsBdAddress = btsBdAddress;
      }

      inline const BTSBDAddress& getBdAddress(void) const
      {
         return _btsBdAddress;
      }

      inline void setConnectionStatus(IN const BTSConnectionStatus btsConnectionStatus)
      {
         _btsConnectionStatus = btsConnectionStatus;
      }

      inline BTSConnectionStatus getConnectionStatus(void) const
      {
         return _btsConnectionStatus;
      }

      inline void setDisconnectReason(IN const BTSDisconnectReason btsDisconnectReason)
      {
         _btsDisconnectReason = btsDisconnectReason;
      }

      inline BTSDisconnectReason getDisconnectReason(void) const
      {
         return _btsDisconnectReason;
      }

      inline void setProtocolId(IN const BTSProtocolId btsProtocolId)
      {
         _btsProtocolId = btsProtocolId;
      }

      inline BTSProtocolId getProtocolId(void) const
      {
         return _btsProtocolId;
      }

      inline void setSppUuid(IN const BTSUuid& btsSppUuid)
      {
         _btsSppUuid = btsSppUuid;
      }

      inline const BTSUuid& getSppUuid(void) const
      {
         return _btsSppUuid;
      }

      inline void setMasInstanceName(IN const BTSMasInstanceName& btsMasInstance)
      {
         _btsMasInstance = btsMasInstance;
      }

      inline const BTSMasInstanceName& getMasInstanceName(void) const
      {
         return _btsMasInstance;
      }

      inline void setRfCommDevice(IN const BTSDeviceName& btsRfCommDevice)
      {
         _btsRfCommDevice = btsRfCommDevice;
      }

      inline const BTSDeviceName& getRfCommDevice(void) const
      {
         return _btsRfCommDevice;
      }

   private:
      BTSBDAddress        _btsBdAddress;
      BTSConnectionStatus _btsConnectionStatus;
      BTSDisconnectReason _btsDisconnectReason;
      BTSProtocolId       _btsProtocolId;
      BTSUuid             _btsSppUuid;
      BTSMasInstanceName  _btsMasInstance;
      BTSDeviceName       _btsRfCommDevice;
   };


   class BmCoreIfMessage_BtsDeviceConnectionStatus : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsDeviceConnectionStatus& first, BmCoreIfMessage_BtsDeviceConnectionStatus& second);

      explicit BmCoreIfMessage_BtsDeviceConnectionStatus();

      explicit BmCoreIfMessage_BtsDeviceConnectionStatus(IN const BTSBDAddress& btsBdAddress,
            IN const BTSConnectionStatus btsConnectionStatus, IN const BTSDisconnectReason btsDisconnectReason,
            IN const ActType act);

      BmCoreIfMessage_BtsDeviceConnectionStatus(IN const BmCoreIfMessage_BtsDeviceConnectionStatus& other);

      virtual ~BmCoreIfMessage_BtsDeviceConnectionStatus();

      BmCoreIfMessage_BtsDeviceConnectionStatus& operator=(BmCoreIfMessage_BtsDeviceConnectionStatus other);

      bool operator==(const BmCoreIfMessage_BtsDeviceConnectionStatus& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BTSBDAddress& btsBdAddress)
      {
         _btsBdAddress = btsBdAddress;
      }

      inline const BTSBDAddress& getBdAddress(void) const
      {
         return _btsBdAddress;
      }

      inline void setConnectionStatus(IN const BTSConnectionStatus btsConnectionStatus)
      {
         _btsConnectionStatus = btsConnectionStatus;
      }

      inline BTSConnectionStatus getConnectionStatus(void) const
      {
         return _btsConnectionStatus;
      }

      inline void setDisconnectReason(IN const BTSDisconnectReason btsDisconnectReason)
      {
         _btsDisconnectReason = btsDisconnectReason;
      }

      inline BTSDisconnectReason getDisconnectReason(void) const
      {
         return _btsDisconnectReason;
      }

   private:
      BTSBDAddress        _btsBdAddress;
      BTSConnectionStatus _btsConnectionStatus;
      BTSDisconnectReason _btsDisconnectReason;
   };


   class BmCoreIfMessage_BtsLinkQualityResult : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsLinkQualityResult& first, BmCoreIfMessage_BtsLinkQualityResult& second);

      explicit BmCoreIfMessage_BtsLinkQualityResult();

      explicit BmCoreIfMessage_BtsLinkQualityResult(IN const BTSBDAddress& btsBdAddress, IN const BTSRequestResult btsResult,
            IN const BTSRssi btsRssi, IN const BTSLinkQuality btsLinkQuality, IN const ActType act);

      BmCoreIfMessage_BtsLinkQualityResult(IN const BmCoreIfMessage_BtsLinkQualityResult& other);

      virtual ~BmCoreIfMessage_BtsLinkQualityResult();

      BmCoreIfMessage_BtsLinkQualityResult& operator=(BmCoreIfMessage_BtsLinkQualityResult other);

      bool operator==(const BmCoreIfMessage_BtsLinkQualityResult& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBdAddress(IN const BTSBDAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BTSBDAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setResult(IN const BTSRequestResult btsResult)
      {
         _btsResult = btsResult;
      }

      inline BTSRequestResult getResult(void) const
      {
         return _btsResult;
      }

      inline void setRssi(IN const BTSRssi btsRssi)
      {
         _btsRssi = btsRssi;
      }

      inline BTSRssi getRssi(void) const
      {
         return _btsRssi;
      }

      inline void setLinkQuality(IN const BTSLinkQuality btsLinkQuality)
      {
         _btsLinkQuality = btsLinkQuality;
      }

      inline BTSLinkQuality getLinkQuality(void) const
      {
         return _btsLinkQuality;
      }

   private:
      BTSBDAddress     _bdAddress;
      BTSRequestResult _btsResult;
      BTSRssi          _btsRssi;
      BTSLinkQuality   _btsLinkQuality;
   };


   class BmCoreIfMessage_BtsStartTestModeResult : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsStartTestModeResult& first, BmCoreIfMessage_BtsStartTestModeResult& second);

      explicit BmCoreIfMessage_BtsStartTestModeResult();

      explicit BmCoreIfMessage_BtsStartTestModeResult(IN const BTSRequestResult requestResult, IN const ActType act);

      BmCoreIfMessage_BtsStartTestModeResult(IN const BmCoreIfMessage_BtsStartTestModeResult& other);

      virtual ~BmCoreIfMessage_BtsStartTestModeResult();

      BmCoreIfMessage_BtsStartTestModeResult& operator=(BmCoreIfMessage_BtsStartTestModeResult other);

      bool operator==(const BmCoreIfMessage_BtsStartTestModeResult& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setRequestResult(IN const BTSRequestResult requestResult)
      {
         _requestResult = requestResult;
      }

      inline BTSRequestResult getRequestResult(void) const
      {
         return _requestResult;
      }

   private:
      BTSRequestResult _requestResult;
   };


   class BmCoreIfMessage_BtsStopTestModeResult : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsStopTestModeResult& first, BmCoreIfMessage_BtsStopTestModeResult& second);

      explicit BmCoreIfMessage_BtsStopTestModeResult();

      explicit BmCoreIfMessage_BtsStopTestModeResult(IN const BTSRequestResult requestResult, IN const ActType act);

      BmCoreIfMessage_BtsStopTestModeResult(IN const BmCoreIfMessage_BtsStopTestModeResult& other);

      virtual ~BmCoreIfMessage_BtsStopTestModeResult();

      BmCoreIfMessage_BtsStopTestModeResult& operator=(BmCoreIfMessage_BtsStopTestModeResult other);

      bool operator==(const BmCoreIfMessage_BtsStopTestModeResult& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setRequestResult(IN const BTSRequestResult requestResult)
      {
         _requestResult = requestResult;
      }

      inline BTSRequestResult getRequestResult(void) const
      {
         return _requestResult;
      }

   private:
      BTSRequestResult _requestResult;
   };


   class BmCoreIfMessage_BtsTestModeStatus : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsTestModeStatus& first, BmCoreIfMessage_BtsTestModeStatus& second);

      explicit BmCoreIfMessage_BtsTestModeStatus();

      explicit BmCoreIfMessage_BtsTestModeStatus(IN const BTSBDAddress& deviceAddress,
            IN const BTSConnectionStatus connectionStatus, IN const ActType act);

      BmCoreIfMessage_BtsTestModeStatus(IN const BmCoreIfMessage_BtsTestModeStatus& other);

      virtual ~BmCoreIfMessage_BtsTestModeStatus();

      BmCoreIfMessage_BtsTestModeStatus& operator=(BmCoreIfMessage_BtsTestModeStatus other);

      bool operator==(const BmCoreIfMessage_BtsTestModeStatus& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDeviceAddress(IN const BTSBDAddress& deviceAddress)
      {
         _deviceAddress = deviceAddress;
      }

      inline const BTSBDAddress& getDeviceAddress(void) const
      {
         return _deviceAddress;
      }

      inline void setConnectionStatus(IN const BTSConnectionStatus connectionStatus)
      {
         _connectionStatus = connectionStatus;
      }

      inline const BTSConnectionStatus& getConnectionStatus(void) const
      {
         return _connectionStatus;
      }

   private:
      BTSBDAddress        _deviceAddress;
      BTSConnectionStatus _connectionStatus;
   };


   class BmCoreIfMessage_BtsFbWblInitialized : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsFbWblInitialized& first, BmCoreIfMessage_BtsFbWblInitialized& second);

      explicit BmCoreIfMessage_BtsFbWblInitialized();

      explicit BmCoreIfMessage_BtsFbWblInitialized(IN const BTSRequestResult requestResult, IN const ActType act);

      BmCoreIfMessage_BtsFbWblInitialized(IN const BmCoreIfMessage_BtsFbWblInitialized& other);

      virtual ~BmCoreIfMessage_BtsFbWblInitialized();

      BmCoreIfMessage_BtsFbWblInitialized& operator=(BmCoreIfMessage_BtsFbWblInitialized other);

      bool operator==(const BmCoreIfMessage_BtsFbWblInitialized& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setRequestResult(IN const BTSRequestResult requestResult)
      {
         _requestResult = requestResult;
      }

      inline BTSRequestResult getRequestResult(void) const
      {
         return _requestResult;
      }

   private:
      BTSRequestResult _requestResult;
   };

   class BmCoreIfMessage_BtsWblServiceAvailability : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsWblServiceAvailability& first, BmCoreIfMessage_BtsWblServiceAvailability& second);

      explicit BmCoreIfMessage_BtsWblServiceAvailability();

      explicit BmCoreIfMessage_BtsWblServiceAvailability(IN const bool wblServiceAvailable,
            IN const ActType act);

      BmCoreIfMessage_BtsWblServiceAvailability(IN const BmCoreIfMessage_BtsWblServiceAvailability& other);

      virtual ~BmCoreIfMessage_BtsWblServiceAvailability();

      BmCoreIfMessage_BtsWblServiceAvailability& operator=(BmCoreIfMessage_BtsWblServiceAvailability other);

      bool operator==(const BmCoreIfMessage_BtsWblServiceAvailability& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setWblServiceAvailable(IN const bool wblServiceAvailable)
      {
         _wblServiceAvailable = wblServiceAvailable;
      }

      inline const bool& getWblServiceAvailable(void) const
      {
         return _wblServiceAvailable;
      }

   private:
      bool _wblServiceAvailable;
   };

   class BmCoreIfMessage_BtsWblLastIntendedMode : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsWblLastIntendedMode& first, BmCoreIfMessage_BtsWblLastIntendedMode& second);

      explicit BmCoreIfMessage_BtsWblLastIntendedMode();

      explicit BmCoreIfMessage_BtsWblLastIntendedMode(IN const BTSWblLastIntendedModeList& lastIntendedModeList,
            IN const ActType act);

      BmCoreIfMessage_BtsWblLastIntendedMode(IN const BmCoreIfMessage_BtsWblLastIntendedMode& other);

      virtual ~BmCoreIfMessage_BtsWblLastIntendedMode();

      BmCoreIfMessage_BtsWblLastIntendedMode& operator=(BmCoreIfMessage_BtsWblLastIntendedMode other);

      bool operator==(const BmCoreIfMessage_BtsWblLastIntendedMode& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setAccessPointStatusList(IN const BTSWblLastIntendedModeList& lastIntendedModeList)
      {
         _lastIntendedModeList = lastIntendedModeList;
      }

      inline const BTSWblLastIntendedModeList& getAccessPointStatusList(void) const
      {
         return _lastIntendedModeList;
      }

   private:
      BTSWblLastIntendedModeList _lastIntendedModeList;
   };

   class BmCoreIfMessage_BtsWblSupportedFrequencies : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsWblSupportedFrequencies& first, BmCoreIfMessage_BtsWblSupportedFrequencies& second);

      explicit BmCoreIfMessage_BtsWblSupportedFrequencies();

      explicit BmCoreIfMessage_BtsWblSupportedFrequencies(IN const BTSWblSupportedRestrictionEntryList& supportedFrequenciesList,
            IN const ActType act);

      BmCoreIfMessage_BtsWblSupportedFrequencies(IN const BmCoreIfMessage_BtsWblSupportedFrequencies& other);

      virtual ~BmCoreIfMessage_BtsWblSupportedFrequencies();

      BmCoreIfMessage_BtsWblSupportedFrequencies& operator=(BmCoreIfMessage_BtsWblSupportedFrequencies other);

      bool operator==(const BmCoreIfMessage_BtsWblSupportedFrequencies& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setSupportedFrequenciesList(IN const BTSWblSupportedRestrictionEntryList& supportedFrequenciesList)
      {
    	  _supportedFrequenciesList = supportedFrequenciesList;
      }

      inline const BTSWblSupportedRestrictionEntryList& getSupportedFrequenciesList(void) const
      {
         return _supportedFrequenciesList;
      }

   private:
      BTSWblSupportedRestrictionEntryList _supportedFrequenciesList;
   };

   class BmCoreIfMessage_BtsWblHealthinessIndicator : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtsWblHealthinessIndicator& first, BmCoreIfMessage_BtsWblHealthinessIndicator& second);

      explicit BmCoreIfMessage_BtsWblHealthinessIndicator();

      explicit BmCoreIfMessage_BtsWblHealthinessIndicator(IN const BTSWblHealthinessIndicator& wblHealthinessIndicator,
            IN const ActType act);

      BmCoreIfMessage_BtsWblHealthinessIndicator(IN const BmCoreIfMessage_BtsWblHealthinessIndicator& other);

      virtual ~BmCoreIfMessage_BtsWblHealthinessIndicator();

      BmCoreIfMessage_BtsWblHealthinessIndicator& operator=(BmCoreIfMessage_BtsWblHealthinessIndicator other);

      bool operator==(const BmCoreIfMessage_BtsWblHealthinessIndicator& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setWblHealthinessIndicator(IN const BTSWblHealthinessIndicator& wblHealthinessIndicator)
      {
         _wblHealthinessIndicator = wblHealthinessIndicator;
      }

      inline const BTSWblHealthinessIndicator& getWblHealthinessIndicator(void) const
      {
         return _wblHealthinessIndicator;
      }

   private:
      BTSWblHealthinessIndicator _wblHealthinessIndicator;
   };


   class BmCoreIfMessage_BtSystemState : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_BtSystemState& first, BmCoreIfMessage_BtSystemState& second);

      explicit BmCoreIfMessage_BtSystemState();

      explicit BmCoreIfMessage_BtSystemState(IN const BtSystemState btSystemState, IN const ActType act,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      BmCoreIfMessage_BtSystemState(IN const BmCoreIfMessage_BtSystemState& other);

      virtual ~BmCoreIfMessage_BtSystemState();

      BmCoreIfMessage_BtSystemState& operator=(BmCoreIfMessage_BtSystemState other);

      bool operator==(const BmCoreIfMessage_BtSystemState& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setBtSystemState(IN const BtSystemState btSystemState)
      {
    	  _btSystemState = btSystemState;
      }

      inline const BtSystemState getBtSystemState(void) const
      {
         return _btSystemState;
      }

   private:
      BtSystemState _btSystemState;
   };

   // *****************************************************************************************
   // ******************** Messages corresponding to BM Core internal calls *******************
   // *****************************************************************************************

   class BmCoreIfMessage_TerminateMessageHandlerThread : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_TerminateMessageHandlerThread& first, BmCoreIfMessage_TerminateMessageHandlerThread& second);

      explicit BmCoreIfMessage_TerminateMessageHandlerThread();

      BmCoreIfMessage_TerminateMessageHandlerThread(IN const BmCoreIfMessage_TerminateMessageHandlerThread& other);

      virtual ~BmCoreIfMessage_TerminateMessageHandlerThread();

      BmCoreIfMessage_TerminateMessageHandlerThread& operator=(BmCoreIfMessage_TerminateMessageHandlerThread other);

      bool operator==(const BmCoreIfMessage_TerminateMessageHandlerThread& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;
   };


   class BmCoreIfMessage_SetDeviceRemoteConnectable : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_SetDeviceRemoteConnectable& first, BmCoreIfMessage_SetDeviceRemoteConnectable& second);

      explicit BmCoreIfMessage_SetDeviceRemoteConnectable();

      explicit BmCoreIfMessage_SetDeviceRemoteConnectable(IN const DeviceId deviceHandle,
            IN const RemoteConnectable remoteConnectable, IN const ActType act,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      BmCoreIfMessage_SetDeviceRemoteConnectable(IN const BmCoreIfMessage_SetDeviceRemoteConnectable& other);

      virtual ~BmCoreIfMessage_SetDeviceRemoteConnectable();

      BmCoreIfMessage_SetDeviceRemoteConnectable& operator=(BmCoreIfMessage_SetDeviceRemoteConnectable other);

      bool operator==(const BmCoreIfMessage_SetDeviceRemoteConnectable& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setDeviceHandle(IN const DeviceId deviceHandle)
      {
         _deviceHandle = deviceHandle;
      }

      inline DeviceId getDeviceHandle(void) const
      {
         return _deviceHandle;
      }

      inline void setRemoteConnectable(IN const RemoteConnectable remoteConnectable)
      {
         _remoteConnectable = remoteConnectable;
      }

      inline RemoteConnectable getRemoteConnectable(void) const
      {
         return _remoteConnectable;
      }

   private:
      DeviceId _deviceHandle;
      RemoteConnectable _remoteConnectable;
   };

   // *****************************************************************************************
   // ******************** Messages corresponding to SM timer callback ************************
   // *****************************************************************************************
   class BmCoreIfMessage_SmTimeout : public BmCoreIfMessage
   {
   public:

      friend void swap(BmCoreIfMessage_SmTimeout& first, BmCoreIfMessage_SmTimeout& second);

      explicit BmCoreIfMessage_SmTimeout();

      explicit BmCoreIfMessage_SmTimeout(IN const char* message);

      BmCoreIfMessage_SmTimeout(IN const BmCoreIfMessage_SmTimeout& other);

      virtual ~BmCoreIfMessage_SmTimeout();

      BmCoreIfMessage_SmTimeout& operator=(BmCoreIfMessage_SmTimeout other);

      bool operator==(const BmCoreIfMessage_SmTimeout& rhs) const;

      virtual BmCoreIfMessage* clone(void) const;

      virtual void traceMessage(void) const;

      inline void setMessage(IN const char* message)
      {
         if(0 != message)
         {
            _message = message;
         }
      }

      inline const char* getMessage(void) const
      {
         return _message.c_str();
      }

   private:
      ::std::string _message;
   };
}

#endif // _BM_CORE_IF_MESSAGES_H_
