#ifndef _BM_CORE_IF_MESSAGE_H_
#define _BM_CORE_IF_MESSAGE_H_

//#include "CcInterfaceTypesInternal.h"
#include "BmAllTypesInternal.h"

namespace bmcore
{
   // class forward declarations
   class BmCoreCallbackIf;

   /**
    *
    */
   class BmCoreIfMessage
   {
   public:
      static inline unsigned int getBmCoreIfMessageCount(void)
      {
         return _countBmCoreIfMessages;
      }

      explicit BmCoreIfMessage(IN const BmCoreIfMsgId messageId, IN const FunctionalityRestrictionInfo restrictionInfo,
            IN const ActType act, IN const BmCoreIfMsgOrigin origin);

      BmCoreIfMessage(IN const BmCoreIfMessage& other);

      virtual ~BmCoreIfMessage();

      BmCoreIfMessage& operator=(BmCoreIfMessage other);

      bool operator==(const BmCoreIfMessage& rhs) const;

      friend void swap(BmCoreIfMessage& first, BmCoreIfMessage& second);

      inline BmCoreIfMsgId getMessageId(void) const
      {
         return _messageId;
      }

      inline const FunctionalityRestrictionInfo getRestrictionInfo(void) const
      {
         return _restrictionInfo;
      }

      inline void setAct(IN const ActType act)
      {
         _act = act;
      }

      inline ActType getAct(void) const
      {
         return _act;
      }

      inline void setOrigin(IN const BmCoreIfMsgOrigin origin)
      {
         _origin = origin;
      }

      inline BmCoreIfMsgOrigin getOrigin(void) const
      {
         return _origin;
      }

      virtual BmCoreIfMessage* clone(void) const
      {
         std::terminate();
      }

      virtual void traceMessage(void) const;

   protected:
      static unsigned int _countBmCoreIfMessages;
      BmCoreIfMsgId                _messageId;
      ActType                  _act;
      FunctionalityRestrictionInfo _restrictionInfo;
      BmCoreIfMsgOrigin            _origin;
   };
}

#endif // _BM_CORE_IF_MESSAGE_H_
