//########################################################################
// (C)  Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Config_h)
#define FeatStd_Config_h

#if defined(FEATSTD_CUSTOM_CONFIG)
    #include "hmibase/view/Bosch_CGI_Config.h"
#endif

/// @addtogroup FEATSTD_CONFIG
/// @{

// -----------------------------------------------------------------------------
// Operating system defines
// -----------------------------------------------------------------------------
/** Operating system string, like Win32, Posix (aka. Linux), etc., to be used with FEATSTD_STRINGIZE(). */
#define FEATSTD_OS Posix

/** Operating system define, denoting in the suffix the operating system chosen via CMAKE_SYSTEM_NAME. */
#define FEATSTD_OS_POSIX

/* #undef FEATSTD_64BIT_PLATFORM */

// HMIBase modified: for Gen3 and Gen4
#if (defined (GEN4INTEL) || defined (GEN4ARM) || defined (GEN4LSIM) || defined(_LINUXX86_64_))
#define FEATSTD_64BIT_PLATFORM
#else
#define FEATSTD_32BIT_PLATFORM
#endif


// -----------------------------------------------------------------------------
// Feature defines based on FeatStd CMake features
// -----------------------------------------------------------------------------

/** Enables the additional StringBuffer AppendObject method and the StringBufferAppender template. StringBufferAppender implementations
    for specific types like enum, struct or class types have to be provided by the more specific library/application code (manually or generated).
    These implementations are only valid if FEATSTD_STRINGBUFFER_APPENDER_ENABLED is defined. */
#define FEATSTD_STRINGBUFFER_APPENDER_ENABLED

/** Defines the maximum size of one candera type used with string buffer appender. */
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
#define FEATSTD_STRINGBUFFER_APPENDER_CANDERATYPESIZE 64
#endif

/** Defines the maximum length of a single log message. */
#if !defined(FEATSTD_LOGGER_MAX_BUFFER_SIZE)
#define FEATSTD_LOGGER_MAX_BUFFER_SIZE 2048
#endif

/** Enables IPC functionality, like IPC channels, etc. */
/* #undef FEATSTD_IPC_ENABLED */

/** Enable logging functionality. 
    @note If disabled all logging defines are expanded empty and all logging classes (e.g. Appender) will not be available.
          This means the application which uses e.g. Appender has to scope this usage with FEATSTD_LOG_ENABLED. */
#define FEATSTD_LOG_ENABLED

/** Enable glGetError and eglGetError calls.*/
/* #undef FEATSTD_GLERRORS_AND_EGLERRORS_ENABLED */

/** Activate support for system memory allocation statistics. ATTENTION: Activated memory statistics may decrease performance! */
/* #undef FEATSTD_SYSTEM_MEMORY_STATISTIC_ENABLED */

/** Activate file name and line number generation for memory allocation statistic. */
/* #undef FEATSTD_SYSTEM_MEMORY_STATISTIC_FILE_AND_LINE_TRACKING_ENABLED */

/** Enables monitor module. */
/* #undef FEATSTD_MONITOR_ENABLED */

/** Activate thread safety for various FeatStd modules like logging, etc. */
#define FEATSTD_THREADSAFETY_ENABLED

/** Activate unit test framework support */
/* #undef FEATSTD_UNITTEST_FRAMEWORK_ENABLED */

/** Defines for replacing datatype Float with fractional number type. */
/* #undef FEATSTD_FIXED_POINT_ARITHMETIC */

/** Define the number of fractional bits, which can be either 12 (20 integer and 12 fractional bits) or 16 (16 integer and 16 fractional bits). */
/* #undef FEATSTD_FIXED_POINT_FRACTIONAL_BITS */

/** Support Diagnostic Log and Trace. */
/* #undef FEATSTD_DLT_ENABLED */

// -----------------------------------------------------------------------------

/** Enable optional component MemoryPool.
    MemoryPool is an optional component of FeatStd. */ 
/* #undef FEATSTD_MEMORYPOOL_ENABLED */

/** \def FEATSTD_ENABLE_MEMORYPOOL_ALLOCATIONS
    \brief Enable MemoryPool allocations for FeatStd. 
    All heap allocations will be done through memory pool FeatStd. Requires
    correct initialization of FeatStd memory pool. */
#if defined(FEATSTD_MEMORYPOOL_ENABLED)
#   define FEATSTD_ENABLE_MEMORYPOOL_ALLOCATIONS
#endif

/** Defines MemoryPool features for debug build mode */
/* #undef FEATSTD_MEMORYPOOL_FEATURES_DEBUG */
/** Defines MemoryPool features for debug release mode */
/* #undef FEATSTD_MEMORYPOOL_FEATURES_RELEASE */
/** Defines MemoryPool features for minimal size build mode */
/* #undef FEATSTD_MEMORYPOOL_FEATURES_MINSIZEREL */
/** Defines MemoryPool features for release with debugging info build mode */
/* #undef FEATSTD_MEMORYPOOL_FEATURES_RELWITHDEBINFO */

// -----------------------------------------------------------------------------
/** \def FEATSTD_TOOLCHAIN_HAS_BUILTIN_ATOMICOP
    \brief Tells about availability of builtin atomic operations
    The build system checks during configure step if the toolchain supports
    builting atomic operations. The check is mainly targeting GCC compiler.
    If the toolchain does not support, it might be that the operating system
    has support. If not, slow GenericAtomicOp implementation will be used. */
/* #undef FEATSTD_TOOLCHAIN_HAS_BUILTIN_ATOMICOP */

// -----------------------------------------------------------------------------
// Build mode dependant defines
// -----------------------------------------------------------------------------
/** Build mode macros - FEATSTD_BUILD_MODE_DEBUG
    this build mode enables FeatStd debugging facilities. The macro FEATSTD_DEBUG will be
    defined. */
#define FEATSTD_BUILD_MODE_DEBUG            1

/** Build mode macros - FEATSTD_BUILD_MODE_RELEASE
    this build mode disables FeatStd debugging facilities  The macro FEATSTD_NODEBUG will be
    defined. */
#define FEATSTD_BUILD_MODE_RELEASE          2

/** Build mode macros - FEATSTD_BUILD_MODE_MINSIZEREL
    this build mode disables FeatStd debugging facilities  The macro FEATSTD_NODEBUG will be
    defined. */
#define FEATSTD_BUILD_MODE_MINSIZEREL       3

/** Build mode macros - FEATSTD_BUILD_MODE_RELWITHDEBINFO
    this build mode disables FeatStd debugging facilities  The macro FEATSTD_NODEBUG will be
    defined. */
#define FEATSTD_BUILD_MODE_RELWITHDEBINFO   4

/*  If lint is run, FEATSTD_BUILD_MODE might not be defined. In case define
    FEATSTD_BUILD_MODE to FEATSTD_BUILD_MODE_RELEASE */
#if defined(_lint)
    #if !defined(FEATSTD_BUILD_MODE)
        #define FEATSTD_BUILD_MODE FEATSTD_BUILD_MODE_RELEASE
    #endif
#endif

#if FEATSTD_BUILD_MODE == FEATSTD_BUILD_MODE_DEBUG
    /** FEATSTD_DEBUG indicates that the build shall include FeatStd debugging facilities */
    #define FEATSTD_DEBUG    1
    #if !defined(_DEBUG)
       #define _DEBUG 1
    #endif
    #if defined(FEATSTD_NODEBUG)
        #undef FEATSTD_NODEBUG
    #endif
    #if defined(NDEBUG)
        #undef NDEBUG
    #endif

#elif FEATSTD_BUILD_MODE == FEATSTD_BUILD_MODE_RELEASE || FEATSTD_BUILD_MODE == FEATSTD_BUILD_MODE_MINSIZEREL || FEATSTD_BUILD_MODE == FEATSTD_BUILD_MODE_RELWITHDEBINFO
    /** FEATSTD_NODEBUG indicates that the build shall not include FeatStd debugging facilities */
    #define FEATSTD_NODEBUG 1
    #if !defined(NDEBUG)
        #define NDEBUG 1
    #endif
    #if defined(FEATSTD_DEBUG)
        #undef FEATSTD_DEBUG
    #endif
    #if defined(_DEBUG)
        #undef _DEBUG
    #endif
#else
    #error "Build mode FEATSTD_BUILD_MODE is unknown or undefined."
#endif

// -----------------------------------------------------------------------------
// Platform specific defines
// -----------------------------------------------------------------------------

/** defined if toolchain auto detection has been activated in FeatStd cmake build system */
/* #undef FEATSTD_TOOLCHAIN_AUTO_DETECTION */

#if defined(FEATSTD_TOOLCHAIN_AUTO_DETECTION)

    /** Defines the platform FEATSTD is built for. */
#   define FEATSTD_PLATFORM 

    /** Defines the platform name FEATSTD is built for. */
#   define FEATSTD_PLATFORM_NAME ""

    /** Defines the platform configuration FEATSTD is built for. */
#   define FEATSTD_PLATFORM_CONFIG 

    /** Defines the location for the platform specific header files. */
#   define FEATSTD_PLATFORM_INC_PATH 

    /**
       <summary>Gets the family FEATSTD toochain identifier.</summary>
     */
#   define FEATSTD_TOOLCHAIN_FAMILY_ID_

    /**
       <summary>Gets the primary FEATSTD toochain identifier.</summary>
     */
#   define FEATSTD_TOOLCHAIN_FAMILY 

    /**
       <summary>Gets the FEATSTD toochain identifier.</summary>
     */
#   define FEATSTD_TOOLCHAIN_ID_

    /**
       <summary>Gets the FEATSTD toochain identifier.</summary>
     */
#   define FEATSTD_TOOLCHAIN 

    /**
       <summary>Gets the FEATSTD toochain identifier.</summary>
     */
#   define FEATSTD_TOOLCHAIN_VERSION 

    /**
       <summary>Operating system from build system auto-detection.</summary>
     */
#   define FEATSTD_PLATFORM_OS 

    /**
       <summary>Operating system from build system auto-detection.</summary>
     */
#   define FEATSTD_PLATFORM_OS_

    /**
       <summary>Controller architecture from build system auto-detection.</summary>
     */
#   define FEATSTD_PLATFORM_ARCH 

    /**
       <summary>Controller architecture from build system auto-detection.</summary>
     */
#   define FEATSTD_PLATFORM_ARCH_

#else

#   define FEATSTD_PLATFORM Unknown
#   define FEATSTD_PLATFORM_NAME "Unknown"
#   define FEATSTD_PLATFORM_CONFIG Unknown
#   define FEATSTD_PLATFORM_INC_PATH Unknown

#   if defined(__ghs__)
#       define FEATSTD_TOOLCHAIN_FAMILY_ID_GreenHills
#       define FEATSTD_TOOLCHAIN_FAMILY GreenHills
#       define FEATSTD_TOOLCHAIN_ID_GreenHills
#       define FEATSTD_TOOLCHAIN GreenHills
#   elif defined(__GNUC__)
#       define FEATSTD_TOOLCHAIN_FAMILY_ID_GCC
#       define FEATSTD_TOOLCHAIN_FAMILY GCC
#       define FEATSTD_TOOLCHAIN_ID_gcc
#       define FEATSTD_TOOLCHAIN gcc
#   elif defined(_MSC_VER)
#       define FEATSTD_TOOLCHAIN_FAMILY_ID_MSVC
#       define FEATSTD_TOOLCHAIN_FAMILY MSVC
#       define FEATSTD_TOOLCHAIN_ID_MSVC
#       define FEATSTD_TOOLCHAIN MSVC
#   endif

#   define FEATSTD_TOOLCHAIN_VERSION 
#   define FEATSTD_PLATFORM_OS Posix
#   define FEATSTD_PLATFORM_OS_Posix
#   define FEATSTD_PLATFORM_ARCH Unknown
#   define FEATSTD_PLATFORM_ARCH_Unknown
#endif


/** FEATSTD_LIKELY and FEATSTD_UNLIKELY supports conditional branch prediction instrumentation for selected tool chains
    Some tool chains (eg. gcc) support conditional branch prediction instrumentation.
    Conditions that are likely evaluating to 
    true, should be instrumented with
    FEATSTD_LIKELY. Typical usage scenarions are error checking code fragments.
    @param expr a regular C/C++ expression (avoid any side effects in expression)
    @code
        Char *buf = new Char[100];
        if (FEATSTD_LIKELY(buf != 0)) {
            ...
        }
    @endcode
    In the code sample above FEATSTD_LIKELY indicates to the tool chain, that
    in most cases the error condition check will fail. */
///@{
#define FEATSTD_LIKELY(expr)    
#define FEATSTD_UNLIKELY(expr)  
///@}

/** Marks functions as deprecated.
    Selected tool chains will report usage of functions / types marked as deprecated.
    @param msg a message to report when a deprecated entity has been used
    @code
    class Bar {
        public:
            int FEATSTD_DEPRECATED Foo();
    };

    struct FEATSTD_DEPRECATED_MSG("Please use BarFoo") FooBar {
    };
    @endcode*/
#define FEATSTD_DEPRECATED 

/** See FEATSTD_DEPRECATED
    Mark functions / types as deprecated with an explanatory message
    @param msg explanatory message */
#define FEATSTD_DEPRECATED_MSG(msg) 

/** Selected tool chains will issue a warning if function return value has not been checked
    @code
        void* FEATSTD_WARN_UNUSED_RESULT Alloc()
        {
            ...
        }
    @endcode */
#define FEATSTD_WARN_UNUSED_RESULT 

/** Some compilers (e.g. GHS MULTI) have problems when linking libraries that have been compiled in different source paths 
    but include the same FeatStd headers which use __FILE__ macro. This leads to a warning that two symbols have different 
    sizes because __FILE__ has expanded to different paths.
    For GCC or Multi compiler e.g. compiler define '-DFEATSTD__FILE__=__BASE_FILE__' could be used to avoid this. */
#if !defined(FEATSTD__FILE__)
    #define FEATSTD__FILE__     __FILE__
#endif
/// @}
#endif
