//########################################################################
// (C)  Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

// This header exists to guarantee backwards compatibility of compile switches for CGI-Studio Courier V3.0.0

#if !defined(COURIER_DEPRECATED_H)
    #define COURIER_DEPRECATED_H

#if defined(_MSC_VER)
    #define _COURIER_WARNING(msg) \
        __pragma(msg)
#elif defined(__GNUC__) || defined(__MINGW32__) || defined(__ghs__)
    #define _COURIER_WARNING(msg) \
        _Pragma(msg)
#else 
    #define _COURIER_WARNING(msg) ;
#endif


/// @addtogroup COURIER_CONFIG
/// @{

/* #undef COURIER_IPC_ENABLED */
#if defined(COURIER_IPC_ENABLED) && !defined(FEATSTD_IPC_ENABLED)
    #define FEATSTD_IPC_ENABLED
    _COURIER_WARNING("WARNING: Use of COURIER_IPC_ENABLED is deprecated, use FEATSTD_IPC_ENABLED instead")
#endif

/// @}

#endif  // COURIER_DEPRECATED_H
