//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

//  ------------------------------------------------------------------------
//  **** This file is generated by Courier build system. Do not modify! ****
//  ------------------------------------------------------------------------

#if !defined(Courier_Config_h)
#define Courier_Config_h

#include <FeatStd/Config.h>

/// @addtogroup COURIER_CONFIG
/// @{

// -----------------------------------------------------------------------------
// Courier defines based on FeatStd CMake features
// -----------------------------------------------------------------------------

/** Enable data binding and visualization, which enables Candera graphics engine support. */
#define COURIER_ENHANCED_ENABLED

/** Enable messaging monitor. */
/* #undef COURIER_MESSAGING_MONITOR_ENABLED */

/** Enable rendering monitor. */
/* #undef COURIER_RENDERING_MONITOR_ENABLED */

/** Enable the data lock. */
/* #undef COURIER_DATA_LOCK_ENABLED */

/** Enable message serialization. */
/* #undef COURIER_MESSAGE_SERIALIZATION_ENABLED */

#ifdef FEATSTD_IPC_ENABLED
#ifndef COURIER_MESSAGE_SERIALIZATION_ENABLED
#define COURIER_MESSAGE_SERIALIZATION_ENABLED
#endif
#endif

/** Enable Courier support in Candera LUA Scripting. */
/* #undef COURIER_SCRIPTING_ENABLED */

// -----------------------------------------------------------------------------
// Application specifics
// -----------------------------------------------------------------------------
/* #undef COURIER_COMPONENT_CUSTOM_TYPES */

// -----------------------------------------------------------------------------
// Platform specific defines
// -----------------------------------------------------------------------------
/** Defines the platform Courier is built for. */
#define COURIER_PLATFORM GeniviPlatform

/** Defines the platform name Courier is built for. */
#define COURIER_PLATFORM_NAME "GeniviPlatform"

/** Defines the platform configuration Courier is built for. */
#define COURIER_PLATFORM_CONFIG Linux_ARM

/** Defines the location for the platform specific header files. */
#define COURIER_PLATFORM_INC_PATH CourierPlatformDefs/GeniviPlatform/Linux_ARM

/**
   <summary>Gets the courier toochain identifier.</summary>
 */
#define COURIER_TOOLCHAIN_ID_gcc

/** COURIER_LIKELY and COURIER_UNLIKELY supports conditional branch prediction instrumentation for selected tool chains
    Some tool chains (eg. gcc) support conditional branch prediction instrumentation.
    Conditions that are likely evaluating to true, should be instrumented with
    COURIER_LIKELY. Typical usage scenarions are error checking code fragments.
    @param expr a regular C/C++ expression (avoid any side effects in expression)
    @code
        Char *buf = new Char[100];
        if (COURIER_LIKELY(buf != 0)) {
            ...
        }
    @endcode
    In the code sample above COURIER_LIKELY indicates to the tool chain, that
    in most cases the error condition check will fail. */
///@{
#define COURIER_LIKELY(expr)    __builtin_expect(!!(expr), 1)
#define COURIER_UNLIKELY(expr)  __builtin_expect(!!(expr), 0)
///@}

/** Marks functions as deprecated.
    Selected tool chains will report usage of functions / types marked as deprecated.
    @param msg a message to report when a deprecated entity has been used
    @code
    class Bar {
        public:
            int COURIER_DEPRECATED Foo();
    };

    struct COURIER_DEPRECATED_MSG("Please use BarFoo") FooBar {
    };
    @endcode*/
#define COURIER_DEPRECATED __attribute__((deprecated))

/** See COURIER_DEPRECATED
    Mark functions / types as deprecated with an explanatory message
    @param msg explanatory message */
#define COURIER_DEPRECATED_MSG(msg) __attribute__((deprecated))

/** Selected tool chains will issue a warning if function return value has not been checked
    @code
        void* COURIER_WARN_UNUSED_RESULT Alloc()
        {
            ...
        }
    @endcode */
#define COURIER_WARN_UNUSED_RESULT __attribute__((warn_unused_result))

#include <Courier/CourierDeprecated.h>

/*  If lint is run, FEATSTD_BUILD_MODE might not be defined. In case define
    FEATSTD_BUILD_MODE to FEATSTD_BUILD_MODE_RELEASE */
#if defined(_lint)
#   if !defined(FEATSTD_BUILD_MODE)
#       error "Unknown build mode " FEATSTD_STRINGIZE(FEATSTD_BUILD_MODE) "."
#       define FEATSTD_BUILD_MODE FEATSTD_BUILD_MODE_RELEASE
#   endif
#endif

#ifdef FEATSTD_DEBUG
    /** COURIER_DEBUG indicates that the build shall include Courier debugging facilities */
#   define COURIER_DEBUG    1
#   if !defined(_DEBUG)
#      define _DEBUG 1
#   endif
#   if defined(COURIER_NODEBUG)
#       undef COURIER_NODEBUG
#   endif
#   if defined(NDEBUG)
#       undef NDEBUG
#   endif

#else
    /** COURIER_NODEBUG indicates that the build shall not include Courier debugging facilities */
#   define COURIER_NODEBUG 1
#   if !defined(NDEBUG)
#       define NDEBUG 1
#   endif
#   if defined(COURIER_DEBUG)
#       undef COURIER_DEBUG
#   endif
#   if defined(_DEBUG)
#       undef _DEBUG
#   endif
#endif

/// @}



#endif
